/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.method;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.ResourceMetadataKeyEnum;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.rest.annotation.History;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.client.BaseHttpClientInvocation;
import ca.uhn.fhir.rest.method.BaseResourceReturningMethodBinding;
import ca.uhn.fhir.rest.method.HttpGetClientInvocation;
import ca.uhn.fhir.rest.method.IParameter;
import ca.uhn.fhir.rest.method.MethodUtil;
import ca.uhn.fhir.rest.method.RequestDetails;
import ca.uhn.fhir.rest.server.IBundleProvider;
import ca.uhn.fhir.rest.server.IResourceProvider;
import ca.uhn.fhir.rest.server.IRestfulServer;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class HistoryMethodBinding
extends BaseResourceReturningMethodBinding {
    private final Integer myIdParamIndex;
    private String myResourceName;
    private final RestOperationTypeEnum myResourceOperationType;

    public HistoryMethodBinding(Method theMethod, FhirContext theContext, Object theProvider) {
        super(HistoryMethodBinding.toReturnType(theMethod, theProvider), theMethod, theContext, theProvider);
        this.myIdParamIndex = MethodUtil.findIdParameterIndex(theMethod, this.getContext());
        History historyAnnotation = theMethod.getAnnotation(History.class);
        Class<IBaseResource> type = historyAnnotation.type();
        if (Modifier.isInterface(type.getModifiers())) {
            if (theProvider instanceof IResourceProvider) {
                type = ((IResourceProvider)theProvider).getResourceType();
                this.myResourceOperationType = this.myIdParamIndex != null ? RestOperationTypeEnum.HISTORY_INSTANCE : RestOperationTypeEnum.HISTORY_TYPE;
            } else {
                this.myResourceOperationType = RestOperationTypeEnum.HISTORY_SYSTEM;
            }
        } else {
            this.myResourceOperationType = this.myIdParamIndex != null ? RestOperationTypeEnum.HISTORY_INSTANCE : RestOperationTypeEnum.HISTORY_TYPE;
        }
        this.myResourceName = type != IResource.class ? theContext.getResourceDefinition(type).getName() : null;
    }

    @Override
    public RestOperationTypeEnum getRestOperationType() {
        return this.myResourceOperationType;
    }

    @Override
    protected BundleTypeEnum getResponseBundleType() {
        return BundleTypeEnum.HISTORY;
    }

    @Override
    public BaseResourceReturningMethodBinding.ReturnTypeEnum getReturnType() {
        return BaseResourceReturningMethodBinding.ReturnTypeEnum.BUNDLE;
    }

    @Override
    public boolean incomingServerRequestMatchesMethod(RequestDetails theRequest) {
        boolean wantIdParam;
        if (!"_history".equals(theRequest.getOperation())) {
            return false;
        }
        if (theRequest.getResourceName() == null) {
            return this.myResourceOperationType == RestOperationTypeEnum.HISTORY_SYSTEM;
        }
        if (!StringUtils.equals((CharSequence)theRequest.getResourceName(), (CharSequence)this.myResourceName)) {
            return false;
        }
        boolean haveIdParam = theRequest.getId() != null && !theRequest.getId().isEmpty();
        boolean bl = wantIdParam = this.myIdParamIndex != null;
        if (haveIdParam != wantIdParam) {
            return false;
        }
        if (theRequest.getId() == null) {
            return this.myResourceOperationType == RestOperationTypeEnum.HISTORY_TYPE;
        }
        return !theRequest.getId().hasVersionIdPart();
    }

    @Override
    public BaseHttpClientInvocation invokeClient(Object[] theArgs) throws InternalErrorException {
        IdDt id = null;
        String resourceName = this.myResourceName;
        if (this.myIdParamIndex != null && ((id = (IdDt)theArgs[this.myIdParamIndex]) == null || StringUtils.isBlank((CharSequence)id.getValue()))) {
            throw new NullPointerException("ID can not be null");
        }
        String historyId = id != null ? id.getIdPart() : null;
        HttpGetClientInvocation retVal = HistoryMethodBinding.createHistoryInvocation(this.getContext(), resourceName, historyId, null, null);
        if (theArgs != null) {
            for (int idx = 0; idx < theArgs.length; ++idx) {
                IParameter nextParam = this.getParameters().get(idx);
                nextParam.translateClientArgumentIntoQueryArgument(this.getContext(), theArgs[idx], retVal.getParameters(), null);
            }
        }
        return retVal;
    }

    @Override
    public IBundleProvider invokeServer(IRestfulServer<?> theServer, RequestDetails theRequest, Object[] theMethodParams) throws InvalidRequestException, InternalErrorException {
        if (this.myIdParamIndex != null) {
            theMethodParams[this.myIdParamIndex.intValue()] = theRequest.getId();
        }
        Object response = this.invokeServerMethod(theServer, theRequest, theMethodParams);
        final IBundleProvider resources = this.toResourceList(response);
        return new IBundleProvider(){

            @Override
            public InstantDt getPublished() {
                return resources.getPublished();
            }

            @Override
            public List<IBaseResource> getResources(int theFromIndex, int theToIndex) {
                List<IBaseResource> retVal = resources.getResources(theFromIndex, theToIndex);
                int index = theFromIndex;
                for (IBaseResource nextResource : retVal) {
                    IdDt versionId;
                    if (nextResource.getIdElement() == null || StringUtils.isBlank((CharSequence)nextResource.getIdElement().getIdPart())) {
                        throw new InternalErrorException("Server provided resource at index " + index + " with no ID set (using IResource#setId(IdDt))");
                    }
                    if (StringUtils.isBlank((CharSequence)nextResource.getIdElement().getVersionIdPart()) && nextResource instanceof IResource && ((versionId = ResourceMetadataKeyEnum.VERSION_ID.get((IResource)nextResource)) == null || versionId.isEmpty())) {
                        throw new InternalErrorException("Server provided resource at index " + index + " with no Version ID set (using IResource#setId(IdDt))");
                    }
                    ++index;
                }
                return retVal;
            }

            @Override
            public int size() {
                return resources.size();
            }

            @Override
            public Integer preferredPageSize() {
                return null;
            }
        };
    }

    public static HttpGetClientInvocation createHistoryInvocation(FhirContext theContext, String theResourceName, String theId, IPrimitiveType<Date> theSince, Integer theLimit) {
        StringBuilder b = new StringBuilder();
        if (theResourceName != null) {
            b.append(theResourceName);
            if (StringUtils.isNotBlank((CharSequence)theId)) {
                b.append('/');
                b.append(theId);
            }
        }
        if (b.length() > 0) {
            b.append('/');
        }
        b.append("_history");
        boolean haveParam = false;
        if (theSince != null && !theSince.isEmpty()) {
            haveParam = true;
            b.append('?').append("_since").append('=').append(theSince.getValueAsString());
        }
        if (theLimit != null) {
            b.append(haveParam ? (char)'&' : '?');
            b.append("_count").append('=').append(theLimit);
        }
        HttpGetClientInvocation retVal = new HttpGetClientInvocation(theContext, b.toString());
        return retVal;
    }

    private static Class<? extends IBaseResource> toReturnType(Method theMethod, Object theProvider) {
        if (theProvider instanceof IResourceProvider) {
            return ((IResourceProvider)theProvider).getResourceType();
        }
        History historyAnnotation = theMethod.getAnnotation(History.class);
        Class<? extends IResource> type = historyAnnotation.type();
        if (type != IResource.class) {
            return type;
        }
        return null;
    }
}

