/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.Bundle;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.api.MethodOutcome;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.client.exceptions.InvalidResponseException;
import ca.uhn.fhir.rest.method.BaseMethodBinding;
import ca.uhn.fhir.rest.method.IParameter;
import ca.uhn.fhir.rest.method.MethodUtil;
import ca.uhn.fhir.rest.method.RequestDetails;
import ca.uhn.fhir.rest.server.EncodingEnum;
import ca.uhn.fhir.rest.server.IBundleProvider;
import ca.uhn.fhir.rest.server.IRestfulServer;
import ca.uhn.fhir.rest.server.IVersionSpecificBundleFactory;
import ca.uhn.fhir.rest.server.RestfulServerUtils;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.rest.server.interceptor.IServerInterceptor;
import ca.uhn.fhir.util.BundleUtil;
import ca.uhn.fhir.util.ReflectionUtil;
import ca.uhn.fhir.util.UrlUtil;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseResourceReturningMethodBinding
extends BaseMethodBinding<Object> {
    protected static final Set<String> ALLOWED_PARAMS;
    private static final Logger ourLog;
    private MethodReturnTypeEnum myMethodReturnType;
    private Class<?> myResourceListCollectionType;
    private String myResourceName;
    private Class<? extends IBaseResource> myResourceType;
    private List<Class<? extends IBaseResource>> myPreferTypesList;

    public BaseResourceReturningMethodBinding(Class<?> theReturnResourceType, Method theMethod, FhirContext theContext, Object theProvider) {
        super(theMethod, theContext, theProvider);
        Class<?> methodReturnType = theMethod.getReturnType();
        if (Collection.class.isAssignableFrom(methodReturnType)) {
            this.myMethodReturnType = MethodReturnTypeEnum.LIST_OF_RESOURCES;
            Class<?> collectionType = ReflectionUtil.getGenericCollectionTypeOfMethodReturnType(theMethod);
            if (collectionType != null && !Object.class.equals(collectionType) && !IBaseResource.class.isAssignableFrom(collectionType)) {
                throw new ConfigurationException("Method " + theMethod.getDeclaringClass().getSimpleName() + "#" + theMethod.getName() + " returns an invalid collection generic type: " + collectionType);
            }
            this.myResourceListCollectionType = collectionType;
        } else if (IBaseResource.class.isAssignableFrom(methodReturnType)) {
            this.myMethodReturnType = !Modifier.isAbstract(methodReturnType.getModifiers()) && theContext.getResourceDefinition(methodReturnType).isBundle() ? MethodReturnTypeEnum.BUNDLE_RESOURCE : MethodReturnTypeEnum.RESOURCE;
        } else if (Bundle.class.isAssignableFrom(methodReturnType)) {
            this.myMethodReturnType = MethodReturnTypeEnum.BUNDLE;
        } else if (IBundleProvider.class.isAssignableFrom(methodReturnType)) {
            this.myMethodReturnType = MethodReturnTypeEnum.BUNDLE_PROVIDER;
        } else if (MethodOutcome.class.isAssignableFrom(methodReturnType)) {
            this.myMethodReturnType = MethodReturnTypeEnum.METHOD_OUTCOME;
        } else {
            throw new ConfigurationException("Invalid return type '" + methodReturnType.getCanonicalName() + "' on method '" + theMethod.getName() + "' on type: " + theMethod.getDeclaringClass().getCanonicalName());
        }
        if (theReturnResourceType != null && IBaseResource.class.isAssignableFrom(theReturnResourceType) && !Modifier.isAbstract(theReturnResourceType.getModifiers()) && !Modifier.isInterface(theReturnResourceType.getModifiers())) {
            this.myResourceType = theReturnResourceType;
            this.myResourceName = theContext.getResourceDefinition(this.myResourceType).getName();
        }
        this.myPreferTypesList = this.createPreferTypesList();
    }

    public MethodReturnTypeEnum getMethodReturnType() {
        return this.myMethodReturnType;
    }

    @Override
    public String getResourceName() {
        return this.myResourceName;
    }

    protected abstract BundleTypeEnum getResponseBundleType();

    public abstract ReturnTypeEnum getReturnType();

    @Override
    public Object invokeClient(String theResponseMimeType, Reader theResponseReader, int theResponseStatusCode, Map<String, List<String>> theHeaders) {
        IParser parser = this.createAppropriateParserForParsingResponse(theResponseMimeType, theResponseReader, theResponseStatusCode, this.myPreferTypesList);
        switch (this.getReturnType()) {
            case BUNDLE: {
                Bundle dstu1bundle = null;
                IBaseBundle dstu2bundle = null;
                List<IBaseResource> listOfResources = null;
                if (this.getMethodReturnType() == MethodReturnTypeEnum.BUNDLE || this.getContext().getVersion().getVersion() == FhirVersionEnum.DSTU1) {
                    dstu1bundle = this.myResourceType != null ? parser.parseBundle(this.myResourceType, theResponseReader) : parser.parseBundle(theResponseReader);
                    listOfResources = dstu1bundle.toListOfResources();
                } else {
                    Class type = this.getContext().getResourceDefinition("Bundle").getImplementingClass();
                    dstu2bundle = (IBaseBundle)parser.parseResource(type, theResponseReader);
                    listOfResources = BundleUtil.toListOfResources(this.getContext(), dstu2bundle);
                }
                switch (this.getMethodReturnType()) {
                    case BUNDLE: {
                        return dstu1bundle;
                    }
                    case BUNDLE_RESOURCE: {
                        return dstu2bundle;
                    }
                    case LIST_OF_RESOURCES: {
                        if (this.myResourceListCollectionType != null) {
                            Iterator<IResource> iter = listOfResources.iterator();
                            while (iter.hasNext()) {
                                IBaseResource next = iter.next();
                                if (this.myResourceListCollectionType.isAssignableFrom(next.getClass())) continue;
                                ourLog.debug("Not returning resource of type {} because it is not a subclass or instance of {}", next.getClass(), this.myResourceListCollectionType);
                                iter.remove();
                            }
                        }
                        return listOfResources;
                    }
                    case RESOURCE: {
                        List<IResource> list = dstu1bundle.toListOfResources();
                        if (list.size() == 0) {
                            return null;
                        }
                        if (list.size() == 1) {
                            return list.get(0);
                        }
                        throw new InvalidResponseException(theResponseStatusCode, "FHIR server call returned a bundle with multiple resources, but this method is only able to returns one.");
                    }
                    case BUNDLE_PROVIDER: {
                        throw new IllegalStateException("Return type of " + IBundleProvider.class.getSimpleName() + " is not supported in clients");
                    }
                }
                break;
            }
            case RESOURCE: {
                IBaseResource resource = this.myResourceType != null ? parser.parseResource(this.myResourceType, theResponseReader) : parser.parseResource(theResponseReader);
                MethodUtil.parseClientRequestResourceHeaders(null, theHeaders, resource);
                switch (this.getMethodReturnType()) {
                    case BUNDLE: {
                        return Bundle.withSingleResource((IResource)resource);
                    }
                    case LIST_OF_RESOURCES: {
                        return Collections.singletonList(resource);
                    }
                    case RESOURCE: {
                        return resource;
                    }
                    case BUNDLE_PROVIDER: {
                        throw new IllegalStateException("Return type of " + IBundleProvider.class.getSimpleName() + " is not supported in clients");
                    }
                    case BUNDLE_RESOURCE: {
                        return resource;
                    }
                    case METHOD_OUTCOME: {
                        MethodOutcome retVal = new MethodOutcome();
                        retVal.setOperationOutcome((IBaseOperationOutcome)resource);
                        return retVal;
                    }
                }
                break;
            }
        }
        throw new IllegalStateException("Should not get here!");
    }

    private List<Class<? extends IBaseResource>> createPreferTypesList() {
        ArrayList preferTypes = null;
        if (this.myResourceListCollectionType != null && IBaseResource.class.isAssignableFrom(this.myResourceListCollectionType)) {
            preferTypes = new ArrayList(1);
            preferTypes.add(this.myResourceListCollectionType);
        }
        return preferTypes;
    }

    @Override
    public Object invokeServer(IRestfulServer<?> theServer, RequestDetails theRequest) throws BaseServerResponseException, IOException {
        ResourceOrDstu1Bundle responseObject = this.doInvokeServer(theServer, theRequest);
        Set<SummaryEnum> summaryMode = RestfulServerUtils.determineSummaryMode(theRequest);
        if (responseObject.getResource() != null) {
            for (int i = theServer.getInterceptors().size() - 1; i >= 0; --i) {
                IServerInterceptor next = theServer.getInterceptors().get(i);
                boolean continueProcessing = next.outgoingResponse(theRequest, responseObject.getResource());
                if (continueProcessing) continue;
                return null;
            }
            boolean prettyPrint = RestfulServerUtils.prettyPrintResponse(theServer, theRequest);
            return theRequest.getResponse().streamResponseAsResource(responseObject.getResource(), prettyPrint, summaryMode, 200, null, theRequest.isRespondGzip(), this.isAddContentLocationHeader());
        }
        String uaHeader = theRequest.getHeader("user-agent");
        boolean requestIsBrowser = false;
        if (uaHeader != null && uaHeader.contains("Mozilla")) {
            requestIsBrowser = true;
        }
        for (int i = theServer.getInterceptors().size() - 1; i >= 0; --i) {
            IServerInterceptor next = theServer.getInterceptors().get(i);
            boolean continueProcessing = next.outgoingResponse(theRequest, responseObject.getDstu1Bundle());
            if (continueProcessing) continue;
            ourLog.debug("Interceptor {} returned false, not continuing processing");
            return null;
        }
        return theRequest.getResponse().streamResponseAsBundle(responseObject.getDstu1Bundle(), summaryMode, theRequest.isRespondGzip(), requestIsBrowser);
    }

    public ResourceOrDstu1Bundle doInvokeServer(IRestfulServer<?> theServer, RequestDetails theRequest) {
        ResourceOrDstu1Bundle responseObject;
        Object[] params = new Object[this.getParameters().size()];
        for (int i = 0; i < this.getParameters().size(); ++i) {
            IParameter param = this.getParameters().get(i);
            if (param == null) continue;
            params[i] = param.translateQueryParametersIntoServerArgument(theRequest, this);
        }
        Object resultObj = this.invokeServer(theServer, theRequest, params);
        Integer count = RestfulServerUtils.extractCountParameter(theRequest);
        switch (this.getReturnType()) {
            case BUNDLE: {
                Integer offsetI;
                String serverBase = theRequest.getServerBaseForRequest();
                StringBuilder b = new StringBuilder();
                b.append(serverBase);
                if (StringUtils.isNotBlank((CharSequence)theRequest.getRequestPath())) {
                    b.append('/');
                    b.append(theRequest.getRequestPath());
                }
                if (theRequest.getRequestType() == RequestTypeEnum.GET) {
                    boolean first = true;
                    Map<String, String[]> parameters = theRequest.getParameters();
                    for (String nextParamName : new TreeSet<String>(parameters.keySet())) {
                        for (String nextParamValue : parameters.get(nextParamName)) {
                            if (first) {
                                b.append('?');
                                first = false;
                            } else {
                                b.append('&');
                            }
                            b.append(UrlUtil.escape(nextParamName));
                            b.append('=');
                            b.append(UrlUtil.escape(nextParamValue));
                        }
                    }
                }
                String linkSelf = b.toString();
                if (this.getMethodReturnType() == MethodReturnTypeEnum.BUNDLE_RESOURCE) {
                    InstantDt lastUpdated;
                    IBaseResource resource;
                    if (resultObj instanceof IBundleProvider) {
                        IBundleProvider result = (IBundleProvider)resultObj;
                        resource = result.getResources(0, 1).get(0);
                        lastUpdated = result.getPublished();
                    } else {
                        resource = (IBaseResource)resultObj;
                        lastUpdated = theServer.getFhirContext().getVersion().getLastUpdated(resource);
                    }
                    IVersionSpecificBundleFactory bundleFactory = theServer.getFhirContext().newBundleFactory();
                    bundleFactory.initializeWithBundleResource(resource);
                    bundleFactory.addRootPropertiesToBundle(null, theRequest.getFhirServerBase(), linkSelf, count, this.getResponseBundleType(), lastUpdated);
                    responseObject = new ResourceOrDstu1Bundle(resource);
                    break;
                }
                Set<Include> includes = this.getRequestIncludesFromParams(params);
                IBundleProvider result = (IBundleProvider)resultObj;
                if (count == null) {
                    count = result.preferredPageSize();
                }
                if ((offsetI = RestfulServerUtils.tryToExtractNamedParameter(theRequest, "_getpagesoffset")) == null || offsetI < 0) {
                    offsetI = 0;
                }
                int start = Math.max(0, Math.min(offsetI, result.size() - 1));
                IVersionSpecificBundleFactory bundleFactory = theServer.getFhirContext().newBundleFactory();
                RestfulServerUtils.ResponseEncoding responseEncoding = RestfulServerUtils.determineResponseEncodingNoDefault(theRequest, theServer.getDefaultResponseEncoding());
                EncodingEnum linkEncoding = theRequest.getParameters().containsKey("_format") && responseEncoding != null ? responseEncoding.getEncoding() : null;
                boolean prettyPrint = RestfulServerUtils.prettyPrintResponse(theServer, theRequest);
                bundleFactory.initializeBundleFromBundleProvider(theServer, result, linkEncoding, theRequest.getFhirServerBase(), linkSelf, prettyPrint, start, count, null, this.getResponseBundleType(), includes);
                Bundle bundle = bundleFactory.getDstu1Bundle();
                if (bundle != null) {
                    responseObject = new ResourceOrDstu1Bundle(bundle);
                    break;
                }
                IBaseResource resBundle = bundleFactory.getResourceBundle();
                responseObject = new ResourceOrDstu1Bundle(resBundle);
                break;
            }
            case RESOURCE: {
                IBundleProvider result = (IBundleProvider)resultObj;
                if (result.size() == 0) {
                    throw new ResourceNotFoundException(theRequest.getId());
                }
                if (result.size() > 1) {
                    throw new InternalErrorException("Method returned multiple resources");
                }
                IBaseResource resource = result.getResources(0, 1).get(0);
                responseObject = new ResourceOrDstu1Bundle(resource);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return responseObject;
    }

    public abstract Object invokeServer(IRestfulServer<?> var1, RequestDetails var2, Object[] var3) throws InvalidRequestException, InternalErrorException;

    protected boolean isAddContentLocationHeader() {
        return true;
    }

    protected void setResourceName(String theResourceName) {
        this.myResourceName = theResourceName;
    }

    static {
        ourLog = LoggerFactory.getLogger(BaseResourceReturningMethodBinding.class);
        HashSet<String> set = new HashSet<String>();
        set.add("_format");
        set.add("_narrative");
        set.add("_pretty");
        set.add("_sort");
        set.add("_sort:asc");
        set.add("_sort:desc");
        set.add("_count");
        set.add("_summary");
        set.add("_elements");
        set.add("_raw");
        ALLOWED_PARAMS = Collections.unmodifiableSet(set);
    }

    public static enum ReturnTypeEnum {
        BUNDLE,
        RESOURCE;

    }

    public static class ResourceOrDstu1Bundle {
        private final Bundle myDstu1Bundle;
        private final IBaseResource myResource;

        public ResourceOrDstu1Bundle(Bundle theBundle) {
            this.myDstu1Bundle = theBundle;
            this.myResource = null;
        }

        public ResourceOrDstu1Bundle(IBaseResource theResource) {
            this.myResource = theResource;
            this.myDstu1Bundle = null;
        }

        public Bundle getDstu1Bundle() {
            return this.myDstu1Bundle;
        }

        public IBaseResource getResource() {
            return this.myResource;
        }
    }

    public static enum MethodReturnTypeEnum {
        BUNDLE,
        BUNDLE_PROVIDER,
        BUNDLE_RESOURCE,
        LIST_OF_RESOURCES,
        METHOD_OUTCOME,
        RESOURCE;

    }
}

