/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.rest.annotation.Delete;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.VersionIdParam;
import ca.uhn.fhir.rest.method.BaseOutcomeReturningMethodBinding;
import ca.uhn.fhir.rest.method.MethodUtil;
import ca.uhn.fhir.rest.server.IResourceProvider;
import java.lang.reflect.Method;
import org.hl7.fhir.instance.model.api.IBaseResource;

public abstract class BaseOutcomeReturningMethodBindingWithResourceIdButNoResourceBody
extends BaseOutcomeReturningMethodBinding {
    private String myResourceName;
    private Integer myIdParameterIndex;

    public BaseOutcomeReturningMethodBindingWithResourceIdButNoResourceBody(Method theMethod, FhirContext theContext, Object theProvider, Class<?> theMethodAnnotationType, Class<? extends IBaseResource> theResourceTypeFromAnnotation) {
        super(theMethod, theContext, theMethodAnnotationType, theProvider);
        RuntimeResourceDefinition def;
        Class<? extends IBaseResource> resourceType = theResourceTypeFromAnnotation;
        if (resourceType != IBaseResource.class) {
            def = theContext.getResourceDefinition(resourceType);
            this.myResourceName = def.getName();
        } else if (theProvider != null && theProvider instanceof IResourceProvider) {
            def = theContext.getResourceDefinition(((IResourceProvider)theProvider).getResourceType());
            this.myResourceName = def.getName();
        } else {
            throw new ConfigurationException("Can not determine resource type for method '" + theMethod.getName() + "' on type " + theMethod.getDeclaringClass().getCanonicalName() + " - Did you forget to include the resourceType() value on the @" + Delete.class.getSimpleName() + " method annotation?");
        }
        this.myIdParameterIndex = MethodUtil.findIdParameterIndex(theMethod, this.getContext());
        if (this.myIdParameterIndex == null) {
            throw new ConfigurationException("Method '" + theMethod.getName() + "' on type '" + theMethod.getDeclaringClass().getCanonicalName() + "' has no parameter annotated with the @" + IdParam.class.getSimpleName() + " annotation");
        }
        Integer versionIdParameterIndex = MethodUtil.findVersionIdParameterIndex(theMethod);
        if (versionIdParameterIndex != null) {
            throw new ConfigurationException("Method '" + theMethod.getName() + "' on type '" + theMethod.getDeclaringClass().getCanonicalName() + "' has a parameter annotated with the @" + VersionIdParam.class.getSimpleName() + " annotation but delete methods may not have this annotation");
        }
    }

    @Override
    public String getResourceName() {
        return this.myResourceName;
    }

    protected Integer getIdParameterIndex() {
        return this.myIdParameterIndex;
    }
}

