/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.param.CompositeParam;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import java.lang.reflect.Constructor;
import java.util.List;

class BaseBinder<T> {
    private List<Class<? extends IQueryParameterType>> myCompositeTypes;
    private Constructor<? extends T> myConstructor;
    private final Class<? extends T> myType;

    public BaseBinder(Class<? extends T> theType, List<Class<? extends IQueryParameterType>> theCompositeTypes) {
        this.myType = theType;
        this.myCompositeTypes = theCompositeTypes;
        if (this.myType.equals(CompositeParam.class) && this.myCompositeTypes.size() != 2) {
            throw new ConfigurationException("Search parameter of type " + this.myType.getName() + " must have 2 composite types declared in parameter annotation, found " + theCompositeTypes.size());
        }
        try {
            Class[] types = new Class[this.myCompositeTypes.size()];
            for (int i = 0; i < this.myCompositeTypes.size(); ++i) {
                types[i] = Class.class;
            }
            this.myConstructor = this.myType.getConstructor(types);
        }
        catch (NoSuchMethodException e) {
            throw new ConfigurationException("Query parameter type " + theType.getName() + " has no constructor with types " + theCompositeTypes);
        }
    }

    public T newInstance() {
        try {
            Object[] args = new Object[this.myCompositeTypes.size()];
            for (int i = 0; i < this.myCompositeTypes.size(); ++i) {
                args[i] = this.myCompositeTypes.get(i);
            }
            T dt = this.myConstructor.newInstance(args);
            return dt;
        }
        catch (Exception e) {
            throw new InternalErrorException(e);
        }
    }
}

