/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.gclient;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.gclient.ICriterion;
import ca.uhn.fhir.rest.gclient.ICriterionInternal;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.param.ParamPrefixEnum;
import ca.uhn.fhir.rest.param.ParameterUtil;
import org.apache.commons.lang3.StringUtils;

class QuantityCriterion
implements ICriterion<QuantityClientParam>,
ICriterionInternal {
    private String myValue;
    private String myName;
    private String mySystem;
    private String myUnits;
    private ParamPrefixEnum myPrefix;

    public QuantityCriterion(String theParamName, ParamPrefixEnum thePrefix, String theValue, String theSystem, String theUnits) {
        this.myValue = theValue;
        this.myPrefix = thePrefix;
        this.myName = theParamName;
        this.mySystem = theSystem;
        this.myUnits = theUnits;
    }

    @Override
    public String getParameterName() {
        return this.myName;
    }

    @Override
    public String getParameterValue(FhirContext theContext) {
        StringBuilder b = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)this.myValue) || StringUtils.isNotBlank((CharSequence)this.mySystem) || StringUtils.isNotBlank((CharSequence)this.myUnits)) {
            if (this.myPrefix != null) {
                b.append(ParameterUtil.escapeWithDefault(this.myPrefix.getValueForContext(theContext)));
            }
            b.append(ParameterUtil.escapeWithDefault(this.myValue));
            b.append('|');
            b.append(ParameterUtil.escapeWithDefault(this.mySystem));
            b.append('|');
            b.append(ParameterUtil.escapeWithDefault(this.myUnits));
        }
        return b.toString();
    }
}

