/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.apache;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.client.BaseHttpClientInvocation;
import ca.uhn.fhir.rest.client.apache.ApacheHttpRequest;
import ca.uhn.fhir.rest.client.api.Header;
import ca.uhn.fhir.rest.client.api.HttpClientUtil;
import ca.uhn.fhir.rest.client.api.IHttpClient;
import ca.uhn.fhir.rest.client.api.IHttpRequest;
import ca.uhn.fhir.rest.server.Constants;
import ca.uhn.fhir.rest.server.EncodingEnum;
import ca.uhn.fhir.rest.server.RestfulServerUtils;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.util.CoverageIgnore;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.message.BasicNameValuePair;
import org.hl7.fhir.instance.model.api.IBaseBinary;

public class ApacheHttpClient
implements IHttpClient {
    private HttpClient myClient;
    private List<Header> myHeaders;
    private StringBuilder myUrl;
    private Map<String, List<String>> myIfNoneExistParams;
    private String myIfNoneExistString;
    private RequestTypeEnum myRequestType;

    public ApacheHttpClient(HttpClient theClient, StringBuilder theUrl, Map<String, List<String>> theIfNoneExistParams, String theIfNoneExistString, RequestTypeEnum theRequestType, List<Header> theHeaders) {
        this.myClient = theClient;
        this.myUrl = theUrl;
        this.myIfNoneExistParams = theIfNoneExistParams;
        this.myIfNoneExistString = theIfNoneExistString;
        this.myRequestType = theRequestType;
        this.myHeaders = theHeaders;
    }

    @Override
    public IHttpRequest createByteRequest(FhirContext theContext, String theContents, String theContentType, EncodingEnum theEncoding) {
        ByteArrayEntity entity = new ByteArrayEntity(theContents.getBytes(Constants.CHARSET_UTF8));
        ApacheHttpRequest retVal = this.createHttpRequest((HttpEntity)entity);
        this.addHeadersToRequest(retVal, theEncoding, theContext);
        retVal.addHeader("Content-Type", theContentType + "; charset=UTF-8");
        return retVal;
    }

    @Override
    public IHttpRequest createParamRequest(FhirContext theContext, Map<String, List<String>> theParams, EncodingEnum theEncoding) {
        ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
        for (Map.Entry<String, List<String>> nextParam : theParams.entrySet()) {
            List<String> value = nextParam.getValue();
            for (String s : value) {
                parameters.add((NameValuePair)new BasicNameValuePair(nextParam.getKey(), s));
            }
        }
        UrlEncodedFormEntity entity = this.createFormEntity(parameters);
        ApacheHttpRequest retVal = this.createHttpRequest((HttpEntity)entity);
        this.addHeadersToRequest(retVal, theEncoding, theContext);
        return retVal;
    }

    @CoverageIgnore
    private UrlEncodedFormEntity createFormEntity(List<NameValuePair> parameters) {
        try {
            return new UrlEncodedFormEntity(parameters, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalErrorException("Server does not support UTF-8 (should not happen)", (Throwable)e);
        }
    }

    @Override
    public IHttpRequest createBinaryRequest(FhirContext theContext, IBaseBinary theBinary) {
        ByteArrayEntity entity = new ByteArrayEntity(theBinary.getContent());
        ApacheHttpRequest retVal = this.createHttpRequest((HttpEntity)entity);
        this.addHeadersToRequest(retVal, null, theContext);
        retVal.addHeader("Content-Type", theBinary.getContentType());
        return retVal;
    }

    @Override
    public IHttpRequest createGetRequest(FhirContext theContext, EncodingEnum theEncoding) {
        ApacheHttpRequest retVal = this.createHttpRequest(null);
        this.addHeadersToRequest(retVal, theEncoding, theContext);
        return retVal;
    }

    public void addHeadersToRequest(ApacheHttpRequest theHttpRequest, EncodingEnum theEncoding, FhirContext theContext) {
        if (this.myHeaders != null) {
            for (Header next : this.myHeaders) {
                theHttpRequest.addHeader(next.getName(), next.getValue());
            }
        }
        theHttpRequest.addHeader("User-Agent", HttpClientUtil.createUserAgentString(theContext, "apache"));
        theHttpRequest.addHeader("Accept-Charset", "utf-8");
        theHttpRequest.addHeader("Accept-Encoding", "gzip");
        RestfulServerUtils.addAcceptHeaderToRequest(theEncoding, theHttpRequest, theContext);
    }

    private ApacheHttpRequest createHttpRequest(HttpEntity theEntity) {
        HttpRequestBase request = this.constructRequestBase(theEntity);
        ApacheHttpRequest result = new ApacheHttpRequest(this.myClient, request);
        this.addHeaderIfNoneExist(result);
        return result;
    }

    private void addHeaderIfNoneExist(IHttpRequest result) {
        StringBuilder b;
        if (this.myIfNoneExistParams != null) {
            BaseHttpClientInvocation.appendExtraParamsWithQuestionMark(this.myIfNoneExistParams, b, (b = this.newHeaderBuilder(this.myUrl)).indexOf("?") == -1);
            result.addHeader("If-None-Exist", b.toString());
        }
        if (this.myIfNoneExistString != null) {
            b.append((b = this.newHeaderBuilder(this.myUrl)).indexOf("?") == -1 ? (char)'?' : '&');
            b.append(this.myIfNoneExistString.substring(this.myIfNoneExistString.indexOf(63) + 1));
            result.addHeader("If-None-Exist", b.toString());
        }
    }

    private StringBuilder newHeaderBuilder(StringBuilder theUrlBase) {
        StringBuilder b = new StringBuilder();
        b.append((CharSequence)theUrlBase);
        if (theUrlBase.length() > 0 && theUrlBase.charAt(theUrlBase.length() - 1) == '/') {
            b.deleteCharAt(b.length() - 1);
        }
        return b;
    }

    private HttpRequestBase constructRequestBase(HttpEntity theEntity) {
        String url = this.myUrl.toString();
        switch (this.myRequestType) {
            case DELETE: {
                return new HttpDelete(url);
            }
            case PATCH: {
                HttpPatch httpPatch = new HttpPatch(url);
                httpPatch.setEntity(theEntity);
                return httpPatch;
            }
            case OPTIONS: {
                return new HttpOptions(url);
            }
            case POST: {
                HttpPost httpPost = new HttpPost(url);
                httpPost.setEntity(theEntity);
                return httpPost;
            }
            case PUT: {
                HttpPut httpPut = new HttpPut(url);
                httpPut.setEntity(theEntity);
                return httpPut;
            }
        }
        return new HttpGet(url);
    }
}

