/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.api;

import ca.uhn.fhir.model.api.BaseBundle;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.ResourceMetadataKeyEnum;
import ca.uhn.fhir.model.api.Tag;
import ca.uhn.fhir.model.api.TagList;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DecimalDt;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.XhtmlDt;
import ca.uhn.fhir.model.valueset.BundleEntrySearchModeEnum;
import ca.uhn.fhir.model.valueset.BundleEntryTransactionMethodEnum;
import ca.uhn.fhir.util.ElementUtil;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class BundleEntry
extends BaseBundle {
    private TagList myCategories;
    private InstantDt myDeletedAt;
    private StringDt myDeletedByEmail;
    private StringDt myDeletedByName;
    private StringDt myDeletedComment;
    private IdDt myDeletedResourceId;
    private CodeDt myDeletedResourceType;
    private StringDt myDeletedResourceVersion;
    private StringDt myLinkAlternate;
    private StringDt myLinkBase;
    private StringDt myLinkSearch;
    private StringDt myLinkSelf;
    private InstantDt myPublished;
    private IResource myResource;
    private DecimalDt myScore;
    private BoundCodeDt<BundleEntrySearchModeEnum> mySearchMode;
    private BoundCodeDt<BundleEntryTransactionMethodEnum> myTransactionOperation;
    private XhtmlDt mySummary;
    private StringDt myTitle;
    private InstantDt myUpdated;

    @Deprecated
    public Tag addCategory() {
        Tag retVal = new Tag();
        this.getCategories().add(retVal);
        return retVal;
    }

    public void addCategory(String theScheme, String theTerm, String theLabel) {
        this.getCategories().add(new Tag(theScheme, theTerm, theLabel));
    }

    public void addCategory(Tag theTag) {
        this.getCategories().add(theTag);
    }

    public TagList getCategories() {
        if (this.myCategories == null) {
            this.myCategories = new TagList();
        }
        return this.myCategories;
    }

    public InstantDt getDeletedAt() {
        if (this.myDeletedAt == null) {
            this.myDeletedAt = new InstantDt();
        }
        return this.myDeletedAt;
    }

    public StringDt getDeletedByEmail() {
        if (this.myDeletedByEmail == null) {
            this.myDeletedByEmail = new StringDt();
        }
        return this.myDeletedByEmail;
    }

    public StringDt getDeletedByName() {
        if (this.myDeletedByName == null) {
            this.myDeletedByName = new StringDt();
        }
        return this.myDeletedByName;
    }

    public StringDt getDeletedComment() {
        if (this.myDeletedComment == null) {
            this.myDeletedComment = new StringDt();
        }
        return this.myDeletedComment;
    }

    public IdDt getDeletedResourceId() {
        if (this.myDeletedResourceId == null) {
            this.myDeletedResourceId = new IdDt();
        }
        return this.myDeletedResourceId;
    }

    public CodeDt getDeletedResourceType() {
        if (this.myDeletedResourceType == null) {
            this.myDeletedResourceType = new CodeDt();
        }
        return this.myDeletedResourceType;
    }

    public StringDt getDeletedResourceVersion() {
        if (this.myDeletedResourceVersion == null) {
            this.myDeletedResourceVersion = new StringDt();
        }
        return this.myDeletedResourceVersion;
    }

    @Override
    @Deprecated
    public IdDt getId() {
        return super.getId();
    }

    public StringDt getLinkAlternate() {
        if (this.myLinkAlternate == null) {
            this.myLinkAlternate = new StringDt();
        }
        return this.myLinkAlternate;
    }

    @Deprecated
    public StringDt getLinkBase() {
        if (this.myLinkBase == null) {
            this.myLinkBase = new StringDt();
        }
        return this.myLinkBase;
    }

    public StringDt getLinkSearch() {
        if (this.myLinkSearch == null) {
            this.myLinkSearch = new StringDt();
        }
        return this.myLinkSearch;
    }

    public StringDt getLinkSelf() {
        if (this.myLinkSelf == null) {
            this.myLinkSelf = new StringDt();
        }
        return this.myLinkSelf;
    }

    public InstantDt getPublished() {
        if (this.myPublished == null) {
            this.myPublished = new InstantDt();
        }
        return this.myPublished;
    }

    public IResource getResource() {
        return this.myResource;
    }

    public DecimalDt getScore() {
        if (this.myScore == null) {
            this.myScore = new DecimalDt();
        }
        return this.myScore;
    }

    public XhtmlDt getSummary() {
        if (this.mySummary == null) {
            this.mySummary = new XhtmlDt();
        }
        return this.mySummary;
    }

    public StringDt getTitle() {
        if (this.myTitle == null) {
            this.myTitle = new StringDt();
        }
        return this.myTitle;
    }

    @Deprecated
    public InstantDt getUpdated() {
        InstantDt resourceUpdated;
        if (this.myUpdated == null) {
            this.myUpdated = new InstantDt();
        }
        if (this.myUpdated.isEmpty() && this.myResource != null && (resourceUpdated = ResourceMetadataKeyEnum.UPDATED.get(this.myResource)) != null && !resourceUpdated.isEmpty()) {
            return resourceUpdated;
        }
        return this.myUpdated;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.myDeletedResourceId, this.myDeletedResourceType, this.myDeletedResourceVersion, this.myDeletedAt, this.myScore, this.mySearchMode, this.myTransactionOperation, this.myCategories, this.myLinkAlternate, this.myLinkSelf, this.myPublished, this.myResource, this.mySummary, this.myTitle, this.myUpdated, this.myDeletedByEmail, this.myDeletedByName, this.myDeletedComment);
    }

    public void setDeleted(InstantDt theDeletedAt) {
        this.myDeletedAt = theDeletedAt;
    }

    public void setDeletedByEmail(StringDt theDeletedByEmail) {
        this.myDeletedByEmail = theDeletedByEmail;
    }

    public void setDeletedByName(StringDt theDeletedByName) {
        if (this.myDeletedByName == null) {
            this.myDeletedByName = new StringDt();
        }
        this.myDeletedByName = theDeletedByName;
    }

    public void setDeletedComment(StringDt theDeletedComment) {
        this.myDeletedComment = theDeletedComment;
    }

    public void setDeletedResourceId(IdDt theDeletedResourceId) {
        this.myDeletedResourceId = theDeletedResourceId;
    }

    public void setDeletedResourceType(CodeDt theDeletedResourceType) {
        this.myDeletedResourceType = theDeletedResourceType;
    }

    public void setDeletedResourceVersion(StringDt theDeletedResourceVersion) {
        this.myDeletedResourceVersion = theDeletedResourceVersion;
    }

    @Override
    @Deprecated
    public void setId(IdDt theId) {
        super.setId(theId);
    }

    public void setLinkAlternate(StringDt theLinkAlternate) {
        this.myLinkAlternate = theLinkAlternate;
    }

    @Deprecated
    public void setLinkBase(StringDt theLinkBase) {
        this.myLinkBase = theLinkBase;
    }

    public void setLinkSearch(StringDt theLinkSearch) {
        this.myLinkSearch = theLinkSearch;
    }

    public void setLinkSelf(StringDt theLinkSelf) {
        if (this.myLinkSelf == null) {
            this.myLinkSelf = new StringDt();
        }
        this.myLinkSelf = theLinkSelf;
    }

    public void setPublished(InstantDt thePublished) {
        Validate.notNull((Object)thePublished, (String)"Published may not be null", (Object[])new Object[0]);
        this.myPublished = thePublished;
    }

    public void setResource(IResource theResource) {
        this.myResource = theResource;
    }

    public void setScore(DecimalDt theScore) {
        this.myScore = theScore;
    }

    @Deprecated
    public void setUpdated(InstantDt theUpdated) {
        Validate.notNull((Object)theUpdated, (String)"Updated may not be null", (Object[])new Object[0]);
        this.myUpdated = theUpdated;
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        if (this.getResource() != null) {
            b.append("type", (Object)this.getResource().getClass().getSimpleName());
        } else {
            b.append((Object)"No resource");
        }
        b.append("id", (Object)this.getId());
        return b.toString();
    }

    public BoundCodeDt<BundleEntrySearchModeEnum> getSearchMode() {
        if (this.mySearchMode == null) {
            this.mySearchMode = new BoundCodeDt<BundleEntrySearchModeEnum>(BundleEntrySearchModeEnum.VALUESET_BINDER);
        }
        return this.mySearchMode;
    }

    public void setSearchMode(BoundCodeDt<BundleEntrySearchModeEnum> theSearchMode) {
        this.mySearchMode = theSearchMode;
    }

    public BoundCodeDt<BundleEntryTransactionMethodEnum> getTransactionMethod() {
        if (this.myTransactionOperation == null) {
            this.myTransactionOperation = new BoundCodeDt<BundleEntryTransactionMethodEnum>(BundleEntryTransactionMethodEnum.VALUESET_BINDER);
        }
        return this.myTransactionOperation;
    }

    public void setTransactionMethod(BoundCodeDt<BundleEntryTransactionMethodEnum> theTransactionOperation) {
        this.myTransactionOperation = theTransactionOperation;
    }
}

