/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.context;

import ca.uhn.fhir.context.BaseRuntimeDeclaredChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceBlockDefinition;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.hl7.fhir.instance.model.api.IBase;

public class RuntimeChildResourceBlockDefinition
extends BaseRuntimeDeclaredChildDefinition {
    private RuntimeResourceBlockDefinition myElementDef;
    private Class<? extends IBase> myResourceBlockType;
    private FhirContext myContext;

    public RuntimeChildResourceBlockDefinition(FhirContext theContext, Field theField, Child theChildAnnotation, Description theDescriptionAnnotation, String theElementName, Class<? extends IBase> theResourceBlockType) throws ConfigurationException {
        super(theField, theChildAnnotation, theDescriptionAnnotation, theElementName);
        this.myContext = theContext;
        this.myResourceBlockType = theResourceBlockType;
    }

    public RuntimeResourceBlockDefinition getChildByName(String theName) {
        if (this.getElementName().equals(theName)) {
            return this.getDefinition();
        }
        return null;
    }

    private RuntimeResourceBlockDefinition getDefinition() {
        return (RuntimeResourceBlockDefinition)this.myContext.getElementDefinition(this.myResourceBlockType);
    }

    @Override
    public String getChildNameByDatatype(Class<? extends IBase> theDatatype) {
        if (this.myResourceBlockType.equals(theDatatype)) {
            return this.getElementName();
        }
        return null;
    }

    @Override
    public BaseRuntimeElementDefinition<?> getChildElementDefinitionByDatatype(Class<? extends IBase> theDatatype) {
        if (this.myResourceBlockType.equals(theDatatype)) {
            return this.getDefinition();
        }
        return null;
    }

    @Override
    public Set<String> getValidChildNames() {
        return Collections.singleton(this.getElementName());
    }

    @Override
    void sealAndInitialize(FhirContext theContext, Map<Class<? extends IBase>, BaseRuntimeElementDefinition<?>> theClassToElementDefinitions) {
    }
}

