/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.context;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeChildDeclaredExtensionDefinition;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;

public abstract class BaseRuntimeElementDefinition<T extends IBase> {
    private static final Class<Void> VOID_CLASS = Void.class;
    private Map<Class<?>, Constructor<T>> myConstructors = Collections.synchronizedMap(new HashMap());
    private List<RuntimeChildDeclaredExtensionDefinition> myExtensions = new ArrayList<RuntimeChildDeclaredExtensionDefinition>();
    private List<RuntimeChildDeclaredExtensionDefinition> myExtensionsModifier = new ArrayList<RuntimeChildDeclaredExtensionDefinition>();
    private List<RuntimeChildDeclaredExtensionDefinition> myExtensionsNonModifier = new ArrayList<RuntimeChildDeclaredExtensionDefinition>();
    private final Class<? extends T> myImplementingClass;
    private final String myName;
    private final boolean myStandardType;
    private Map<String, RuntimeChildDeclaredExtensionDefinition> myUrlToExtension = new HashMap<String, RuntimeChildDeclaredExtensionDefinition>();

    public BaseRuntimeElementDefinition(String theName, Class<? extends T> theImplementingClass, boolean theStandardType) {
        assert (StringUtils.isNotBlank((CharSequence)theName));
        assert (theImplementingClass != null);
        String name = theName;
        if (name.endsWith("Dt")) {
            name = name.substring(0, name.length() - 2);
        }
        this.myName = name;
        this.myStandardType = theStandardType;
        this.myImplementingClass = theImplementingClass;
    }

    public void addExtension(RuntimeChildDeclaredExtensionDefinition theExtension) {
        if (theExtension == null) {
            throw new NullPointerException();
        }
        this.myExtensions.add(theExtension);
    }

    public abstract ChildTypeEnum getChildType();

    private Constructor<T> getConstructor(Object theArgument) {
        Class<Void> argumentType = theArgument == null ? VOID_CLASS : theArgument.getClass();
        Constructor<Object> retVal = this.myConstructors.get(argumentType);
        if (retVal == null) {
            for (Constructor<?> next : this.getImplementingClass().getConstructors()) {
                if (argumentType == VOID_CLASS) {
                    if (next.getParameterTypes().length != 0) continue;
                    retVal = next;
                    break;
                }
                if (next.getParameterTypes().length != 1 || !next.getParameterTypes()[0].isAssignableFrom(argumentType)) continue;
                retVal = next;
                break;
            }
            if (retVal == null) {
                throw new ConfigurationException("Class " + this.getImplementingClass() + " has no constructor with a single argument of type " + argumentType);
            }
            this.myConstructors.put(argumentType, retVal);
        }
        return retVal;
    }

    public RuntimeChildDeclaredExtensionDefinition getDeclaredExtension(String theExtensionUrl) {
        this.validateSealed();
        return this.myUrlToExtension.get(theExtensionUrl);
    }

    public List<RuntimeChildDeclaredExtensionDefinition> getExtensions() {
        this.validateSealed();
        return this.myExtensions;
    }

    public List<RuntimeChildDeclaredExtensionDefinition> getExtensionsModifier() {
        this.validateSealed();
        return this.myExtensionsModifier;
    }

    public List<RuntimeChildDeclaredExtensionDefinition> getExtensionsNonModifier() {
        this.validateSealed();
        return this.myExtensionsNonModifier;
    }

    public Class<? extends T> getImplementingClass() {
        return this.myImplementingClass;
    }

    public String getName() {
        return this.myName;
    }

    public boolean isStandardType() {
        return this.myStandardType;
    }

    public T newInstance() {
        return this.newInstance(null);
    }

    public T newInstance(Object theArgument) {
        try {
            if (theArgument == null) {
                return (T)((IBase)this.getConstructor(null).newInstance(null));
            }
            return (T)((IBase)this.getConstructor(theArgument).newInstance(theArgument));
        }
        catch (Exception e) {
            throw new ConfigurationException("Failed to instantiate type:" + this.getImplementingClass().getName(), e);
        }
    }

    void sealAndInitialize(FhirContext theContext, Map<Class<? extends IBase>, BaseRuntimeElementDefinition<?>> theClassToElementDefinitions) {
        for (BaseRuntimeChildDefinition baseRuntimeChildDefinition : this.myExtensions) {
            baseRuntimeChildDefinition.sealAndInitialize(theContext, theClassToElementDefinitions);
        }
        for (RuntimeChildDeclaredExtensionDefinition runtimeChildDeclaredExtensionDefinition : this.myExtensions) {
            String extUrl = runtimeChildDeclaredExtensionDefinition.getExtensionUrl();
            if (this.myUrlToExtension.containsKey(extUrl)) {
                throw new ConfigurationException("Duplicate extension URL[" + extUrl + "] in Element[" + this.getName() + "]");
            }
            this.myUrlToExtension.put(extUrl, runtimeChildDeclaredExtensionDefinition);
            if (runtimeChildDeclaredExtensionDefinition.isModifier()) {
                this.myExtensionsModifier.add(runtimeChildDeclaredExtensionDefinition);
                continue;
            }
            this.myExtensionsNonModifier.add(runtimeChildDeclaredExtensionDefinition);
        }
        this.myExtensions = Collections.unmodifiableList(this.myExtensions);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getName() + ", " + this.getImplementingClass().getSimpleName() + "]";
    }

    protected void validateSealed() {
    }

    public static enum ChildTypeEnum {
        COMPOSITE_DATATYPE,
        CONTAINED_RESOURCE_LIST,
        CONTAINED_RESOURCES,
        EXTENSION_DECLARED,
        ID_DATATYPE,
        PRIMITIVE_DATATYPE,
        PRIMITIVE_XHTML,
        PRIMITIVE_XHTML_HL7ORG,
        RESOURCE,
        RESOURCE_BLOCK,
        UNDECL_EXT;

    }
}

