/*
 * Decompiled with CFR 0.152.
 */
package org.browsermob.proxy.jetty.util;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.browsermob.proxy.jetty.log.LogFactory;
import org.browsermob.proxy.jetty.util.ByteArrayPool;

public class ByteBufferOutputStream
extends OutputStream {
    private static Log log = LogFactory.getLog(ByteBufferOutputStream.class);
    protected byte[] _buf;
    private int _start;
    private int _end;
    private int _pos;
    private int _preReserve;
    private int _postReserve;
    private boolean _resized;
    private boolean _fixed;

    public ByteBufferOutputStream() {
        this(4096, 0, 0);
    }

    public ByteBufferOutputStream(int capacity) {
        this(capacity, 0, 0);
    }

    public ByteBufferOutputStream(int capacity, int preReserve) {
        this(capacity, preReserve, 0);
    }

    public ByteBufferOutputStream(int bufferSize, int preReserve, int postReserve) {
        this._buf = ByteArrayPool.getByteArray(bufferSize);
        this._end = this._buf.length - postReserve;
        this._preReserve = preReserve;
        this._start = preReserve;
        this._pos = preReserve;
        this._postReserve = postReserve;
    }

    public boolean isFixed() {
        return this._fixed;
    }

    public void setFixed(boolean fixed) {
        this._fixed = fixed;
    }

    public int size() {
        return this._pos - this._start;
    }

    public int bufferSize() {
        return this._buf.length;
    }

    public int capacity() {
        return this._end - this._start;
    }

    public int spareCapacity() {
        return this._end - this._pos;
    }

    public int preReserve() {
        return this._start;
    }

    public int postReserve() {
        return this._buf.length - this._end;
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this._buf, this._start, this._pos - this._start);
    }

    @Override
    public void write(int b) throws IOException {
        this.ensureSpareCapacity(1);
        this._buf[this._pos++] = (byte)b;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.ensureSpareCapacity(b.length);
        System.arraycopy(b, 0, this._buf, this._pos, b.length);
        this._pos += b.length;
    }

    @Override
    public void write(byte[] b, int offset, int length) throws IOException {
        this.ensureSpareCapacity(length);
        System.arraycopy(b, offset, this._buf, this._pos, length);
        this._pos += length;
    }

    public void prewrite(int b) {
        this.ensureReserve(1);
        this._buf[--this._start] = (byte)b;
    }

    public void prewrite(byte[] b) {
        this.ensureReserve(b.length);
        System.arraycopy(b, 0, this._buf, this._start - b.length, b.length);
        this._start -= b.length;
    }

    public void prewrite(byte[] b, int offset, int length) {
        this.ensureReserve(length);
        System.arraycopy(b, offset, this._buf, this._start - length, length);
        this._start -= length;
    }

    public void postwrite(byte b) throws IOException {
        this._buf[this._pos++] = b;
    }

    public void postwrite(byte[] b, int offset, int length) throws IOException {
        System.arraycopy(b, offset, this._buf, this._pos, length);
        this._pos += length;
    }

    @Override
    public void flush() throws IOException {
    }

    public void resetStream() {
        this._pos = this._preReserve;
        this._start = this._preReserve;
    }

    public void reset(int reserve) {
        this._pos = this._preReserve = reserve;
        this._start = this._preReserve;
    }

    @Override
    public void close() throws IOException {
        this.flush();
    }

    public void destroy() {
        if (!this._resized) {
            ByteArrayPool.returnByteArray(this._buf);
        }
        this._buf = null;
    }

    public void ensureReserve(int n) {
        if (n > this._start) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Reserve: " + n + ">" + this._start));
            }
            if (this._pos + n < this._end) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Shift reserve: " + this._pos + "+" + n + "<" + this._end));
                }
                System.arraycopy(this._buf, this._start, this._buf, n, this._pos - this._start);
                this._pos = this._pos + n - this._start;
                this._start = n;
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("New reserve: " + this._pos + "+" + n + ">=" + this._end));
                }
                byte[] buf = new byte[this._buf.length + n - this._start];
                System.arraycopy(this._buf, this._start, buf, n, this._pos - this._start);
                this._pos = n + this._pos - this._start;
                this._start = n;
                this._buf = buf;
                this._end = this._buf.length - this._postReserve;
            }
        }
    }

    public void ensureSize(int bufSize) throws IOException {
        this.ensureSize(bufSize, this._preReserve, this._postReserve);
    }

    public void ensureSize(int bufSize, int pre, int post) throws IOException {
        if (bufSize > this._buf.length || pre > this._preReserve || post > this._postReserve) {
            if (this._fixed) {
                throw new IllegalStateException("Fixed");
            }
            byte[] old = this._buf;
            this._buf = ByteArrayPool.getByteArray(bufSize);
            if (this._pos > this._start) {
                System.arraycopy(old, this._start, this._buf, pre, this._pos - this._start);
            }
            if (!this._resized) {
                ByteArrayPool.returnByteArray(old);
            }
            this._end = this._buf.length - post;
            this._preReserve = pre;
            this._start = pre;
            this._pos = pre;
            this._postReserve = post;
        }
    }

    public void ensureSpareCapacity(int n) throws IOException {
        if (n > this.spareCapacity()) {
            if (this._pos > this._start) {
                this.flush();
            }
            this.ensureCapacity(n);
        }
    }

    public void ensureCapacity(int n) throws IOException {
        if (n > this.capacity()) {
            if (this._fixed) {
                throw new IllegalStateException("Fixed");
            }
            int new_size = (n + this._preReserve + this._postReserve + 4095) / 4096 * 4096;
            byte[] old = this._buf;
            this._buf = new byte[new_size];
            if (this._pos > this._start) {
                System.arraycopy(old, this._start, this._buf, this._start, this._pos - this._start);
            }
            if (!this._resized) {
                ByteArrayPool.returnByteArray(old);
            }
            this._end = this._buf.length - this._postReserve;
            this._resized = true;
        }
    }
}

