/*
 * Decompiled with CFR 0.152.
 */
package org.browsermob.proxy.http;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.conn.scheme.HostNameResolver;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.params.HttpParams;
import org.browsermob.proxy.http.SimulatedSSLSocket;

public class TrustingSSLSocketFactory
extends SSLSocketFactory {
    private static SSLContext sslContext;
    private long downstreamKbps;
    private long upstreamKbps;
    private long latency;

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        SSLSocket sslSocket = (SSLSocket)super.createSocket(socket, host, port, autoClose);
        return new SimulatedSSLSocket(sslSocket, this.downstreamKbps, this.upstreamKbps, this.latency);
    }

    public Socket connectSocket(Socket sock, String host, int port, InetAddress localAddress, int localPort, HttpParams params) throws IOException {
        SSLSocket socket = (SSLSocket)super.connectSocket(sock, host, port, localAddress, localPort, params);
        return new SimulatedSSLSocket(socket, this.downstreamKbps, this.upstreamKbps, this.latency);
    }

    public Socket createSocket() throws IOException {
        SSLSocket socket = (SSLSocket)super.createSocket();
        socket.setEnabledProtocols(new String[]{"SSLv3", "TLSv1"});
        return new SimulatedSSLSocket(socket, this.downstreamKbps, this.upstreamKbps, this.latency);
    }

    public TrustingSSLSocketFactory(HostNameResolver nameResolver) {
        super(sslContext, nameResolver);
    }

    public void setDownstreamKbps(long downstreamKbps) {
        this.downstreamKbps = downstreamKbps;
    }

    public void setUpstreamKbps(long upstreamKbps) {
        this.upstreamKbps = upstreamKbps;
    }

    public void setLatency(long latency) {
        this.latency = latency;
    }

    static {
        try {
            sslContext = SSLContext.getInstance("SSLv3");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("TLS algorithm not found! Critical SSL error!", e);
        }
        X509TrustManager easyTrustManager = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        try {
            sslContext.init(null, new TrustManager[]{easyTrustManager}, null);
        }
        catch (KeyManagementException e) {
            throw new RuntimeException("Unexpected key management error", e);
        }
    }
}

