/*
 * Decompiled with CFR 0.152.
 */
package org.browsermob.proxy.http;

import java.io.IOException;
import java.io.InputStream;

public class SimulatedInputStream
extends InputStream {
    private InputStream inputStream;
    private long latency;
    private long bytesPerSecond;
    private boolean roundUp;

    public SimulatedInputStream(InputStream inputStream, long kiloBitsPerSecond, long latency) {
        this.inputStream = inputStream;
        this.latency = latency;
        this.bytesPerSecond = kiloBitsPerSecond * 1000L / 8L;
    }

    @Override
    public int read() throws IOException {
        long start = System.currentTimeMillis();
        int b = this.inputStream.read();
        long end = System.currentTimeMillis();
        this.simulate(1, end - start);
        return b;
    }

    @Override
    public int read(byte[] b) throws IOException {
        long start = System.currentTimeMillis();
        int bytesRead = this.inputStream.read(b);
        long end = System.currentTimeMillis();
        this.simulate(bytesRead, end - start);
        return bytesRead;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        long start = System.currentTimeMillis();
        int bytesRead = this.inputStream.read(b, off, len);
        long end = System.currentTimeMillis();
        this.simulate(bytesRead, end - start);
        return bytesRead;
    }

    private void simulate(int bytes, long timeTaken) {
        if (this.bytesPerSecond <= 0L) {
            return;
        }
        double d = (double)bytes / (double)this.bytesPerSecond * 1000.0;
        long expectedTime = (long)(this.roundUp ? Math.ceil(d) : Math.floor(d)) + this.latency;
        this.roundUp = !this.roundUp;
        long diff = expectedTime - timeTaken;
        if (diff > 0L) {
            try {
                Thread.sleep(diff);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
        }
    }

    @Override
    public long skip(long n) throws IOException {
        return this.inputStream.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.inputStream.available();
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    @Override
    public void mark(int readlimit) {
        this.inputStream.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this.inputStream.reset();
    }

    @Override
    public boolean markSupported() {
        return this.inputStream.markSupported();
    }
}

