/*
 * Decompiled with CFR 0.152.
 */
package org.browsermob.proxy;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.browsermob.proxy.ProxyServer;

@Singleton
public class ProxyManager {
    private AtomicInteger portCounter = new AtomicInteger(9090);
    private Provider<ProxyServer> proxyServerProvider;
    private Map<Integer, ProxyServer> proxies = new ConcurrentHashMap<Integer, ProxyServer>();

    @Inject
    public ProxyManager(Provider<ProxyServer> proxyServerProvider) {
        this.proxyServerProvider = proxyServerProvider;
    }

    public ProxyServer create(Map<String, String> options, int port) throws Exception {
        ProxyServer proxy = (ProxyServer)this.proxyServerProvider.get();
        proxy.setPort(port);
        proxy.start();
        proxy.setOptions(options);
        this.proxies.put(port, proxy);
        return proxy;
    }

    public ProxyServer create(Map<String, String> options) throws Exception {
        int port = this.portCounter.incrementAndGet();
        ProxyServer proxy = (ProxyServer)this.proxyServerProvider.get();
        proxy.setPort(port);
        proxy.start();
        proxy.setOptions(options);
        this.proxies.put(port, proxy);
        return proxy;
    }

    public ProxyServer get(int port) {
        return this.proxies.get(port);
    }

    public void delete(int port) throws Exception {
        ProxyServer proxy = this.proxies.remove(port);
        proxy.stop();
    }
}

