package org.nuiton.web.tapestry5.mixins;

import org.apache.tapestry5.BindingConstants;
import org.apache.tapestry5.ClientElement;
import org.apache.tapestry5.RenderSupport;
import org.apache.tapestry5.annotations.AfterRender;
import org.apache.tapestry5.annotations.IncludeJavaScriptLibrary;
import org.apache.tapestry5.annotations.InjectContainer;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.ioc.annotations.Inject;

/**
 * A simple mixin for attaching a javascript confirmation box to the onclick
 * event of any component that implements ClientElement.
 *
 * @author fdesbois
 * @version $Revision: 13 $
 *
 * Last update: $Date: 2010-06-12 17:05:57 +0200 (sam., 12 juin 2010) $
 * by : $Author: fdesbois $
 */
@IncludeJavaScriptLibrary("confirm.js")
public class Confirm {

    @Parameter(value = "Are you sure?", defaultPrefix = BindingConstants.MESSAGE)
    private String message;

    @Parameter(value = "true")
    private boolean condition;

    @Inject
    private RenderSupport renderSupport;

    @InjectContainer
    private ClientElement element;

    @Parameter
    private boolean wDisabled;

    @AfterRender
    public void afterRender() {
         if (!wDisabled) {
             renderSupport.addScript(String.format("new Confirm('%s', '%s', %b);",
                     element.getClientId(), message.replace("'", "\\'"), condition));
         }
    }

}
