/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.service;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.chorem.pollen.persistence.PollenEntity;
import org.chorem.pollen.persistence.UsersRight;
import org.chorem.pollen.persistence.entity.Comment;
import org.chorem.pollen.persistence.entity.PollenPrincipal;
import org.chorem.pollen.persistence.entity.PollenResource;
import org.chorem.pollen.persistence.entity.PollenUser;
import org.chorem.pollen.persistence.entity.PollenUserEmailAddress;
import org.chorem.pollen.persistence.entity.ResourceType;
import org.chorem.pollen.persistence.entity.UserCredential;
import org.chorem.pollen.persistence.entity.Vote;
import org.chorem.pollen.services.PollenService;
import org.chorem.pollen.services.bean.PollenEntityId;
import org.chorem.pollen.services.bean.PollenEntityRef;
import org.chorem.pollen.services.bean.PollenUserBean;
import org.chorem.pollen.services.bean.PollenUserEmailAddressBean;
import org.chorem.pollen.services.bean.UserCredentialBean;
import org.chorem.pollen.services.bean.resource.ResourceFileBean;
import org.chorem.pollen.services.service.InvalidEntityLinkException;
import org.chorem.pollen.services.service.InvalidFormException;
import org.chorem.pollen.services.service.PollenErrors;
import org.chorem.pollen.services.service.PollenServiceErrorIssue;
import org.chorem.pollen.services.service.PollenServiceSupport;
import org.chorem.pollen.services.service.security.PollenDefaultEmailAddressException;
import org.chorem.pollen.services.service.security.PollenEmailNotValidatedException;
import org.chorem.pollen.services.service.security.PollenInvalidEmailActivationTokenException;
import org.chorem.pollen.services.service.security.PollenInvalidPasswordException;
import org.chorem.pollen.services.service.security.PollenSecurityContext;
import org.nuiton.util.pagination.PaginationParameter;
import org.nuiton.util.pagination.PaginationResult;

public class PollenUserService
extends PollenServiceSupport
implements PollenService {
    public PollenUserBean toPollenUserBean(PollenUser entity) {
        PollenUserBean bean = new PollenUserBean();
        bean.setEntityId(entity.getTopiaId());
        bean.setName(entity.getName());
        bean.setAdministrator(entity.isAdministrator());
        bean.setBanned(entity.isBanned());
        bean.setLanguage(entity.getLanguage());
        bean.setPassword(null);
        bean.setEmailIsValidate(entity.isEmailValidated());
        bean.setWithPassword(entity.getPassword() != null);
        if (entity.getUserCredential() != null) {
            bean.setCredentials(entity.getUserCredential().stream().map(this::toUserCredentialBean).collect(Collectors.toList()));
        }
        bean.setPremiumTo(entity.getPremiumTo());
        if (entity.getAvatar() != null) {
            bean.setAvatar(this.getPollenResourceService().getReduceIdByTopiaId(entity.getAvatar().getTopiaId()));
        }
        bean.setGtuValidated(this.getGtuService().isGtuValidated(entity));
        bean.setPremium(this.isPremium(entity));
        bean.setEmailAddresses(entity.getEmailAddresses().stream().map(this::toPollenUserEmailAddressBean).collect(Collectors.toList()));
        if (entity.getDefaultEmailAddress() != null) {
            bean.setDefaultEmailAddress(this.toPollenUserEmailAddressBean(entity.getDefaultEmailAddress()));
        }
        bean.setCanCreatePoll(entity.isCanCreatePoll());
        return bean;
    }

    public PollenUserEmailAddressBean toPollenUserEmailAddressBean(PollenUserEmailAddress entity) {
        PollenUserEmailAddressBean bean = new PollenUserEmailAddressBean();
        bean.setEntityId(entity.getTopiaId());
        bean.setEmailAddress(entity.getEmailAddress());
        bean.setValidated(entity.isValidated());
        bean.setPgpPublicKey(entity.getPgpPublicKey());
        return bean;
    }

    public UserCredentialBean toUserCredentialBean(UserCredential entity) {
        UserCredentialBean bean = new UserCredentialBean();
        bean.setEntityId(entity.getTopiaId());
        bean.setProvider(entity.getProvider());
        bean.setUserName(entity.getUserName());
        bean.setEmailAddress(entity.getEmail());
        return bean;
    }

    public PaginationResult<PollenUserBean> getUsers(PaginationParameter page, String search) {
        this.checkIsAdmin();
        PaginationParameter orderedPage = PollenUserService.orderedPage(page, "name");
        PaginationResult pollenUsers = this.getPollenUserDao().findAll(orderedPage, search);
        return pollenUsers.transform(this::toPollenUserBean);
    }

    public PollenUserBean getUser() {
        PollenUser pollenUser = this.checkAndGetConnectedUser();
        return this.toPollenUserBean(pollenUser);
    }

    @Deprecated
    public PollenUserBean getUser(String userId) {
        PollenEntityId<PollenUser> id = PollenEntityId.of(PollenUser.class, userId);
        return this.getUser(id);
    }

    public PollenUserBean getUser(PollenEntityId<PollenUser> userId) {
        this.checkNotNull(userId);
        this.checkNotNull(userId.getEntityId());
        PollenUser pollenUser = this.checkAndGetConnectedUser();
        if (!userId.getEntityId().equals(pollenUser.getTopiaId())) {
            this.checkIsAdmin();
            pollenUser = this.getUser0(userId.getEntityId());
        }
        return this.toPollenUserBean(pollenUser);
    }

    public PollenEntityRef<PollenUser> createUser(PollenUserBean user) throws InvalidFormException {
        this.checkNotNull(user);
        this.checkIsNotPersisted(user);
        PollenErrors pollenErrors = this.checkPollenUser(user);
        if (user.getDefaultEmailAddress() == null) {
            pollenErrors.addError("email", PollenServiceErrorIssue.USER_EMAIL_EMPTY, null, new Object[0]);
        } else {
            this.checkUserEmailAddress(pollenErrors, user.getDefaultEmailAddress().getEmailAddress());
        }
        pollenErrors.failIfNotEmpty();
        PollenUser result = this.savePollenUser(user);
        this.commit();
        String token = this.getSecurityService().generateEmailToken(result.getDefaultEmailAddress());
        this.getNotificationService().onUserCreated(result, token);
        return PollenEntityRef.of(result);
    }

    public PollenUserBean editUser(PollenUserBean user) throws InvalidFormException {
        this.checkNotNull(user);
        this.checkIsPersisted(user);
        this.checkConnectedUserOrAdmin(user.getEntityId());
        PollenErrors pollenErrors = this.checkPollenUser(user);
        pollenErrors.failIfNotEmpty();
        PollenUser result = this.savePollenUser(user);
        this.commit();
        this.getNotificationService().onUserEdited(result);
        return this.toPollenUserBean(result);
    }

    public boolean deleteUser(String userId, boolean anonymize) {
        boolean selfDeletion = this.checkConnectedUserOrAdmin(userId);
        PollenUser user = this.getUser0(userId);
        if (anonymize) {
            this.anonymizeUser(user);
        }
        this.getUserCredentialDao().deleteAll((Iterable)CollectionUtils.emptyIfNull((Collection)user.getUserCredential()));
        this.getPollenUserDao().delete(user);
        this.commit();
        this.getNotificationService().onUserDeleted(user);
        return selfDeletion;
    }

    public void changePassword(String oldPassword, String newPassword) throws InvalidFormException {
        PollenUser user = this.checkAndGetConnectedUser();
        this.checkNotNull(newPassword);
        PollenErrors pollenErrors = new PollenErrors();
        boolean passwordNotBlank = this.checkNotBlank(pollenErrors, "newPassword", newPassword, PollenServiceErrorIssue.USER_PASSWORD_EMPTY, new Object[0]);
        if (passwordNotBlank) {
            try {
                this.getSecurityService().checkUserPassword(user, oldPassword);
            }
            catch (PollenInvalidPasswordException e) {
                this.check(pollenErrors, "oldPassword", false, PollenServiceErrorIssue.USER_PASSWORD_INVALID, null, new Object[0]);
            }
        }
        pollenErrors.failIfNotEmpty();
        this.getSecurityService().setUserPassword(user, newPassword);
        this.commit();
        this.getNotificationService().onUserPasswordChanged(user);
    }

    public static boolean doesNotContainEmailAddress(PollenUser user, PollenUserEmailAddress emailAddress) {
        return user.getEmailAddresses() == null || !user.getEmailAddresses().contains(emailAddress);
    }

    public void validateUserEmail(String userId, String token) throws PollenInvalidEmailActivationTokenException {
        this.checkNotNull(userId);
        this.checkNotNull(token);
        PollenUser user = this.getUser0(userId);
        PollenUserEmailAddress emailAddress = this.getSecurityService().getEmailAdresseFromToken(token);
        if (emailAddress == null || PollenUserService.doesNotContainEmailAddress(user, emailAddress)) {
            throw new PollenInvalidEmailActivationTokenException();
        }
        emailAddress.setValidated(true);
        this.commit();
        this.getNotificationService().onUserEmailValidated(user, emailAddress);
    }

    public void validateUserEmailByAdmin(String userId, String emailAddressId) throws PollenInvalidEmailActivationTokenException {
        this.checkIsAdmin();
        this.checkNotNull(userId);
        this.checkNotNull(emailAddressId);
        PollenUser user = this.getUser0(userId);
        PollenUserEmailAddress emailAddress = (PollenUserEmailAddress)this.getPollenUserEmailAddressDao().forTopiaIdEquals(emailAddressId).findUnique();
        if (emailAddress == null || PollenUserService.doesNotContainEmailAddress(user, emailAddress)) {
            throw new PollenInvalidEmailActivationTokenException();
        }
        emailAddress.setValidated(true);
        this.commit();
        this.getNotificationService().onUserEmailValidated(user, emailAddress);
    }

    public void resendValidation(String email) {
        this.checkNotNull(email);
        PollenUserEmailAddress userEmailAddress = (PollenUserEmailAddress)this.getPollenUserEmailAddressDao().forEmailAddressEquals(email).findUniqueOrNull();
        if (userEmailAddress == null) {
            return;
        }
        PollenUser user = (PollenUser)this.getPollenUserDao().forEmailAddressesContains(userEmailAddress).findUnique();
        userEmailAddress.setValidated(false);
        this.commit();
        String token = this.getSecurityService().generateEmailToken(userEmailAddress);
        this.getNotificationService().onResendValidation(user, userEmailAddress, token);
    }

    public void createDefaultUsers() {
        if (this.getPollenUserDao().count() == 0L) {
            PollenUserBean adminBean = new PollenUserBean();
            PollenUserEmailAddressBean emailAddress = new PollenUserEmailAddressBean();
            emailAddress.setEmailAddress("admin@chorem.org");
            adminBean.setDefaultEmailAddress(emailAddress);
            adminBean.setPassword("admin");
            adminBean.setName("admin");
            PollenUser admin = this.savePollenUser(adminBean);
            admin.setAdministrator(true);
            admin.getDefaultEmailAddress().setValidated(true);
            this.commit();
        }
    }

    public void deleteAvatar() {
        this.checkIsConnected();
        PollenUser user = this.getConnectedUser();
        if (user.getAvatar() != null) {
            this.getPollenResourceDao().delete(user.getAvatar());
        }
        this.commit();
    }

    public void deleteAvatar(String userId) {
        this.checkIsAdmin();
        PollenUser user = this.getUser0(userId);
        if (user.getAvatar() != null) {
            this.getPollenResourceDao().delete(user.getAvatar());
        }
        this.commit();
    }

    public PollenEntityRef<PollenResource> setAvatar(ResourceFileBean resourceBean) throws InvalidFormException {
        this.checkIsConnected();
        resourceBean.setResourceType(ResourceType.AVATAR);
        PollenResource avatarResource = this.getPollenResourceService().createAvatarResource(resourceBean);
        PollenUser user = this.getConnectedUser();
        if (user.getAvatar() != null) {
            this.getPollenResourceDao().delete(user.getAvatar());
        }
        user.setAvatar(avatarResource);
        this.commit();
        return PollenEntityRef.of(avatarResource);
    }

    public PollenEntityRef<PollenUserEmailAddress> addEmailAddress(String emailAddress) throws InvalidFormException {
        PollenUser connectedUser = this.checkAndGetConnectedUser();
        return this.addEmailAddress(connectedUser.getTopiaId(), emailAddress);
    }

    public PollenEntityRef<PollenUserEmailAddress> addEmailAddress(String userId, String emailAddress) throws InvalidFormException {
        this.checkConnectedUserOrAdmin(userId);
        return this.addEmailAddress(this.getUser0(userId), emailAddress);
    }

    protected PollenEntityRef<PollenUserEmailAddress> addEmailAddress(PollenUser user, String emailAddress) throws InvalidFormException {
        this.checkNotNull(emailAddress);
        PollenErrors errors = new PollenErrors();
        emailAddress = this.checkUserEmailAddress(errors, emailAddress);
        errors.failIfNotEmpty();
        PollenUserEmailAddress address = (PollenUserEmailAddress)this.getPollenUserEmailAddressDao().create();
        address.setEmailAddress(emailAddress);
        address.setValidated(false);
        user.addEmailAddresses(address);
        this.commit();
        String token = this.getSecurityService().generateEmailToken(address);
        this.getNotificationService().onUserEmailAddressAdded(user, address, token);
        return PollenEntityRef.of(address);
    }

    protected String checkUserEmailAddress(PollenErrors errors, String emailAddress) {
        boolean emailNotblank = this.checkNotBlank(errors, "email", emailAddress = this.getCleanMail(emailAddress), PollenServiceErrorIssue.USER_EMAIL_EMPTY, new Object[0]);
        if (emailNotblank) {
            this.checkValidEmail(errors, "email", emailAddress, PollenServiceErrorIssue.USER_EMAIL_INVALID, new Object[0]);
            this.checkEmailPattern(errors, "email", emailAddress, PollenServiceErrorIssue.USER_EMAIL_UNAUTHORIZED, new Object[0]);
            this.check(errors, "email", !this.getPollenUserEmailAddressDao().emailExists(emailAddress), PollenServiceErrorIssue.USER_EMAIL_EXIST, emailAddress, new Object[0]);
        }
        return emailAddress;
    }

    public void setDefaultEmailAddress(String emailAddressId) throws PollenEmailNotValidatedException {
        PollenUser connectedUser = this.checkAndGetConnectedUser();
        this.setDefaultEmailAddress(connectedUser, emailAddressId);
    }

    public void setDefaultEmailAddress(String userId, String emailAddressId) throws PollenEmailNotValidatedException {
        this.checkConnectedUserOrAdmin(userId);
        this.setDefaultEmailAddress(this.getUser0(userId), emailAddressId);
    }

    protected void setDefaultEmailAddress(PollenUser user, String emailAddressId) throws PollenEmailNotValidatedException {
        this.checkNotNull(emailAddressId);
        PollenUserEmailAddress emailAddress = user.getEmailAddressesByTopiaId(emailAddressId);
        this.checkNotNull(emailAddress);
        if (!emailAddress.isValidated()) {
            throw new PollenEmailNotValidatedException();
        }
        user.setDefaultEmailAddress(emailAddress);
        this.commit();
    }

    public void removeEmailAddress(String emailAddressId) throws PollenDefaultEmailAddressException {
        PollenUser connectedUser = this.checkAndGetConnectedUser();
        this.removeEmailAddressFromUser(connectedUser, emailAddressId);
    }

    public void removeEmailAddress(String userId, String emailAddressId) throws PollenDefaultEmailAddressException {
        this.checkConnectedUserOrAdmin(userId);
        this.removeEmailAddressFromUser(this.getUser0(userId), emailAddressId);
    }

    protected void removeEmailAddressFromUser(PollenUser user, String emailAddressId) throws PollenDefaultEmailAddressException {
        this.checkNotNull(emailAddressId);
        if (user.getDefaultEmailAddress() != null && user.getDefaultEmailAddress().getTopiaId().equals(emailAddressId)) {
            throw new PollenDefaultEmailAddressException();
        }
        PollenUserEmailAddress emailAddress = user.getEmailAddressesByTopiaId(emailAddressId);
        this.checkNotNull(emailAddress);
        user.removeEmailAddresses(emailAddress);
        this.getPollenUserEmailAddressDao().delete(emailAddress);
        this.commit();
    }

    protected PollenErrors checkPollenUser(PollenUserBean user) {
        PollenErrors errors = new PollenErrors();
        boolean userExists = user.isPersisted();
        this.checkNotBlank(errors, "name", user.getName(), PollenServiceErrorIssue.USER_NAME_EMPTY, new Object[0]);
        if (!userExists) {
            this.checkNotBlank(errors, "password", user.getPassword(), PollenServiceErrorIssue.USER_PASSWORD_EMPTY, new Object[0]);
        }
        this.check(errors, "banned", !user.isBanned() || !user.isPersisted() || this.getConnectedUser() == null || !user.getEntityId().equals(this.getConnectedUser().getTopiaId()), PollenServiceErrorIssue.USER_BANNED, user.getName(), new Object[0]);
        if (this.getGtuService().getCurrentGtu0().isPresent()) {
            this.check(errors, "gtuValidated", user.isPersisted() || user.isGtuValidated(), PollenServiceErrorIssue.USER_GTU_NOT_ACCEPTED, user.isGtuValidated(), new Object[0]);
        }
        return errors;
    }

    protected PollenUser savePollenUser(PollenUserBean user) {
        PollenUser toSave;
        boolean userExists = user.isPersisted();
        if (userExists) {
            toSave = this.getUser0(user.getEntityId());
        } else {
            toSave = (PollenUser)this.getPollenUserDao().newInstance();
            toSave.setName(user.getName());
            this.getPollenUserDao().create((PollenEntity)toSave);
            PollenUserEmailAddressBean emailAddress = user.getDefaultEmailAddress();
            if (emailAddress != null) {
                PollenUserEmailAddress defaultEmailAddress = (PollenUserEmailAddress)this.getPollenUserEmailAddressDao().create();
                String cleanMail = this.getCleanMail(emailAddress.getEmailAddress());
                defaultEmailAddress.setEmailAddress(cleanMail);
                defaultEmailAddress.setValidated(false);
                toSave.addEmailAddresses(defaultEmailAddress);
                toSave.setDefaultEmailAddress(defaultEmailAddress);
            }
            if (user.isGtuValidated()) {
                toSave.setGtuValidationDate(this.getNow());
            }
            this.getSecurityService().setUserPassword(toSave, user.getPassword());
        }
        PollenSecurityContext securityContext = this.getSecurityContext();
        if (securityContext.isAdmin()) {
            toSave.setAdministrator(user.isAdministrator());
            toSave.setBanned(user.isBanned());
            toSave.setPremiumTo(user.getPremiumTo());
        }
        toSave.setName(user.getName());
        toSave.setLanguage(user.getLanguage());
        if (UsersRight.USERS_SELECTED.equals((Object)this.getPollenServiceConfig().getUsersCanCreatePoll())) {
            toSave.setCanCreatePoll(user.isCanCreatePoll());
        }
        return toSave;
    }

    protected PollenUser getUser0(String userId) {
        return (PollenUser)this.getPollenUserDao().forTopiaIdEquals(userId).findUnique();
    }

    protected void anonymizeUser(PollenUser user) {
        List votesUser = this.getVoteDao().forVoter_PollenUserEquals(user).findAll();
        for (Vote vote : votesUser) {
            PollenPrincipal anonymousUser = this.getSecurityService().generatePollenPrincipal();
            anonymousUser.setName("?");
            vote.setVoter(anonymousUser);
            vote.setAnonymous(true);
        }
        List commentsUser = this.getCommentDao().forAuthor_PollenUserEquals(user).findAll();
        for (Comment comment : commentsUser) {
            PollenPrincipal anonymousUser = this.getSecurityService().generatePollenPrincipal();
            anonymousUser.setName("?");
            comment.setAuthor(anonymousUser);
        }
        this.commit();
    }

    public boolean isPremium(PollenUser user) {
        return user != null && this.isPremium(user.getPremiumTo());
    }

    protected boolean isPremium(Date premiumTo) {
        return premiumTo != null && premiumTo.after(this.getNow());
    }

    protected boolean checkConnectedUserOrAdmin(String userId) {
        this.checkNotNull(userId);
        PollenUser connectedUser = this.checkAndGetConnectedUser();
        boolean result = connectedUser.getTopiaId().equals(userId);
        if (!result) {
            this.checkIsAdmin();
        }
        return result;
    }

    public PollenUserEmailAddressBean editEmailAddress(PollenUserEmailAddressBean emailAddress) {
        PollenUser connectedUser = this.checkAndGetConnectedUser();
        return this.editEmailAddressFromUser(connectedUser, emailAddress);
    }

    public PollenUserEmailAddressBean editEmailAddress(String userId, PollenUserEmailAddressBean emailAddress) {
        this.checkConnectedUserOrAdmin(userId);
        return this.editEmailAddressFromUser(this.getUser0(userId), emailAddress);
    }

    protected PollenUserEmailAddressBean editEmailAddressFromUser(PollenUser user, PollenUserEmailAddressBean emailAddress) {
        this.checkIsConnectedRequired();
        this.checkNotNull(emailAddress);
        this.checkIsPersisted(emailAddress);
        PollenUserEmailAddress result = (PollenUserEmailAddress)this.getPollenUserEmailAddressDao().forTopiaIdEquals(emailAddress.getEntityId()).findUnique();
        if (PollenUserService.doesNotContainEmailAddress(user, result)) {
            throw new InvalidEntityLinkException("emailAddresses", (PollenEntity)user, (PollenEntity)result);
        }
        result.setPgpPublicKey(emailAddress.getPgpPublicKey());
        this.commit();
        return this.toPollenUserEmailAddressBean(result);
    }
}

