/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.service.services.impl;

import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import nc.ird.cantharella.data.dao.GenericDao;
import nc.ird.cantharella.data.dao.impl.PersonneDao;
import nc.ird.cantharella.data.exceptions.DataConstraintException;
import nc.ird.cantharella.data.exceptions.DataNotFoundException;
import nc.ird.cantharella.data.exceptions.UnexpectedException;
import nc.ird.cantharella.data.model.Personne;
import nc.ird.cantharella.data.model.Utilisateur;
import nc.ird.cantharella.data.model.utils.AbstractModel;
import nc.ird.cantharella.service.exceptions.EmailException;
import nc.ird.cantharella.service.services.MailService;
import nc.ird.cantharella.service.services.PersonneService;
import nc.ird.cantharella.service.utils.normalizers.EmailNormalizer;
import nc.ird.cantharella.service.utils.normalizers.utils.Normalize;
import nc.ird.cantharella.utils.AssertTools;
import nc.ird.cantharella.utils.PasswordTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public final class PersonneServiceImpl
implements PersonneService {
    private static final Logger LOG = LoggerFactory.getLogger(PersonneServiceImpl.class);
    @Autowired
    private GenericDao dao;
    @Autowired
    private Utilisateur defaultAdmin;
    @Autowired
    private MailService mailService;
    @Resource(name="serviceMessageSource")
    private MessageSourceAccessor messages;

    @Override
    public void checkOrCreateAdmin() throws DataConstraintException {
        if (this.countAdmins() == 0L) {
            this.defaultAdmin.setTypeDroit(Utilisateur.TypeDroit.ADMINISTRATEUR);
            this.defaultAdmin.setValide(Boolean.TRUE);
            this.plainCreateUtilisateur(this.defaultAdmin);
        }
    }

    private Long countAdmins() {
        return this.dao.count(PersonneDao.CRITERIA_COUNT_ADMINS);
    }

    @Override
    public long countPersonnes() {
        return this.dao.count(Personne.class);
    }

    @Override
    public void createPersonne(Personne personne) throws DataConstraintException {
        LOG.info("createPersonne " + personne.getCourriel());
        try {
            this.dao.create((AbstractModel)personne);
        }
        catch (DataIntegrityViolationException e) {
            throw new DataConstraintException(e);
        }
    }

    @Override
    public void createUtilisateur(Utilisateur utilisateur) throws DataConstraintException {
        try {
            this.plainCreateUtilisateur(utilisateur);
        }
        catch (DataIntegrityViolationException e) {
            throw new DataConstraintException(e);
        }
        this.mailService.sendMailQuietly((Personne)utilisateur, this.messages.getMessage("register.subject"), this.messages.getMessage("register.text"));
        this.mailService.sendMailQuietly(this.listAdmins(), this.messages.getMessage("register.subject.admin"), this.messages.getMessage("register.text.admin", new Object[]{utilisateur.getPrenom(), utilisateur.getNom(), utilisateur.getCourriel()}));
    }

    @Override
    public void deletePersonne(Personne personne) throws DataConstraintException {
        AssertTools.assertNotNull((Object)personne);
        LOG.info("deletePersonne " + personne.getIdPersonne());
        AssertTools.assertNotNull((Object)personne.getIdPersonne());
        try {
            this.dao.delete((AbstractModel)personne);
        }
        catch (DataNotFoundException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException((Exception)((Object)e));
        }
    }

    @Override
    public void deleteUtilisateur(Utilisateur utilisateur) throws DataConstraintException, EmailException {
        this.deleteUtilisateur(utilisateur, this.messages.getMessage("delete.subject"), this.messages.getMessage("delete.text"));
    }

    @Transactional(rollbackFor={EmailException.class})
    public void deleteUtilisateur(Utilisateur utilisateur, String mailSubject, String mailText) throws EmailException, DataConstraintException {
        AssertTools.assertNotNull((Object)utilisateur);
        LOG.info("deleteUtilisateur " + utilisateur.getIdPersonne());
        AssertTools.assertNotNull((Object)utilisateur.getIdPersonne());
        try {
            this.dao.delete((AbstractModel)utilisateur);
        }
        catch (DataConstraintException e) {
            this.dao.execute(PersonneDao.SQL_DELETE_UTILISATEUR, new Object[]{utilisateur.getIdPersonne()});
        }
        catch (DataNotFoundException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException((Exception)((Object)e));
        }
        this.mailService.sendMail((Personne)utilisateur, mailSubject, mailText);
    }

    @Override
    public String hashPassword(String password) {
        AssertTools.assertNotEmpty((String)password);
        return PasswordTools.sha1((String)password);
    }

    private List<Utilisateur> listAdmins() {
        return this.dao.list(PersonneDao.CRITERIA_LIST_ADMINS);
    }

    @Override
    public List<Personne> listPersonnes() {
        List allPersonnes = this.dao.readList(Personne.class, new String[]{"nom", "prenom"});
        allPersonnes.removeAll(this.listUtilisateursInvalid());
        return allPersonnes;
    }

    @Override
    public List<Personne> listPersonnesWithInvalidUsers() {
        return this.dao.readList(Personne.class, new String[]{"nom", "prenom"});
    }

    @Override
    public List<String> listPersonneOrganismes() {
        return this.dao.list(PersonneDao.CRITERIA_DISTINCT_PERSONNE_ORGANISMES);
    }

    @Override
    public List<Utilisateur> listUtilisateursInvalid() {
        return this.dao.list(PersonneDao.CRITERIA_LIST_UTILISATEURS_INVALID);
    }

    @Override
    public List<Utilisateur> listUtilisateursValid() {
        return this.dao.list(PersonneDao.CRITERIA_LIST_UTILISATEURS_VALID);
    }

    @Override
    public Personne loadPersonne(Integer idPersonne) throws DataNotFoundException {
        AssertTools.assertNotNull((Object)idPersonne);
        try {
            return (Personne)this.dao.read(Personne.class, (Serializable)idPersonne);
        }
        catch (DataRetrievalFailureException e) {
            throw new DataNotFoundException(e);
        }
    }

    @Override
    public Personne loadPersonne(String courriel) throws DataNotFoundException {
        AssertTools.assertNotNull((Object)courriel);
        return (Personne)this.dao.read(Personne.class, "courriel", (Serializable)((Object)courriel));
    }

    @Override
    public Utilisateur loadUtilisateur(Integer idPersonne) throws DataNotFoundException {
        AssertTools.assertNotNull((Object)idPersonne);
        try {
            return (Utilisateur)this.dao.read(Utilisateur.class, (Serializable)idPersonne);
        }
        catch (DataRetrievalFailureException e) {
            throw new DataNotFoundException(e);
        }
    }

    @Override
    public Utilisateur loadUtilisateur(String courriel) throws DataNotFoundException {
        AssertTools.assertNotEmpty((String)courriel);
        Personne personne = this.loadPersonne(courriel);
        if (!(personne instanceof Utilisateur)) {
            throw new DataNotFoundException((DataRetrievalFailureException)new ObjectRetrievalFailureException(Utilisateur.class, (Object)courriel));
        }
        return (Utilisateur)personne;
    }

    @Override
    public boolean authenticateUtilisateur(@Normalize(value=EmailNormalizer.class) String courriel, String passwordHash) {
        AssertTools.assertNotEmpty((String)courriel);
        AssertTools.assertNotEmpty((String)passwordHash);
        return this.dao.exists(PersonneDao.getCriteriaAuthenticateUser((String)courriel, (String)passwordHash));
    }

    private void plainCreateUtilisateur(Utilisateur utilisateur) throws DataConstraintException {
        AssertTools.assertNotNull((Object)utilisateur);
        LOG.info("createUtilisateur " + utilisateur.getCourriel());
        if (utilisateur.getTypeDroit() == null) {
            utilisateur.setTypeDroit(Utilisateur.TypeDroit.UTILISATEUR);
        }
        if (utilisateur.isValide() == null) {
            utilisateur.setValide(Boolean.FALSE);
        }
        this.dao.create((AbstractModel)utilisateur);
    }

    @Override
    public void refreshPersonne(Personne personne) {
        AssertTools.assertNotNull((Object)personne);
        this.dao.refresh((AbstractModel)personne);
    }

    @Override
    public void rejectUtilisateur(Utilisateur utilisateur) {
        try {
            this.deleteUtilisateur(utilisateur, this.messages.getMessage("reject.subject"), this.messages.getMessage("reject.text"));
        }
        catch (EmailException e) {
        }
        catch (DataConstraintException e) {
            LOG.error(e.getMessage());
        }
    }

    @Override
    @Transactional(rollbackFor={DataNotFoundException.class, EmailException.class})
    public void resetPasswordUtilisateur(String courriel) throws DataNotFoundException, EmailException {
        Utilisateur utilisateur;
        LOG.info("reListPasswordUtilisateur " + courriel);
        try {
            utilisateur = this.loadUtilisateur(courriel);
        }
        catch (DataNotFoundException e) {
            LOG.warn("Unknown e-mail: " + courriel);
            throw e;
        }
        String newPassword = PasswordTools.random();
        utilisateur.setPasswordHash(this.hashPassword(newPassword));
        try {
            this.dao.update((AbstractModel)utilisateur);
        }
        catch (DataConstraintException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException((Exception)((Object)e));
        }
        this.mailService.sendMail((Personne)utilisateur, this.messages.getMessage("updatePassword.subject"), this.messages.getMessage("updatePassword.text", new Object[]{newPassword}));
    }

    @Override
    public void sendMailAdmins(String subject, String message, String replyTo) throws EmailException {
        LOG.info("sendMailAdmins " + subject + " [reply to] " + replyTo);
        this.mailService.sendMail(this.listAdmins(), this.messages.getMessage("contact.subject", (Object[])new String[]{subject}), this.messages.getMessage("contact.body", (Object[])new String[]{replyTo, message}), replyTo);
    }

    @Override
    @Transactional(rollbackFor={EmailException.class, DataAccessException.class, UnexpectedException.class})
    public Utilisateur updateAndCreateUtilisateur(Personne personne) throws EmailException, DataConstraintException {
        Utilisateur utilisateur;
        LOG.info("updateAndCreateUtilisateur " + personne.getIdPersonne());
        String password = PasswordTools.random();
        try {
            this.dao.update((AbstractModel)personne);
        }
        catch (DataNotFoundException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException((Exception)((Object)e));
        }
        this.dao.execute(PersonneDao.SQL_CREATE_UTILISATEUR_FROM_PERSONNE, new Object[]{Boolean.TRUE, this.hashPassword(password), Utilisateur.TypeDroit.UTILISATEUR.ordinal(), personne.getIdPersonne()});
        try {
            utilisateur = (Utilisateur)this.dao.read(Utilisateur.class, (Serializable)personne.getIdPersonne());
        }
        catch (DataNotFoundException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException((Exception)((Object)e));
        }
        this.mailService.sendMail((Personne)utilisateur, this.messages.getMessage("create.subject"), this.messages.getMessage("create.text", new Object[]{password}));
        return utilisateur;
    }

    @Override
    public void updatePersonne(Personne personne) throws DataConstraintException {
        LOG.info("updatePersonne " + personne.getIdPersonne());
        try {
            this.dao.update((AbstractModel)personne);
        }
        catch (DataNotFoundException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException((Exception)((Object)e));
        }
    }

    private void updateUtilisateur(Utilisateur utilisateur) throws DataConstraintException {
        AssertTools.assertNotNull((Object)utilisateur);
        LOG.info("updateUtilisateur " + utilisateur.getCourriel());
        try {
            this.dao.update((AbstractModel)utilisateur);
        }
        catch (DataNotFoundException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException((Exception)((Object)e));
        }
    }

    @Override
    public void updateUtilisateur(Utilisateur utilisateur, boolean admin) throws DataConstraintException {
        this.updateUtilisateur(utilisateur);
        if (admin) {
            this.mailService.sendMailQuietly((Personne)utilisateur, this.messages.getMessage("update.subject"), this.messages.getMessage("update.text"));
        }
    }

    @Override
    public void validAndUpdateUtilisateur(Utilisateur utilisateur) throws DataConstraintException {
        utilisateur.setValide(Boolean.valueOf(true));
        this.updateUtilisateur(utilisateur);
        this.mailService.sendMailQuietly((Personne)utilisateur, this.messages.getMessage("valid.subject"), this.messages.getMessage("valid.text"));
    }

    @Override
    public boolean updateOrDeletePersonneEnabled(Personne personne, Utilisateur modifieur) {
        AssertTools.assertNotNull((Object)personne);
        AssertTools.assertNotNull((Object)modifieur);
        return !(personne instanceof Utilisateur) || modifieur.getTypeDroit() == Utilisateur.TypeDroit.ADMINISTRATEUR;
    }
}

