/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.maven.plugins.toolbox;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import fr.ird.observe.maven.plugins.toolbox.GenerateValidatorMojoSupport;
import fr.ird.observe.maven.plugins.toolbox.ValidatorsCache;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.TreeSet;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="generate-validators-descriptor", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresDependencyResolution=ResolutionScope.COMPILE)
class GenerateValidatorsDescriptorMojo
extends GenerateValidatorMojoSupport {
    @Parameter(property="generateValidatorsDescriptor.outputFile", defaultValue="${project.build.outputDirectory}/META-INF/validators/${project.artifactId}.json", required=true)
    private File outputFile;
    @Parameter(property="generateValidatorsDescriptor.verbose", defaultValue="${maven.verbose}")
    private boolean verbose;
    @Parameter(property="generateValidatorsDescriptor.skip", defaultValue="false")
    private boolean skip;

    GenerateValidatorsDescriptorMojo() {
    }

    @Override
    protected Path createOutputFile() throws IOException {
        Files.createDirectories(this.outputFile.getParentFile().toPath(), new FileAttribute[0]);
        return this.outputFile.toPath();
    }

    @Override
    protected boolean isSkip() {
        return this.skip;
    }

    public void doAction() throws Exception {
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("project = " + this.getProject()));
        }
        this.getLog().info((CharSequence)("Generate to " + this.getOutputFile()));
        TreeSet<String> fields = new TreeSet<String>();
        for (ValidatorsCache.ValidatorInfo validator : this.getValidators()) {
            fields.addAll(validator.getFields());
        }
        this.getLog().info((CharSequence)(fields.size() + " validator files(s) detected."));
        ArrayList<ValidatorsCache.ValidatorInfo> validatorList = new ArrayList<ValidatorsCache.ValidatorInfo>(this.getValidators());
        Collections.sort(validatorList, (o1, o2) -> o1.getType().getName().compareToIgnoreCase(o2.getType().getName()));
        Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(ValidatorsCache.ValidatorInfo.class, (src, typeOfSrc, context) -> {
            JsonObject element2 = new JsonObject();
            element2.add("type", context.serialize((Object)src.getType().getName()));
            element2.add("context", context.serialize((Object)src.getContext()));
            element2.add("scope", context.serialize((Object)src.getScope()));
            element2.add("fields", context.serialize(src.getFields()));
            return element2;
        }).create();
        String validatorsJson = gson.toJson(validatorList);
        Files.write(this.outputFile.toPath(), validatorsJson.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

