/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.maven.plugins.toolbox;

import fr.ird.observe.maven.plugins.toolbox.ToolboxMojoSupport;
import fr.ird.observe.maven.plugins.toolbox.ValidatorCacheRequest;
import fr.ird.observe.maven.plugins.toolbox.ValidatorsCache;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Collection;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class GenerateValidatorMojoSupport
extends ToolboxMojoSupport
implements ValidatorCacheRequest {
    @Parameter(defaultValue="${project.basedir}/src/main/validators/validators.xml", required=true)
    private File validatorsFile;
    private Collection<ValidatorsCache.ValidatorInfo> validators;

    @Override
    protected void init() throws Exception {
        if (this.isSkip()) {
            return;
        }
        super.init();
        this.validators = ValidatorsCache.get().getValidators(this);
    }

    protected boolean checkSkip() {
        if (this.isSkip()) {
            this.getLog().info((CharSequence)"Skipping goal (skip flag is on).");
            return false;
        }
        if (this.validators.isEmpty()) {
            this.getLog().info((CharSequence)"Skipping goal (no validator detected).");
            return false;
        }
        return super.checkSkip();
    }

    @Override
    protected abstract Path createOutputFile() throws IOException;

    @Override
    protected abstract boolean isSkip();

    public File getValidatorsFile() {
        return this.validatorsFile;
    }

    public Collection<ValidatorsCache.ValidatorInfo> getValidators() {
        return this.validators;
    }

    @Override
    public URLClassLoader getUrlClassLoader() throws MalformedURLException {
        return this.initClassLoader(this.getProject(), this.validatorsFile.getParentFile(), true, false, true, true, false);
    }
}

