/*
 * #%L
 * Refcomp :: GWT client
 * 
 * $Id: ImportExport.java 114 2011-02-16 17:17:55Z jcouteau $
 * $HeadURL: svn+ssh://jcouteau@scm.mulcyber.toulouse.inra.fr/svnroot/refcomp/tags/refcomp-1.7/refcomp-client/src/main/java/fr/inra/refcomp/client/admin/importexport/ImportExport.java $
 * %%
 * Copyright (C) 2010 - 2011 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.client.admin.importexport;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.uibinder.client.UiTemplate;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.Panel;
import fr.inra.refcomp.client.admin.AdminUtil;

/**
 * User: couteau
 * Date: 17/01/11
 */
public class ImportExport extends Composite {

    protected static final String UPLOAD_ACTION_URL = GWT.getModuleBaseURL() + "upload";

    @UiTemplate("ImportExport.ui.xml")
    interface MyUiBinder extends UiBinder<Panel, ImportExport> {
    }

    private static final MyUiBinder binder = GWT.create(MyUiBinder.class);

    @UiField
    FormPanel form;

    @UiHandler("submit")
    public void submit(ClickEvent event) {
        form.submit();
    }

    @UiHandler("form")
    public void success(FormPanel.SubmitCompleteEvent event) {
        Window.alert("Import successful");
    }

    @UiHandler("exportUsers")
    public void exportUsers(ClickEvent event) {
        Window.open(UPLOAD_ACTION_URL +"?type=users","_blank","");
    }

    @UiHandler("exportSkills")
    public void exportSkills(ClickEvent event) {
        Window.open(UPLOAD_ACTION_URL +"?type=skills","_blank","");
    }

    @UiHandler("exportEntities")
    public void exportEntities(ClickEvent event) {
        Window.open(UPLOAD_ACTION_URL +"?type=entities","_blank","");
    }

    public ImportExport() {
        initWidget(binder.createAndBindUi(this));

        History.newItem("import");

        AdminUtil.checkAdmin();

        form.setAction(UPLOAD_ACTION_URL);

        // Because we're going to add a FileUpload widget, we'll need to set the
        // form to use the POST method, and multipart MIME encoding.
        form.setEncoding(FormPanel.ENCODING_MULTIPART);
        form.setMethod(FormPanel.METHOD_POST);


    }
}
