/*
 * #%L
 * Refcomp :: GWT client
 * 
 * $Id: AdminUsers.java 161 2011-04-18 14:17:01Z jcouteau $
 * $HeadURL: svn+ssh://jcouteau@scm.mulcyber.toulouse.inra.fr/svnroot/refcomp/tags/refcomp-1.6/refcomp-client/src/main/java/fr/inra/refcomp/client/admin/users/AdminUsers.java $
 * %%
 * Copyright (C) 2010 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.client.admin.users;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.uibinder.client.UiTemplate;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Panel;
import fr.inra.refcomp.client.admin.AdminUtil;
import fr.inra.refcomp.client.constants.Form;
import fr.inra.refcomp.client.constants.RefcompCallBack;
import fr.inra.refcomp.client.services.StorageService;
import fr.inra.refcomp.entities.User;
import java.util.List;
import fr.inra.refcomp.client.services.StorageServiceAsync;

/**
 * User: couteau
 * Date: 5 nov. 2010
 */
public class AdminUsers extends Composite {

    private static final StorageServiceAsync service = GWT
            .create(StorageService.class);

    @UiTemplate("AdminUsers.ui.xml")
    interface MyUiBinder extends UiBinder<Panel, AdminUsers> {
    }

    @UiField
    static
    ListBox usersList;

    @UiField
    Form form;

    private static final MyUiBinder binder = GWT.create(MyUiBinder.class);

    @UiHandler("addButton")
    void doClickAdd(ClickEvent event) {
        service.createUser(new RefcompCallBack<User>() {
            @Override
            public void onSuccess(User result) {
                editedBean = result;
                form.setContent(editedBean, true);
            }
        });
    }

    User editedBean;

    public AdminUsers() {
        initWidget(binder.createAndBindUi(this));

        AdminUtil.checkAdmin();

        service.getUsers(new RefcompCallBack<List<User>>() {
            @Override
            public void onSuccess(List<User> result) {
                usersList.clear();
                for (User user : result) {
                    usersList.addItem(user.getLastName() + " " + user.getFirstName(),
                            user.getWikittyId());
                }
            }
        });

        UserForm userForm = new UserForm(UserForm.ADMIN_CONTEXT);

        form.setContentPanel(userForm);

        usersList.addChangeHandler(new ChangeHandler() {
            @Override
            public void onChange(ChangeEvent event) {

                String beanId = usersList.getValue(usersList.getSelectedIndex());

                service.getUser(beanId, new RefcompCallBack<User>() {
                    @Override
                    public void onSuccess(User result) {
                        editedBean = result;
                        form.setContent(editedBean, false);
                    }
                });
            }
        });
    }

    public static void refresh() {
        service.getUsers(new RefcompCallBack<List<User>>() {
            @Override
            public void onSuccess(List<User> result) {
                if (usersList != null) {
                    usersList.clear();
                    for (User user : result) {
                        usersList.addItem(user.getFirstName() + " " + user.getLastName(),
                                user.getWikittyId());
                    }
                }
            }
        });
    }
}
