/*
 * #%L
 * Refcomp :: GWT client
 * 
 * $Id: TreeRootCallback.java 121 2011-03-02 12:36:51Z jcouteau $
 * $HeadURL: svn+ssh://jcouteau@scm.mulcyber.toulouse.inra.fr/svnroot/refcomp/tags/refcomp-1.4/refcomp-client/src/main/java/fr/inra/refcomp/client/admin/skills/TreeRootCallback.java $
 * %%
 * Copyright (C) 2010 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.client.admin.skills;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import fr.inra.refcomp.client.constants.RefcompCallBack;
import fr.inra.refcomp.entities.Skill;
import java.util.List;

/**
 * User: couteau
 * Date: 30 nov. 2010
 */
public class TreeRootCallback extends RefcompCallBack<List<Skill>>
        implements AsyncCallback<List<Skill>> {

    protected Tree browseTree;

    public TreeRootCallback(Tree browseTree) {
        super();
        this.browseTree = browseTree;
    }

    public void onSuccess(List<Skill> skills) {
        browseTree.removeItems();
        for (Skill skill : skills) {
            TreeItem ti = new TreeItem(skill.getName());
            ti.setUserObject(skill);
            ti.addItem("Loading...");
            ti.addStyleName("first");
            browseTree.addItem(ti);
        }
    }
}
