/*
 * #%L
 * Refcomp :: GWT client
 * 
 * $Id: SkillForm.java 105 2011-02-07 10:13:43Z jcouteau $
 * $HeadURL: svn+ssh://jcouteau@scm.mulcyber.toulouse.inra.fr/svnroot/refcomp/tags/refcomp-1.4/refcomp-client/src/main/java/fr/inra/refcomp/client/admin/skills/SkillForm.java $
 * %%
 * Copyright (C) 2010 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.client.admin.skills;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiTemplate;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.TextBox;
import fr.inra.refcomp.client.constants.FormContent;
import fr.inra.refcomp.client.constants.Menu;
import fr.inra.refcomp.client.constants.RefcompCallBack;
import fr.inra.refcomp.client.constants.RefcompMessages;
import fr.inra.refcomp.client.services.StorageService;
import fr.inra.refcomp.client.services.StorageServiceAsync;
import fr.inra.refcomp.entities.Skill;
import fr.inra.refcomp.services.AlreadyExistingException;
import fr.inra.refcomp.services.InvalidEntityException;
import fr.inra.refcomp.services.UsedException;
import org.nuiton.wikitty.entities.BusinessEntity;

/**
 * User: couteau
 * Date: 30 nov. 2010
 */
public class SkillForm extends Composite implements FormContent {

    private final StorageServiceAsync service = GWT
            .create(StorageService.class);

    @UiTemplate("SkillForm.ui.xml")
    interface MyUiBinder extends UiBinder<Panel, SkillForm> {
    }

    private static final MyUiBinder binder = GWT.create(MyUiBinder.class);

    private RefcompMessages messages = GWT.create(RefcompMessages.class);

    @UiField
    TextBox skillBox;

    @UiField
    HTMLPanel errorPanel;

    @UiField
    Label errorLabel;

    Skill bean;

    public SkillForm() {
        initWidget(binder.createAndBindUi(this));
        skillBox.setEnabled(false);
    }

    @Override
    public void setContent(BusinessEntity bean) {
        if ((bean != null) && (bean instanceof Skill)) {
            this.bean = (Skill) bean;

            String name = this.bean.getName();

            if (name == null){
                name = "";
            }
            skillBox.setText(name);
            skillBox.setEnabled(true);
            errorPanel.setVisible(false);
        }
    }

    @Override
    public void clearContent() {
        bean = null;

        skillBox.setText("");
        skillBox.setEnabled(false);
        errorPanel.setVisible(false);
    }

    @Override
    public BusinessEntity getContent() {
        bean.setName(skillBox.getText());
        return bean;
    }

    @Override
    public void saveContent(final Boolean creation) {


        Boolean validate = Window.confirm(messages.sure());

        if (validate) {

            errorPanel.setVisible(false);

            service.saveSkill((Skill) getContent(),
                    new RefcompCallBack<Skill>() {
                        @Override
                        public void onSuccess(Skill result) {
                            setContent(result);
                            if (creation) {
                                AdminSkills.addToSelectedNode(result);
                            } else {
                                AdminSkills.refreshSelectedNode();
                            }
                        }

                        @Override
                        public void onFailure(Throwable caught) {
                            if (caught instanceof InvalidEntityException) {
                                errorPanel.setVisible(true);
                                errorLabel.setText(caught.getMessage());
                            } else {
                                Window.alert(messages.exception());
                            }
                        }
                    });
        }
    }

    @Override
    public void cancelContent(Boolean creation) {

        Boolean validate = Window.confirm(messages.sure());

        if (validate) {
            clearContent();
        }
    }

    @Override
    public void deleteContent() {
        Boolean validate = Window.confirm(messages.sure());

        if (validate) {

            service.deleteSkill((Skill) getContent(),
                    new RefcompCallBack<Void>() {
                        @Override
                        public void onSuccess(Void result) {
                            clearContent();
                            AdminSkills.removeSelectedNode();
                        }

                        @Override
                        public void onFailure(Throwable caught) {
                            if (caught instanceof UsedException){
                                errorPanel.setVisible(true);
                                errorLabel.setText(messages.skillUsed());
                            }
                        }
                    });
        }
    }
}
