/*
 * #%L
 * Refcomp :: GWT client
 * 
 * $Id: AdminUtil.java 164 2011-05-13 13:12:11Z jcouteau $
 * $HeadURL: svn+ssh://jcouteau@scm.mulcyber.toulouse.inra.fr/svnroot/refcomp/tags/refcomp-1.4/refcomp-client/src/main/java/fr/inra/refcomp/client/admin/AdminUtil.java $
 * %%
 * Copyright (C) 2010 - 2011 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.client.admin;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.RootPanel;
import fr.inra.refcomp.client.RefComp;
import fr.inra.refcomp.client.constants.Menu;
import fr.inra.refcomp.client.constants.Unauthorized;
import fr.inra.refcomp.client.services.StorageService;
import fr.inra.refcomp.client.services.StorageServiceAsync;

/**
 * User: couteau
 * Date: 21/12/10
 */
public class AdminUtil {

    private static final StorageServiceAsync service = GWT.create(StorageService.class);

    public static void checkAdmin(){
        service.isAdmin(new AsyncCallback<Boolean>() {
            @Override
            public void onFailure(Throwable throwable) {
                RefComp.logOut();
                RootPanel content = RootPanel.get("content");
                content.clear();
                content.add(new Unauthorized());
            }

            @Override
            public void onSuccess(Boolean isAdmin) {
                if (!isAdmin) {
                    RootPanel content = RootPanel.get("content");
                    content.clear();
                    content.add(new Unauthorized());
                }
            }
        });
    }
}
