/*
 * #%L
 * Refcomp :: GWT client
 * 
 * $Id: Search.java 79 2011-01-27 17:45:56Z jcouteau $
 * $HeadURL: svn+ssh://jcouteau@scm.mulcyber.toulouse.inra.fr/svnroot/refcomp/tags/refcomp-0.1/refcomp-client/src/main/java/fr/inra/refcomp/client/user/Search.java $
 * %%
 * Copyright (C) 2010 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.client.user;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyCodes;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.uibinder.client.UiTemplate;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.TextBox;
import fr.inra.refcomp.client.constants.RefcompCallBack;
import fr.inra.refcomp.client.services.StorageServiceAsync;
import fr.inra.refcomp.client.services.StorageService;
import fr.inra.refcomp.entities.EntitiesList;
import fr.inra.refcomp.entities.Cati;
import fr.inra.refcomp.entities.Department;
import fr.inra.refcomp.entities.Frequency;
import fr.inra.refcomp.entities.Unit;
import java.util.List;

/**
 * User: couteau
 * Date: 3 nov. 2010
 */
public class Search extends Composite {

    protected final StorageServiceAsync service = GWT.create(StorageService.class);

    @UiTemplate("Search.ui.xml")
    interface MyUiBinder extends UiBinder<Panel, Search> {
    }

    protected static final MyUiBinder binder = GWT.create(MyUiBinder.class);

    @UiField
    TextBox searchBox;

    @UiField
    FlowPanel advancedSearchPanel;

    @UiField
    ListBox catiList;

    @UiField
    CheckBox catiCheck;

    @UiField
    ListBox departmentList;

    @UiField
    CheckBox departmentCheck;

    @UiField
    ListBox unitList;

    @UiField
    CheckBox unitCheck;

    @UiField
    ListBox frequencyList;

    @UiField
    CheckBox frequencyCheck;

    @UiField
    RadioButton radioAgent;

    @UiField
    RadioButton radioSkill;

    public Search() {
        initWidget(binder.createAndBindUi(this));

        //Init not visible list boxes while the user does nothing
        service.getCatis(new RefcompCallBack<List<Cati>>() {
            @Override
            public void onSuccess(List<Cati> result) {
                for (Cati cati:result) {
                    catiList.addItem(cati.getName(), cati.getWikittyId());
                }
            }
        });

        service.getDepartments(new RefcompCallBack<List<Department>>() {
            @Override
            public void onSuccess(List<Department> result) {
                for (Department department : result) {
                    departmentList.addItem(department.getName(),
                            department.getWikittyId());
                }
            }
        });

        service.getUnits(new RefcompCallBack<List<Unit>>() {
            @Override
            public void onSuccess(List<Unit> result) {
                for (Unit unit : result) {
                    unitList.addItem(unit.getName(), unit.getWikittyId());
                }
            }
        });

        service.getFrequencies(new RefcompCallBack<List<Frequency>>() {
            @Override
            public void onSuccess(List<Frequency> result) {
                for (Frequency frequency : result) {
                    frequencyList.addItem(frequency.getName(),
                            frequency.getWikittyId());
                }
            }
        });

    }

    /**
     * Manage the display/hide of advanced search panel
     * @param event the click on advanced button event
     */
    @UiHandler("advancedSearch")
    void expandAdvancedSearch(ClickEvent event) {
        Boolean visible = advancedSearchPanel.isVisible();
        advancedSearchPanel.setVisible(!visible);
    }

    /**
     * Submit search when ENTER pressed when typing in search box
     * @param event the key pressed event
     */
    @UiHandler("searchBox")
    void pressKey(KeyPressEvent event) {
        if ((event.getNativeEvent().getKeyCode() == KeyCodes.KEY_ENTER) ||
                (event.getNativeEvent().getCharCode() == KeyCodes.KEY_ENTER)) {
            doClickSubmit(null);
        }
    }

    @UiHandler("radioSkill")
    void selectSkill(ClickEvent event) {
        if(radioSkill.getValue()) {
            frequencyCheck.setEnabled(true);
            frequencyList.setEnabled(true);
        }
    }

    @UiHandler("radioAgent")
    void selectAgent(ClickEvent event) {
        if(radioAgent.getValue()) {
            frequencyCheck.setEnabled(false);
            frequencyList.setEnabled(false);
        }
    }

    /**
     * Submit the form
     * @param event the click submit button event
     */
    @UiHandler("buttonSearch")
    void doClickSubmit(ClickEvent event) {

        String catiFilter = null;
        String departmentFilter = null;
        String frequencyFilter = null;
        String unitFilter = null;

        if (advancedSearchPanel.isVisible() && catiCheck.getValue()){
            catiFilter = catiList.getValue(catiList.getSelectedIndex());
        }

        if (advancedSearchPanel.isVisible() && departmentCheck.getValue()){
            departmentFilter = departmentList.getValue(departmentList.getSelectedIndex());
        }

        if (advancedSearchPanel.isVisible() && unitCheck.getValue()){
            unitFilter = unitList.getValue(unitList.getSelectedIndex());
        }

        if (advancedSearchPanel.isVisible() && frequencyCheck.getValue()){
            frequencyFilter = frequencyList.getValue(frequencyList.getSelectedIndex());
        }

        if (radioSkill.getValue()) {

        service.searchSkill(searchBox.getValue(), catiFilter, departmentFilter,
                unitFilter, frequencyFilter,
                new RefcompCallBack<EntitiesList>() {
                    @Override
                    public void onSuccess(EntitiesList result) {
                        RootPanel content = RootPanel.get("content");
                        content.clear();
                        content.add(new SearchResults(searchBox.getText(), result));
                    }
                });
        }

        if (radioAgent.getValue()) {
            service.searchUser(searchBox.getValue(), catiFilter, departmentFilter,
                    unitFilter, frequencyFilter,
                    new RefcompCallBack<EntitiesList>() {
                        @Override
                        public void onSuccess(EntitiesList result) {
                            RootPanel content = RootPanel.get("content");
                            content.clear();
                            content.add(new AgentSearchResults(searchBox.getText(), result));
                        }
                    });
        }
    }
}
