package fr.ifremer.tutti.ui.swing.content.cruise;

/*
 * #%L
 * Tutti :: UI
 * $Id: ValidateCruiseUIModel.java 1004 2013-05-24 12:54:22Z tchemit $
 * $HeadURL: https://svn.codelutin.com/tutti/tags/tutti-3.3.2/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/cruise/ValidateCruiseUIModel.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.beans.AbstractSerializableBean;
import org.nuiton.validator.NuitonValidatorResult;

import java.util.Map;

/**
 * @author kmorin <kmorin@codelutin.com>
 * @since 1.4
 */
public class ValidateCruiseUIModel extends AbstractSerializableBean {

    private static final long serialVersionUID = 1L;

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(ValidateCruiseUIModel.class);

    public static final String PROPERTY_SELECTED_FISHING_OPERATION = "selectedFishingOperation";

    public static final String PROPERTY_VALIDATOR = "validator";

    protected FishingOperation selectedFishingOperation;

    protected Map<FishingOperation, NuitonValidatorResult> validator;

    public FishingOperation getSelectedFishingOperation() {
        return selectedFishingOperation;
    }

    public void setSelectedFishingOperation(FishingOperation selectedFishingOperation) {
        Object oldValue = getSelectedFishingOperation();
        this.selectedFishingOperation = selectedFishingOperation;
        firePropertyChange(PROPERTY_SELECTED_FISHING_OPERATION, oldValue, selectedFishingOperation);
    }

    public Map<FishingOperation, NuitonValidatorResult> getValidator() {
        return validator;
    }

    public void setValidator(Map<FishingOperation, NuitonValidatorResult> validator) {
        Object oldValue = getValidator();
        this.validator = validator;
        firePropertyChange(PROPERTY_VALIDATOR, oldValue, validator);
    }
}
