package fr.ifremer.tutti.ui.swing.content.actions;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;

import static org.nuiton.i18n.I18n.t;

/**
 * Created on 2/24/15.
 *
 * @author Tony Chemit - chemit@codelutin.com
 * @since 3.14
 */
public class OpenGenericFormatImportScreen extends AbstractChangeScreenAction {

    public OpenGenericFormatImportScreen(MainUIHandler handler) {
        super(handler, true, TuttiScreen.GENERIC_FORMAT_IMPORT);
    }

    @Override
    public void doAction() throws Exception {

        createProgressionModelIfRequired(5);

        getProgressionModel().increments(t("tutti.openGenericFormatImportScreen.step.loading.allGear"));
        getContext().getPersistenceService().getAllGear();

        getProgressionModel().increments(t("tutti.openGenericFormatImportScreen.step.loading.allPerson"));
        getContext().getPersistenceService().getAllPerson();

        getProgressionModel().increments(t("tutti.openGenericFormatImportScreen.step.loading.allSpecies"));
        getContext().getPersistenceService().getAllSpecies();

        getProgressionModel().increments(t("tutti.openGenericFormatImportScreen.step.loading.allVessel"));
        getContext().getPersistenceService().getAllVessel();

        getProgressionModel().increments(t("tutti.openGenericFormatImportScreen.step.loading.ui"));

        super.doAction();
    }
}