package fr.ifremer.tutti.ui.swing.util;

/*
 * #%L
 * Tutti :: UI
 * $Id: WeightUnit.java 1203 2013-09-23 09:39:50Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.5.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/util/WeightUnit.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

/**
 * Different types of weight unit.
 * <p/>
 * Created on 09/22/13.
 *
 * @author Tony Chemit <chemit@codelutin.com>
 * @since 2.5
 */
public enum WeightUnit {
    G(n_("tutti.common.unit.g"), n_("tutti.common.unit.short.g")) {
        @Override
        public Float fromEntity(Float weight) {
            return weight == null ? null : weight * 1000;
        }

        @Override
        public Float toEntity(Float weight) {
            return weight == null ? null : weight / 1000.0f;
        }
    },
    KG(n_("tutti.common.unit.kg"), n_("tutti.common.unit.short.kg")) {
        @Override
        public Float fromEntity(Float weight) {
            return weight;
        }

        @Override
        public Float toEntity(Float weight) {
            return weight;
        }
    };

    private final String i18nShortKey;

    private final String i18nKey;

    WeightUnit(String i18nKey, String i18nShortKey) {
        this.i18nKey = i18nKey;
        this.i18nShortKey = i18nShortKey;
    }

    public String getLabel() {
        return _(i18nKey);
    }

    public String getShortLabel() {
        return _(i18nShortKey);
    }

    /**
     * Transform the given {@code weight} coming from db to ui.
     *
     * @param weight weigth to transform
     * @return the ui representation of the given {@code weight}.
     */
    public abstract Float fromEntity(Float weight);

    /**
     * Transform the given {@code weight} coming from ui to db.
     *
     * @param weight weigth to transform
     * @return the db representation of the given {@code weight}.
     */
    public abstract Float toEntity(Float weight);

    public String decorateLabel(String label) {
        return String.format("%s (%s)", label, getShortLabel());
    }

    public String decorateTip(String tip) {
        String unit = _("tutti.common.unit");
        return String.format("%s (%s %s)", tip, unit, getLabel());
    }
}
