package fr.ifremer.tutti.ui.swing.config;

/*
 * #%L
 * Tutti :: Application
 * $Id: TuttiApplicationConfigProvider.java 1153 2013-07-24 17:35:44Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.5.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/config/TuttiApplicationConfigProvider.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import org.nuiton.config.ApplicationConfigProvider;
import org.nuiton.config.ConfigActionDef;
import org.nuiton.config.ConfigOptionDef;

import java.util.Locale;

import static org.nuiton.i18n.I18n.l_;

/**
 * Application config provider (for site generation).
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class TuttiApplicationConfigProvider implements ApplicationConfigProvider {

    @Override
    public String getName() {
        return "tutti-application";
    }

    @Override
    public String getDescription(Locale locale) {
        return l_(locale, "tutti.config.application");
    }

    @Override
    public ConfigOptionDef[] getOptions() {
        return TuttiApplicationConfigOption.values();
    }

    @Override
    public ConfigActionDef[] getActions() {
        return new ConfigActionDef[0];
    }
}
