package fr.ifremer.tutti.ui.swing.content.config;

/*
 * #%L
 * Tutti :: UI
 * $Id: TuttiConfigUIHandler.java 1037 2013-05-30 12:39:31Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.3.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/config/TuttiConfigUIHandler.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.config.TuttiPersistenceConfigOption;
import fr.ifremer.tutti.service.config.TuttiServiceConfigOption;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.config.TuttiApplicationConfig;
import fr.ifremer.tutti.ui.swing.config.TuttiApplicationConfigOption;
import fr.ifremer.tutti.ui.swing.content.GoToPreviousScreenAction;
import fr.ifremer.tutti.ui.swing.content.ReloadTuttiAction;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionHelper;
import fr.ifremer.tutti.ui.swing.util.editor.TuttiLocationTableCell;
import fr.ifremer.tutti.ui.swing.util.editor.VesselTableCell;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.config.ConfigUI;
import jaxx.runtime.swing.config.ConfigUIHelper;
import jaxx.runtime.swing.config.model.MainCallBackFinalizer;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.swing.JComponent;
import javax.swing.table.TableCellEditor;
import java.awt.BorderLayout;

import static org.nuiton.i18n.I18n.n_;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 1.1
 */
public class TuttiConfigUIHandler extends AbstractTuttiUIHandler<TuttiUIContext, TuttiConfigUI> {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(TuttiConfigUIHandler.class);


    public static final String CALLBACK_APPLICATION = "application";

    public static final String CALLBACK_UI = "ui";

    public static final String CALLBACK_SHORTCUT = "shortcut";

    public TuttiConfigUIHandler(TuttiUI<?, ?> parentUI, TuttiConfigUI ui) {
        super(parentUI.getHandler().getContext(), ui);
    }

    @Override
    public SwingValidator<TuttiUIContext> getValidator() {
        return null;
    }

    @Override
    public void beforeInitUI() {

    }

    @Override
    public void afterInitUI() {

        initUI(ui);

        TuttiApplicationConfig config = getConfig();

        ConfigUIHelper helper = new ConfigUIHelper(config.getApplicationConfig(),
                                                   config.getConfigFile());

        helper.registerCallBack(
                CALLBACK_UI, n_("tutti.config.action.reload.ui"),
                SwingUtil.createActionIcon("reload-ui"),
                new Runnable() {

                    @Override
                    public void run() {
                        reloadUI();
                    }
                }
        ).registerCallBack(
                CALLBACK_APPLICATION, n_("tutti.config.action.reload.application"),
                SwingUtil.createActionIcon("reload-application"),
                new Runnable() {

                    @Override
                    public void run() {
                        reloadApplication();
                    }
                }
        ).registerCallBack(
                CALLBACK_SHORTCUT, n_("tutti.config.action.reload.actions"),
                SwingUtil.createActionIcon("reload-shortcut"),
                new Runnable() {

                    @Override
                    public void run() {
                        reloadShortcuts();
                    }
                }
        );

        // APPLICATION

        helper.addCategory(n_("tutti.config.category.applications"),
                           n_("tutti.config.category.applications.description"),
                           CALLBACK_APPLICATION)
                .addOption(TuttiServiceConfigOption.CSV_SEPARATOR)
                .addOption(TuttiApplicationConfigOption.UI_CONFIG_FILE)
                .addOption(TuttiApplicationConfigOption.TOTAL_SORTED_WEIGHTS_DIFFERENCE_RATE);

        if (context.isDbLoaded()) {

            VesselTableCell vesselTableCellComponent = new VesselTableCell(context);
            helper.addOption(TuttiApplicationConfigOption.TREMIE_CAROUSSEL_VESSEL_ID)
                    .setOptionEditor(vesselTableCellComponent.getNewTableCellEditor())
                    .setOptionRenderer(vesselTableCellComponent.getNewTableCellRenderer());

            TuttiLocationTableCell tuttiLocationTableCellComponent = new TuttiLocationTableCell(context);
            helper.addOption(TuttiServiceConfigOption.EXPORT_COUNTRY_ID)
                    .setOptionEditor(tuttiLocationTableCellComponent.getNewTableCellEditor())
                    .setOptionRenderer(tuttiLocationTableCellComponent.getNewTableCellRenderer());

            SampleOrderIdsTableCell comp = new SampleOrderIdsTableCell(context);

            TableCellEditor sampleOrderEditor = comp.getNewTableCellEditor();
            helper.addOption(TuttiServiceConfigOption.SAMPLING_CATEGORY_ORDER_IDS)
                    .setOptionEditor(sampleOrderEditor)
                    .setOptionRenderer(comp.getNewTableCellRenderer());
        }

        // UI

        helper.addCategory(n_("tutti.config.category.ui"),
                           n_("tutti.config.category.ui.description"),
                           CALLBACK_UI)
                .addOption(TuttiApplicationConfigOption.COLOR_ROW_INVALID)
                .addOption(TuttiApplicationConfigOption.COLOR_ROW_READ_ONLY)
                .addOption(TuttiApplicationConfigOption.COLOR_CELL_WITH_VALUE)
                .addOption(TuttiApplicationConfigOption.COLOR_ROW_TO_CONFIRM)
                .addOption(TuttiApplicationConfigOption.COLOR_COMPUTED_WEIGHTS)
                .addOption(TuttiApplicationConfigOption.COLOR_BLOCKING_LAYER)
                .addOption(TuttiApplicationConfigOption.DATE_FORMAT)
                .addOption(TuttiApplicationConfigOption.COORDINATE_EDITOR_TYPE);

        helper.addCategory(n_("tutti.config.category.technical"),
                           n_("tutti.config.category.technical.description"))
                .addOption(TuttiServiceConfigOption.BASEDIR)
                .addOption(TuttiServiceConfigOption.DATA_DIRECTORY)
                .addOption(TuttiServiceConfigOption.TMP_DIRECTORY)
                .addOption(TuttiApplicationConfigOption.TUTTI_I18N_DIRECTORY)
                .addOption(TuttiApplicationConfigOption.TUTTI_HELP_DIRECTORY)
                .addOption(TuttiPersistenceConfigOption.DB_DIRECTORY)
                .addOption(TuttiPersistenceConfigOption.DB_ATTACHMENT_DIRECTORY)
                .addOption(TuttiPersistenceConfigOption.DB_PROTOCOL_DIRECTORY)
                .addOption(TuttiPersistenceConfigOption.DB_CACHE_DIRECTORY)
                .addOption(TuttiPersistenceConfigOption.DB_CONFIGURATION_PATH)
                .addOption(TuttiPersistenceConfigOption.DB_ENUMERATION_PATH)
                .addOption(TuttiPersistenceConfigOption.JDBC_URL)
                .addOption(TuttiServiceConfigOption.SITE_URL)
                .addOption(TuttiApplicationConfigOption.TUTTI_UPDATE_URL);

        helper.setFinalizer(new MainCallBackFinalizer(CALLBACK_APPLICATION));

        helper.setCloseAction(new Runnable() {
            @Override
            public void run() {

                TuttiActionHelper.runInternalAction(
                        TuttiConfigUIHandler.this,
                        GoToPreviousScreenAction.class);

            }
        });
        ConfigUI configUI = helper.buildUI(
                getUI(),
                n_("tutti.config.category.applications"));

        configUI.getHandler().setTopContainer(getUI());
        getUI().add(configUI, BorderLayout.CENTER);
    }

    @Override
    protected JComponent getComponentToFocus() {
        return getUI();
    }

    @Override
    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug("closing: " + ui);
        }
    }

    protected void reloadApplication() {
        ReloadTuttiAction action = TuttiActionHelper.createLogicAction(this, ReloadTuttiAction.class);
        TuttiActionHelper.runAction(action);
//        TuttiActionHelper.runActionAndWait(this, ReloadTuttiAction.class);
    }

    protected void reloadUI() {
        getContext().getMainUI().getHandler().reloadUI();
    }

    protected void reloadShortcuts() {
        getContext().getMainUI().getHandler().reloadUI();
    }

}
