package fr.ifremer.tutti.ui.swing.content.cruise;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.help.JAXXHelpUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ValidateCruiseUI extends JSplitPane implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<ValidateCruiseUIModel, ValidateCruiseUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1UPW8TQRCdGGzjBAgQJQQRJD4qmnWNIpGAkeVEDkE4iSLcsPat4w3r22V3LjkaxE/gJ0BPg0RHhSioKWgQfwEhClrE7Nm5s8FRUK446XbmvXkzN2/ffIe8s3Btl8cxs1GIsifY6p3t7fXWrmjjPeHaVhrUFvrPRA5yTZgK0nOHcKNZ9/DyAF6u6J7RoQiH0It1mHT4TAnXFQIRrowi2s6VG2l4MTaRPWBNRY1jffXzR+5l8OJ1DiA2pK5IrVw9CpV1crIOORkgXKBKe7yseLhDMqwMd0jvGX9WUdy5+7wnnsJzKNahYLglMoTr/99ywpHgY4NQckZJfMBDgXCrY5nsWNETlmGEKFkkmdun+qytQyQ61raRdIJtcSUDjqKSfG6uGJMwFhCKXR4GSliE5WOz1foUGWm+pwOhEG4fm3LNE2SEhZbVT7zIm4czbvjPGqHuJrkZeDrke3KHo9Shnxvpuuj/TTzArTbaVivlQx5QSnGTGQ7h/Ahkw4okeTZNPquNsMM1lo7uPYWwqnRdiqwfHLjNlYEWC5dHFpJWnWWrnu3iRBPyNqJjhPnmv+54SKG+L+b/8oUnTKK/52a+vP/2rnpghgmqPTs2dcjLtKTG+j5Q+tLTfSdEKFV5jZvFJu2rUHQRJEZfGCOsMQiTOKqXTJl5OKtx1yWKfPHrh49zjz+fgFwVJpXmQZX7/BUoYdfSFLQKYrO0nCg6vX+K3ue8NoQpqzVuSSdbigaV73DlREwDWBgzgFRFq/Tp10zj7fLwEC4dmp4NIv8ICjJUMhTJnTCw+9g7YMo4EQU6s/U4o8PI+hlj/gBrXe4zaQUAAA==";
    private static final Log log = LogFactory.getLog(ValidateCruiseUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected TuttiHelpBroker broker;
    protected ValidateCruiseUIHandler handler;
    protected ValidateCruiseUIModel model;
    protected JTree navigation;
    protected JScrollPane navigationPanel;
    protected FishingOperationsUI operationPanel;
    protected ValidateCruiseUI splitPane = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
          protected void $afterCompleteSetup() {
              handler.afterInitUI();
          }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ValidateCruiseUI(TuttiUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
                  ValidateCruiseUIHandler handler = new ValidateCruiseUIHandler(parentUI, this);
                  setContextValue(handler);
                  handler.beforeInitUI();
            $initialize();
    }

    public ValidateCruiseUI(int param0, boolean param1, Component param2, Component param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ValidateCruiseUI(JAXXContext parentContext, int param1, boolean param2, Component param3, Component param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ValidateCruiseUI(int param0, Component param1, Component param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ValidateCruiseUI(JAXXContext parentContext, int param1, Component param2, Component param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ValidateCruiseUI(int param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ValidateCruiseUI(JAXXContext parentContext, int param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ValidateCruiseUI(int param0) {
        super(param0);
        $initialize();
    }

    public ValidateCruiseUI(JAXXContext parentContext, int param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ValidateCruiseUI() {
        $initialize();
    }

    public ValidateCruiseUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public ValidateCruiseUIHandler getHandler() {
        return handler;
    }

    public ValidateCruiseUIModel getModel() {
        return model;
    }

    public JTree getNavigation() {
        return navigation;
    }

    public JScrollPane getNavigationPanel() {
        return navigationPanel;
    }

    public FishingOperationsUI getOperationPanel() {
        return operationPanel;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToNavigationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        navigationPanel.getViewport().add(navigation);
    }

    protected void addChildrenToSplitPane() {
        if (!allComponentsCreated) {
            return;
        }
        add(navigationPanel, JSplitPane.LEFT);
        add(operationPanel, JSplitPane.RIGHT);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.validateCruise.help"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(ValidateCruiseUIHandler.class));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(ValidateCruiseUIModel.class));
    }

    protected void createNavigation() {
        $objectMap.put("navigation", navigation = new JTree());
        
        navigation.setName("navigation");
        navigation.setRootVisible(false);
    }

    protected void createNavigationPanel() {
        $objectMap.put("navigationPanel", navigationPanel = new JScrollPane());
        
        navigationPanel.setName("navigationPanel");
    }

    protected void createOperationPanel() {
        $objectMap.put("operationPanel", operationPanel = new FishingOperationsUI(this));
        
        operationPanel.setName("operationPanel");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToSplitPane();
        addChildrenToNavigationPanel();
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("splitPane", splitPane);
        createHandler();
        createModel();
        createBroker();
        createNavigationPanel();
        createNavigation();
        createOperationPanel();
        // inline creation of splitPane
        setName("splitPane");
        
        $completeSetup();
    }

}