package fr.ifremer.tutti.ui.swing.content.operation.catches.species;

/*
 * #%L
 * Tutti :: UI
 * $Id: SpeciesBatchUIModel.java 628 2013-03-15 00:56:49Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.1.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/species/SpeciesBatchUIModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import fr.ifremer.tutti.persistence.entities.data.AttachementObjectTypeEnum;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.content.operation.AbstractTuttiBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiComputedOrNotData;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentModelAware;

import java.util.Collection;
import java.util.List;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class SpeciesBatchUIModel extends AbstractTuttiBatchUIModel<SpeciesBatchRowModel, SpeciesBatchUIModel> implements AttachmentModelAware {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_TABLE_VIEW_MODE = "tableViewMode";

    public static final String PROPERTY_ALL_SPECIES = "allSpecies";

    public static final String PROPERTY_CREATE_SPECIES_BATCH_ENABLED = "createSpeciesBatchEnabled";

    public static final String PROPERTY_SPLIT_SPECIES_BATCH_ENABLED = "splitSpeciesBatchEnabled";

    public static final String PROPERTY_REMOVE_SPECIES_SUB_BATCH_ENABLED = "removeSpeciesSubBatchEnabled";

    public static final String PROPERTY_RENAME_SPECIES_BATCH_ENABLED = "renameSpeciesBatchEnabled";

    public static final String PROPERTY_REMOVE_SPECIES_BATCH_ENABLED = "removeSpeciesBatchEnabled";

    public static final String PROPERTY_CREATE_MELAG_ENABLED = "createMelagEnabled";

    public static final String PROPERTY_TABLE_VIEW_MODE_ALL = "tableViewModeAll";

    public static final String PROPERTY_TABLE_VIEW_MODE_LEAF = "tableViewModeLeaf";

    public static final String PROPERTY_TABLE_VIEW_MODE_ROOT = "tableViewModeRoot";

    public static final String PROPERTY_ROOT_NUMBER = "rootNumber";

    public static final String PROPERTY_LEAF_NUMBER = "leafNumber";

    /**
     * All usable species (sets by protocol).
     *
     * @since 0.3
     */
    protected List<Species> allSpecies;

    /**
     * Species already used in some batches.
     *
     * @since 0.3
     */
    protected final Multimap<CaracteristicQualitativeValue, Species>
            speciesUsed = ArrayListMultimap.create();

    /**
     * What to show in the table.
     *
     * @since 0.3
     */
    protected TableViewMode tableViewMode;

    /**
     * Can user create a new species batch ?
     *
     * @since 0.3
     */
    protected boolean createSpeciesBatchEnabled;

    /**
     * Can user split a selected species batch ?
     *
     * @since 0.3
     */
    protected boolean splitSpeciesBatchEnabled;

    /**
     * Can user remove a selected species batch?
     *
     * @since 0.3
     */
    protected boolean removeSpeciesBatchEnabled;

    /**
     * Can user remove a selected species sub batches?
     *
     * @since 0.3
     */
    protected boolean removeSpeciesSubBatchEnabled;

    /**
     * Can user create a melag from the selected species?
     *
     * @since 0.3
     */
    protected boolean createMelagEnabled = true;

    /** @since 1.0 */
    protected int rootNumber;

    /** @since 1.0 */
    protected int leafNumber;

    protected final List<Attachment> attachment = Lists.newArrayList();

    private boolean renameSpeciesBatchEnabled;

    private String rootBatchId;

    public SpeciesBatchUIModel(EditCatchesUIModel catchesUIModel) {
        super(catchesUIModel,
              EditCatchesUIModel.PROPERTY_SPECIES_TOTAL_COMPUTED_WEIGHT,
              EditCatchesUIModel.PROPERTY_SPECIES_TOTAL_SORTED_WEIGHT,
              EditCatchesUIModel.PROPERTY_SPECIES_TOTAL_UNSORTED_COMPUTED_WEIGHT,
              EditCatchesUIModel.PROPERTY_SPECIES_TOTAL_SAMPLE_SORTED_COMPUTED_WEIGHT,
              EditCatchesUIModel.PROPERTY_SPECIES_TOTAL_INERT_WEIGHT,
              EditCatchesUIModel.PROPERTY_SPECIES_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT);
    }

    public Float getSpeciesTotalComputedWeight() {
        return catchesUIModel.getSpeciesTotalComputedWeight();
    }

    public void setSpeciesTotalComputedWeight(Float speciesTotalComputedWeight) {
        catchesUIModel.setSpeciesTotalComputedWeight(speciesTotalComputedWeight);
    }

    public TuttiComputedOrNotData<Float> getSpeciesTotalSortedComputedOrNotWeight() {
        return catchesUIModel.getSpeciesTotalSortedComputedOrNotWeight();
    }

    public Float getSpeciesTotalSortedWeight() {
        return catchesUIModel.getSpeciesTotalSortedWeight();
    }

    public void setSpeciesTotalSortedWeight(Float speciesTotalSortedWeight) {
        catchesUIModel.setSpeciesTotalSortedWeight(speciesTotalSortedWeight);
    }

    public Float getSpeciesTotalSortedComputedWeight() {
        return catchesUIModel.getSpeciesTotalSortedComputedWeight();
    }

    public void setSpeciesTotalSortedComputedWeight(Float speciesTotalSortedComputedWeight) {
        catchesUIModel.setSpeciesTotalSortedComputedWeight(speciesTotalSortedComputedWeight);
    }

    public Float getSpeciesTotalUnsortedComputedWeight() {
        return catchesUIModel.getSpeciesTotalUnsortedComputedWeight();
    }

    public void setSpeciesTotalUnsortedComputedWeight(Float speciesTotalUnsortedComputedWeight) {
        catchesUIModel.setSpeciesTotalUnsortedComputedWeight(speciesTotalUnsortedComputedWeight);
    }

    public Float getSpeciesTotalSampleSortedComputedWeight() {
        return catchesUIModel.getSpeciesTotalSampleSortedComputedWeight();
    }

    public void setSpeciesTotalSampleSortedComputedWeight(Float speciesTotalSampleSortedComputedWeight) {
        catchesUIModel.setSpeciesTotalSampleSortedComputedWeight(speciesTotalSampleSortedComputedWeight);
    }

    public TuttiComputedOrNotData<Float> getSpeciesTotalInertComputedOrNotWeight() {
        return catchesUIModel.getSpeciesTotalInertComputedOrNotWeight();
    }

    public Float getSpeciesTotalInertWeight() {
        return catchesUIModel.getSpeciesTotalInertWeight();
    }

    public void setSpeciesTotalInertWeight(Float speciesTotalInertWeight) {
        catchesUIModel.setSpeciesTotalInertWeight(speciesTotalInertWeight);
    }

    public Float getSpeciesTotalInertComputedWeight() {
        return catchesUIModel.getSpeciesTotalInertComputedWeight();
    }

    public void setSpeciesTotalInertComputedWeight(Float speciesTotalInertComputedWeight) {
        catchesUIModel.setSpeciesTotalInertComputedWeight(speciesTotalInertComputedWeight);
    }

    public TuttiComputedOrNotData<Float> getSpeciesTotalLivingNotItemizedComputedOrNotWeight() {
        return catchesUIModel.getSpeciesTotalLivingNotItemizedComputedOrNotWeight();
    }

    public Float getSpeciesTotalLivingNotItemizedWeight() {
        return catchesUIModel.getSpeciesTotalLivingNotItemizedWeight();
    }

    public void setSpeciesTotalLivingNotItemizedWeight(Float speciesTotalLivingNotItemizedWeight) {
        catchesUIModel.setSpeciesTotalLivingNotItemizedWeight(speciesTotalLivingNotItemizedWeight);
    }

    public Float getSpeciesTotalLivingNotItemizedComputedWeight() {
        return catchesUIModel.getSpeciesTotalLivingNotItemizedComputedWeight();
    }

    public void setSpeciesTotalLivingNotItemizedComputedWeight(Float speciesTotalLivingNotItemizedComputedWeight) {
        catchesUIModel.setSpeciesTotalLivingNotItemizedComputedWeight(speciesTotalLivingNotItemizedComputedWeight);
    }

    public TableViewMode getTableViewMode() {
        return tableViewMode;
    }

    public void setTableViewMode(TableViewMode tableViewMode) {
        Object oldValue = getTableViewMode();
        this.tableViewMode = tableViewMode;
        firePropertyChange(PROPERTY_TABLE_VIEW_MODE, oldValue, tableViewMode);
        firePropertyChange(PROPERTY_TABLE_VIEW_MODE_ALL, null, isTableViewModeAll());
        firePropertyChange(PROPERTY_TABLE_VIEW_MODE_LEAF, null, isTableViewModeLeaf());
        firePropertyChange(PROPERTY_TABLE_VIEW_MODE_ROOT, null, isTableViewModeRoot());
    }

    public boolean isTableViewModeAll() {
        return TableViewMode.ALL.equals(tableViewMode);
    }

    public boolean isTableViewModeLeaf() {
        return TableViewMode.LEAF.equals(tableViewMode);
    }

    public boolean isTableViewModeRoot() {
        return TableViewMode.ROOT.equals(tableViewMode);
    }

    public List<Species> getAllSpecies() {
        return allSpecies;
    }

    public void setAllSpecies(List<Species> allSpecies) {
        Object oldValue = getAllSpecies();
        this.allSpecies = allSpecies;
        firePropertyChange(PROPERTY_ALL_SPECIES, oldValue, allSpecies);
    }

    public Multimap<CaracteristicQualitativeValue, Species> getSpeciesUsed() {
        return speciesUsed;
    }

    public int getRootNumber() {
        return rootNumber;
    }

    public void setRootNumber(int rootNumber) {
        Object oldValue = getRootNumber();
        this.rootNumber = rootNumber;
        firePropertyChange(PROPERTY_ROOT_NUMBER, oldValue, rootNumber);
    }

    public int getLeafNumber() {
        return leafNumber;
    }

    public void setLeafNumber(int leafNumber) {
        Object oldValue = getLeafNumber();
        this.leafNumber = leafNumber;
        firePropertyChange(PROPERTY_LEAF_NUMBER, oldValue, leafNumber);
    }

    public boolean isCreateSpeciesBatchEnabled() {
        return createSpeciesBatchEnabled;
    }

    public void setCreateSpeciesBatchEnabled(boolean createSpeciesBatchEnabled) {
        Object oldValue = isCreateSpeciesBatchEnabled();
        this.createSpeciesBatchEnabled = createSpeciesBatchEnabled;
        firePropertyChange(PROPERTY_CREATE_SPECIES_BATCH_ENABLED, oldValue, createSpeciesBatchEnabled);
    }

    public boolean isSplitSpeciesBatchEnabled() {
        return splitSpeciesBatchEnabled;
    }

    public void setSplitSpeciesBatchEnabled(boolean splitSpeciesBatchEnabled) {
        Object oldValue = isSplitSpeciesBatchEnabled();
        this.splitSpeciesBatchEnabled = splitSpeciesBatchEnabled;
        firePropertyChange(PROPERTY_SPLIT_SPECIES_BATCH_ENABLED, oldValue, splitSpeciesBatchEnabled);
    }

    public boolean isRemoveSpeciesBatchEnabled() {
        return removeSpeciesBatchEnabled;
    }

    public void setRemoveSpeciesBatchEnabled(boolean removeSpeciesBatchEnabled) {
        Object oldValue = isRemoveSpeciesBatchEnabled();
        this.removeSpeciesBatchEnabled = removeSpeciesBatchEnabled;
        firePropertyChange(PROPERTY_REMOVE_SPECIES_BATCH_ENABLED, oldValue, removeSpeciesBatchEnabled);
    }

    public boolean isRemoveSpeciesSubBatchEnabled() {
        return removeSpeciesSubBatchEnabled;
    }

    public void setRemoveSpeciesSubBatchEnabled(boolean removeSpeciesSubBatchEnabled) {
        Object oldValue = isRemoveSpeciesSubBatchEnabled();
        this.removeSpeciesSubBatchEnabled = removeSpeciesSubBatchEnabled;
        firePropertyChange(PROPERTY_REMOVE_SPECIES_SUB_BATCH_ENABLED, oldValue, removeSpeciesSubBatchEnabled);
    }

    public void setRenameSpeciesBatchEnabled(boolean renameSpeciesBatchEnabled) {
        Object oldValue = isRenameSpeciesBatchEnabled();
        this.renameSpeciesBatchEnabled = renameSpeciesBatchEnabled;
        firePropertyChange(PROPERTY_RENAME_SPECIES_BATCH_ENABLED, oldValue, renameSpeciesBatchEnabled);
    }

    public boolean isRenameSpeciesBatchEnabled() {
        return renameSpeciesBatchEnabled;
    }

    public boolean isCreateMelagEnabled() {
        return createMelagEnabled;
    }

    public void setCreateMelagEnabled(boolean createMelagEnabled) {
        Object oldValue = isCreateMelagEnabled();
        this.createMelagEnabled = createMelagEnabled;
        firePropertyChange(PROPERTY_CREATE_MELAG_ENABLED, oldValue, createMelagEnabled);
    }

    public void setRootBatchId(String rootBatchId) {
        String oldValue = getObjectId();
        this.rootBatchId = rootBatchId;
        firePropertyChange(PROPERTY_OBJECT_ID, oldValue, getObjectId());
    }

    public String getRootBatchId() {
        return rootBatchId;
    }

    @Override
    public AttachementObjectTypeEnum getObjectType() {
        return AttachementObjectTypeEnum.CATCH_BATCH;
    }

    @Override
    public String getObjectId() {
        return rootBatchId;
    }

    @Override
    public List<Attachment> getAttachment() {
        return attachment;
    }

    @Override
    public void addAllAttachment(Collection<Attachment> attachments) {
        this.attachment.addAll(attachments);
        firePropertyChange(PROPERTY_ATTACHMENT, null, getAttachment());
    }

    @Override
    public void addAttachment(Attachment attachment) {
        this.attachment.add(attachment);
        firePropertyChange(PROPERTY_ATTACHMENT, null, getAttachment());
    }

    @Override
    public void removeAllAttachment(Collection<Attachment> attachments) {
        this.attachment.removeAll(attachments);
        firePropertyChange(PROPERTY_ATTACHMENT, null, getAttachment());
    }

    @Override
    public void removeAttachment(Attachment attachment) {
        this.attachment.remove(attachment);
        firePropertyChange(PROPERTY_ATTACHMENT, null, getAttachment());
    }

}
