package fr.ifremer.tutti.ui.swing.content.operation.catches.macrowaste;

/*
 * #%L
 * Tutti :: UI
 * $Id: MacroWasteBatchTableModel.java 629 2013-03-15 09:48:31Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.1.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/macrowaste/MacroWasteBatchTableModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableModel;
import fr.ifremer.tutti.ui.swing.util.table.ColumnIdentifier;
import org.jdesktop.swingx.table.TableColumnModelExt;

import static org.nuiton.i18n.I18n.n_;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 0.2
 */
public class MacroWasteBatchTableModel extends AbstractTuttiTableModel<MacroWasteBatchRowModel> {

    private static final long serialVersionUID = 1L;

    public static final ColumnIdentifier<MacroWasteBatchRowModel> MACRO_WASTE_CATEGORY = ColumnIdentifier.newId(
            MacroWasteBatchRowModel.PROPERTY_MACRO_WASTE_CATEGORY,
            n_("tutti.editMacroWasteBatch.table.header.macroWasteCategory"),
            n_("tutti.editMacroWasteBatch.table.header.macroWasteCategory"));

    public static final ColumnIdentifier<MacroWasteBatchRowModel> MACRO_WASTE_SIZE_CATEGORY = ColumnIdentifier.newId(
            MacroWasteBatchRowModel.PROPERTY_MACRO_WASTE_SIZE_CATEGORY,
            n_("tutti.editMacroWasteBatch.table.header.macroWasteSizeCategory"),
            n_("tutti.editMacroWasteBatch.table.header.macroWasteSizeCategory"));

    public static final ColumnIdentifier<MacroWasteBatchRowModel> WEIGHT = ColumnIdentifier.newId(
            MacroWasteBatchRowModel.PROPERTY_WEIGHT,
            n_("tutti.editMacroWasteBatch.table.header.weight"),
            n_("tutti.editMacroWasteBatch.table.header.weight"));

    public static final ColumnIdentifier<MacroWasteBatchRowModel> NUMBER = ColumnIdentifier.newId(
            MacroWasteBatchRowModel.PROPERTY_NUMBER,
            n_("tutti.editMacroWasteBatch.table.header.number"),
            n_("tutti.editMacroWasteBatch.table.header.number"));

    public static final ColumnIdentifier<MacroWasteBatchRowModel> COMMENT = ColumnIdentifier.newId(
            MacroWasteBatchRowModel.PROPERTY_COMMENT,
            n_("tutti.editMacroWasteBatch.table.header.comment"),
            n_("tutti.editMacroWasteBatch.table.header.comment"));

    public static final ColumnIdentifier<MacroWasteBatchRowModel> ATTACHMENT = ColumnIdentifier.newId(
            MacroWasteBatchRowModel.PROPERTY_ATTACHMENT,
            n_("tutti.editMacroWasteBatch.table.header.file"),
            n_("tutti.editMacroWasteBatch.table.header.file"));

    public MacroWasteBatchTableModel(TableColumnModelExt columnModel) {
        super(columnModel, true, true);

        setNoneEditableCols();
    }

    @Override
    public MacroWasteBatchRowModel createNewRow() {
        MacroWasteBatchRowModel result = new MacroWasteBatchRowModel();

        // by default empty row is not valid
        result.setValid(false);
        return result;
    }

}