package fr.ifremer.tutti.ui.swing.content.operation;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.referential.FishingOperationLocation;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.GearUseFeatureTabUI;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.VesselUseFeatureTabUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.attachment.ButtonAttachment;
import fr.ifremer.tutti.ui.swing.util.editor.CoordinateEditorType;
import fr.ifremer.tutti.ui.swing.util.editor.SimpleTimeEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.CardLayout2Ext;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.TabInfo;
import jaxx.runtime.swing.TabInfoPropertyChangeListener;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.swing.editor.TimeEditor;
import jaxx.runtime.swing.editor.bean.BeanDoubleList;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.editor.bean.BeanListHeader;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTitledPanel;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n._;

public class EditFishingOperationUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<EditFishingOperationUIModel, EditFishingOperationUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_COMMENT_FIELD_TEXT = "commentField.text";
    public static final String BINDING_DURATION_FIELD_TEXT = "durationField.text";
    public static final String BINDING_FISHING_OPERATION_ATTACHMENTS_BUTTON_ENABLED = "fishingOperationAttachmentsButton.enabled";
    public static final String BINDING_FISHING_OPERATION_INVALID_RADIO_SELECTED = "fishingOperationInvalidRadio.selected";
    public static final String BINDING_FISHING_OPERATION_NUMBER_FIELD_MODEL = "fishingOperationNumberField.model";
    public static final String BINDING_FISHING_OPERATION_NUMBER_FIELD_NUMBER_PATTERN = "fishingOperationNumberField.numberPattern";
    public static final String BINDING_FISHING_OPERATION_RECTILIGNE_CHECK_BOX_SELECTED = "fishingOperationRectiligneCheckBox.selected";
    public static final String BINDING_FISHING_OPERATION_RESET_RADIO_SELECTED = "fishingOperationResetRadio.selected";
    public static final String BINDING_FISHING_OPERATION_VALID_RADIO_SELECTED = "fishingOperationValidRadio.selected";
    public static final String BINDING_GEAR_COMBO_BOX_SELECTED_ITEM = "gearComboBox.selectedItem";
    public static final String BINDING_GEAR_SHOOTING_END_DATE_FIELD_DATE = "gearShootingEndDateField.date";
    public static final String BINDING_GEAR_SHOOTING_END_LATITUDE_DDFIELD_MODEL = "gearShootingEndLatitudeDDField.model";
    public static final String BINDING_GEAR_SHOOTING_END_LATITUDE_DMDDEGREE_FIELD_MODEL = "gearShootingEndLatitudeDMDDegreeField.model";
    public static final String BINDING_GEAR_SHOOTING_END_LATITUDE_DMDDEGREE_FIELD_NUMBER_PATTERN = "gearShootingEndLatitudeDMDDegreeField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_END_LATITUDE_DMDMINUTE_FIELD_MODEL = "gearShootingEndLatitudeDMDMinuteField.model";
    public static final String BINDING_GEAR_SHOOTING_END_LATITUDE_DMDMINUTE_FIELD_NUMBER_PATTERN = "gearShootingEndLatitudeDMDMinuteField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_END_LATITUDE_DMSDEGREE_FIELD_MODEL = "gearShootingEndLatitudeDMSDegreeField.model";
    public static final String BINDING_GEAR_SHOOTING_END_LATITUDE_DMSDEGREE_FIELD_NUMBER_PATTERN = "gearShootingEndLatitudeDMSDegreeField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_END_LATITUDE_DMSMINUTE_FIELD_MODEL = "gearShootingEndLatitudeDMSMinuteField.model";
    public static final String BINDING_GEAR_SHOOTING_END_LATITUDE_DMSMINUTE_FIELD_NUMBER_PATTERN = "gearShootingEndLatitudeDMSMinuteField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_END_LATITUDE_DMSSECOND_FIELD_MODEL = "gearShootingEndLatitudeDMSSecondField.model";
    public static final String BINDING_GEAR_SHOOTING_END_LATITUDE_DMSSECOND_FIELD_NUMBER_PATTERN = "gearShootingEndLatitudeDMSSecondField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_END_LONGITUDE_DDFIELD_MODEL = "gearShootingEndLongitudeDDField.model";
    public static final String BINDING_GEAR_SHOOTING_END_LONGITUDE_DMDDEGREE_FIELD_MODEL = "gearShootingEndLongitudeDMDDegreeField.model";
    public static final String BINDING_GEAR_SHOOTING_END_LONGITUDE_DMDDEGREE_FIELD_NUMBER_PATTERN = "gearShootingEndLongitudeDMDDegreeField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_END_LONGITUDE_DMDMINUTE_FIELD_MODEL = "gearShootingEndLongitudeDMDMinuteField.model";
    public static final String BINDING_GEAR_SHOOTING_END_LONGITUDE_DMDMINUTE_FIELD_NUMBER_PATTERN = "gearShootingEndLongitudeDMDMinuteField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_END_LONGITUDE_DMSDEGREE_FIELD_MODEL = "gearShootingEndLongitudeDMSDegreeField.model";
    public static final String BINDING_GEAR_SHOOTING_END_LONGITUDE_DMSDEGREE_FIELD_NUMBER_PATTERN = "gearShootingEndLongitudeDMSDegreeField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_END_LONGITUDE_DMSMINUTE_FIELD_MODEL = "gearShootingEndLongitudeDMSMinuteField.model";
    public static final String BINDING_GEAR_SHOOTING_END_LONGITUDE_DMSMINUTE_FIELD_NUMBER_PATTERN = "gearShootingEndLongitudeDMSMinuteField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_END_LONGITUDE_DMSSECOND_FIELD_MODEL = "gearShootingEndLongitudeDMSSecondField.model";
    public static final String BINDING_GEAR_SHOOTING_END_LONGITUDE_DMSSECOND_FIELD_NUMBER_PATTERN = "gearShootingEndLongitudeDMSSecondField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_END_TIME_FIELD_DATE = "gearShootingEndTimeField.date";
    public static final String BINDING_GEAR_SHOOTING_START_DATE_FIELD_DATE = "gearShootingStartDateField.date";
    public static final String BINDING_GEAR_SHOOTING_START_LATITUDE_DDFIELD_MODEL = "gearShootingStartLatitudeDDField.model";
    public static final String BINDING_GEAR_SHOOTING_START_LATITUDE_DMDDEGREE_FIELD_MODEL = "gearShootingStartLatitudeDMDDegreeField.model";
    public static final String BINDING_GEAR_SHOOTING_START_LATITUDE_DMDDEGREE_FIELD_NUMBER_PATTERN = "gearShootingStartLatitudeDMDDegreeField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_START_LATITUDE_DMDMINUTE_FIELD_MODEL = "gearShootingStartLatitudeDMDMinuteField.model";
    public static final String BINDING_GEAR_SHOOTING_START_LATITUDE_DMDMINUTE_FIELD_NUMBER_PATTERN = "gearShootingStartLatitudeDMDMinuteField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_START_LATITUDE_DMSDEGREE_FIELD_MODEL = "gearShootingStartLatitudeDMSDegreeField.model";
    public static final String BINDING_GEAR_SHOOTING_START_LATITUDE_DMSDEGREE_FIELD_NUMBER_PATTERN = "gearShootingStartLatitudeDMSDegreeField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_START_LATITUDE_DMSMINUTE_FIELD_MODEL = "gearShootingStartLatitudeDMSMinuteField.model";
    public static final String BINDING_GEAR_SHOOTING_START_LATITUDE_DMSMINUTE_FIELD_NUMBER_PATTERN = "gearShootingStartLatitudeDMSMinuteField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_START_LATITUDE_DMSSECOND_FIELD_MODEL = "gearShootingStartLatitudeDMSSecondField.model";
    public static final String BINDING_GEAR_SHOOTING_START_LATITUDE_DMSSECOND_FIELD_NUMBER_PATTERN = "gearShootingStartLatitudeDMSSecondField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_START_LONGITUDE_DDFIELD_MODEL = "gearShootingStartLongitudeDDField.model";
    public static final String BINDING_GEAR_SHOOTING_START_LONGITUDE_DMDDEGREE_FIELD_MODEL = "gearShootingStartLongitudeDMDDegreeField.model";
    public static final String BINDING_GEAR_SHOOTING_START_LONGITUDE_DMDDEGREE_FIELD_NUMBER_PATTERN = "gearShootingStartLongitudeDMDDegreeField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_START_LONGITUDE_DMDMINUTE_FIELD_MODEL = "gearShootingStartLongitudeDMDMinuteField.model";
    public static final String BINDING_GEAR_SHOOTING_START_LONGITUDE_DMDMINUTE_FIELD_NUMBER_PATTERN = "gearShootingStartLongitudeDMDMinuteField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_START_LONGITUDE_DMSDEGREE_FIELD_MODEL = "gearShootingStartLongitudeDMSDegreeField.model";
    public static final String BINDING_GEAR_SHOOTING_START_LONGITUDE_DMSDEGREE_FIELD_NUMBER_PATTERN = "gearShootingStartLongitudeDMSDegreeField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_START_LONGITUDE_DMSMINUTE_FIELD_MODEL = "gearShootingStartLongitudeDMSMinuteField.model";
    public static final String BINDING_GEAR_SHOOTING_START_LONGITUDE_DMSMINUTE_FIELD_NUMBER_PATTERN = "gearShootingStartLongitudeDMSMinuteField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_START_LONGITUDE_DMSSECOND_FIELD_MODEL = "gearShootingStartLongitudeDMSSecondField.model";
    public static final String BINDING_GEAR_SHOOTING_START_LONGITUDE_DMSSECOND_FIELD_NUMBER_PATTERN = "gearShootingStartLongitudeDMSSecondField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_START_TIME_FIELD_DATE = "gearShootingStartTimeField.date";
    public static final String BINDING_IMPORT_CASINO_BUTTON_ENABLED = "importCasinoButton.enabled";
    public static final String BINDING_LOCATION_COMBO_BOX_SELECTED_ITEM = "locationComboBox.selectedItem";
    public static final String BINDING_MULTIRIG_AGGREGATION_FIELD_TEXT = "multirigAggregationField.text";
    public static final String BINDING_STATION_NUMBER_FIELD_TEXT = "stationNumberField.text";
    public static final String BINDING_STRATA_COMBO_BOX_SELECTED_ITEM = "strataComboBox.selectedItem";
    public static final String BINDING_SUB_STRATA_COMBO_BOX_SELECTED_ITEM = "subStrataComboBox.selectedItem";
    public static final String BINDING_TRAWL_DISTANCE_FIELD_ENABLED = "trawlDistanceField.enabled";
    public static final String BINDING_TRAWL_DISTANCE_FIELD_MODEL = "trawlDistanceField.model";
    public static final String BINDING_TRAWL_DISTANCE_FIELD_NUMBER_PATTERN = "trawlDistanceField.numberPattern";
    public static final String BINDING_TRAWL_DISTANCE_FIELD_TOOL_TIP_TEXT = "trawlDistanceField.toolTipText";
    public static final String BINDING_VESSEL_COMBO_BOX_SELECTED_ITEM = "vesselComboBox.selectedItem";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(EditFishingOperationUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected TuttiHelpBroker broker;
    protected JButton cancelButton;
    protected JTextArea commentField;
    @ValidatorField( validatorId = "validator",  propertyName = "comment",  editorName = "commentPane")
    protected JScrollPane commentPane;
    protected JPanel createFishingOperationActions;
    protected JTextField durationField;
    protected JLabel durationLabel;
    protected EditFishingOperationUI editFishingOperationTopPanel = this;
    protected ButtonAttachment fishingOperationAttachmentsButton;
    protected JRadioButton fishingOperationInvalidRadio;
    @ValidatorField( validatorId = "validator",  propertyName = "fishingOperationNumber",  editorName = "fishingOperationNumberField")
    protected NumberEditor fishingOperationNumberField;
    protected JLabel fishingOperationNumberLabel;
    protected JPanel fishingOperationPane;
    protected JCheckBox fishingOperationRectiligneCheckBox;
    protected JRadioButton fishingOperationResetRadio;
    protected JTabbedPane fishingOperationTabPane;
    protected JAXXButtonGroup fishingOperationValid;
    @ValidatorField( validatorId = "validator",  propertyName = "fishingOperationValid",  editorName = "fishingOperationValidPanel")
    protected JToolBar fishingOperationValidPanel;
    protected JRadioButton fishingOperationValidRadio;
    protected Table gearCaracteristicsTable;
    @ValidatorField( validatorId = "validator",  propertyName = "gear",  editorName = "gearComboBox")
    protected BeanFilterableComboBox<Gear> gearComboBox;
    protected JLabel gearDateLabel;
    protected JLabel gearLabel;
    protected JLabel gearLatitudeLabel;
    protected JLabel gearLongitudeLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingEndDate",  editorName = "gearShootingEndDateField")
    protected JXDatePicker gearShootingEndDateField;
    protected JLabel gearShootingEndLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingEndLatitude",  editorName = "gearShootingEndLatitudeDDField")
    protected NumberEditor gearShootingEndLatitudeDDField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingEndLatitudeDecimalDegree",  editorName = "gearShootingEndLatitudeDMDDegreeField")
    protected NumberEditor gearShootingEndLatitudeDMDDegreeField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingEndLatitudeDecimalMinute",  editorName = "gearShootingEndLatitudeDMDMinuteField")
    protected NumberEditor gearShootingEndLatitudeDMDMinuteField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingEndLatitudeDegree",  editorName = "gearShootingEndLatitudeDMSDegreeField")
    protected NumberEditor gearShootingEndLatitudeDMSDegreeField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingEndLatitudeMinute",  editorName = "gearShootingEndLatitudeDMSMinuteField")
    protected NumberEditor gearShootingEndLatitudeDMSMinuteField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingEndLatitudeSecond",  editorName = "gearShootingEndLatitudeDMSSecondField")
    protected NumberEditor gearShootingEndLatitudeDMSSecondField;
    protected CardLayout2Ext gearShootingEndLatitudeLayout;
    protected JPanel gearShootingEndLatitudePanel;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingEndLongitude",  editorName = "gearShootingEndLongitudeDDField")
    protected NumberEditor gearShootingEndLongitudeDDField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingEndLongitudeDecimalDegree",  editorName = "gearShootingEndLongitudeDMDDegreeField")
    protected NumberEditor gearShootingEndLongitudeDMDDegreeField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingEndLongitudeDecimalMinute",  editorName = "gearShootingEndLongitudeDMDMinuteField")
    protected NumberEditor gearShootingEndLongitudeDMDMinuteField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingEndLongitudeDegree",  editorName = "gearShootingEndLongitudeDMSDegreeField")
    protected NumberEditor gearShootingEndLongitudeDMSDegreeField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingEndLongitudeMinute",  editorName = "gearShootingEndLongitudeDMSMinuteField")
    protected NumberEditor gearShootingEndLongitudeDMSMinuteField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingEndLongitudeSecond",  editorName = "gearShootingEndLongitudeDMSSecondField")
    protected NumberEditor gearShootingEndLongitudeDMSSecondField;
    protected CardLayout2Ext gearShootingEndLongitudeLayout;
    protected JPanel gearShootingEndLongitudePanel;
    protected SimpleTimeEditor gearShootingEndTimeField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingStartDate",  editorName = "gearShootingStartDateField")
    protected JXDatePicker gearShootingStartDateField;
    protected JLabel gearShootingStartLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingStartLatitude",  editorName = "gearShootingStartLatitudeDDField")
    protected NumberEditor gearShootingStartLatitudeDDField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingStartLatitudeDecimalDegree",  editorName = "gearShootingStartLatitudeDMDDegreeField")
    protected NumberEditor gearShootingStartLatitudeDMDDegreeField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingStartLatitudeDecimalMinute",  editorName = "gearShootingStartLatitudeDMDMinuteField")
    protected NumberEditor gearShootingStartLatitudeDMDMinuteField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingStartLatitudeDegree",  editorName = "gearShootingStartLatitudeDMSDegreeField")
    protected NumberEditor gearShootingStartLatitudeDMSDegreeField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingStartLatitudeMinute",  editorName = "gearShootingStartLatitudeDMSMinuteField")
    protected NumberEditor gearShootingStartLatitudeDMSMinuteField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingStartLatitudeSecond",  editorName = "gearShootingStartLatitudeDMSSecondField")
    protected NumberEditor gearShootingStartLatitudeDMSSecondField;
    protected CardLayout2Ext gearShootingStartLatitudeLayout;
    protected JPanel gearShootingStartLatitudePanel;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingStartLongitude",  editorName = "gearShootingStartLongitudeDDField")
    protected NumberEditor gearShootingStartLongitudeDDField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingStartLongitudeDecimalDegree",  editorName = "gearShootingStartLongitudeDMDDegreeField")
    protected NumberEditor gearShootingStartLongitudeDMDDegreeField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingStartLongitudeDecimalMinute",  editorName = "gearShootingStartLongitudeDMDMinuteField")
    protected NumberEditor gearShootingStartLongitudeDMDMinuteField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingStartLongitudeDegree",  editorName = "gearShootingStartLongitudeDMSDegreeField")
    protected NumberEditor gearShootingStartLongitudeDMSDegreeField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingStartLongitudeMinute",  editorName = "gearShootingStartLongitudeDMSMinuteField")
    protected NumberEditor gearShootingStartLongitudeDMSMinuteField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingStartLongitudeSecond",  editorName = "gearShootingStartLongitudeDMSSecondField")
    protected NumberEditor gearShootingStartLongitudeDMSSecondField;
    protected CardLayout2Ext gearShootingStartLongitudeLayout;
    protected JPanel gearShootingStartLongitudePanel;
    protected SimpleTimeEditor gearShootingStartTimeField;
    protected JLabel gearTimeLabel;
    protected TabInfo gearUseFeatureTab;
    protected GearUseFeatureTabUI gearUseFeatureTabContent;
    protected JXTitledPanel gearUseFeatureTabPane;
    protected Table generalForm;
    protected EditFishingOperationUIHandler handler;
    protected JButton importCasinoButton;
    @ValidatorField( validatorId = "validator",  propertyName = "location",  editorName = "locationComboBox")
    protected BeanFilterableComboBox<FishingOperationLocation> locationComboBox;
    protected JLabel locationLabel;
    protected EditFishingOperationUIModel model;
    @ValidatorField( validatorId = "validator",  propertyName = "multirigAggregation",  editorName = "multirigAggregationField")
    protected JTextField multirigAggregationField;
    protected JLabel multirigAggregationLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "recorderPerson",  editorName = "recorderPersonList")
    protected BeanDoubleList<Person> recorderPersonList;
    protected JButton resetValidStateButton;
    protected JButton saveButton;
    @ValidatorField( validatorId = "validator",  propertyName = "stationNumber",  editorName = "stationNumberField")
    protected JTextField stationNumberField;
    protected JLabel stationNumberLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "strata",  editorName = "strataComboBox")
    protected BeanFilterableComboBox<FishingOperationLocation> strataComboBox;
    protected JLabel strataLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "subStrata",  editorName = "subStrataComboBox")
    protected BeanFilterableComboBox<FishingOperationLocation> subStrataComboBox;
    protected JLabel subStrataLabel;
    protected TabInfo traitGeneralTab;
    protected JXTitledPanel traitGeneralTabPane;
    protected JToolBar traitGeneralTabPaneToolBar;
    protected Table traitVesselPanel;
    @ValidatorField( validatorId = "validator",  propertyName = "trawlDistance",  editorName = "trawlDistanceField")
    protected NumberEditor trawlDistanceField;
    protected JLabel trawlDistanceLabel;
    @Validator( validatorId = "validator")
    protected SwingValidator<EditFishingOperationUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();
    @ValidatorField( validatorId = "validator",  propertyName = "vessel",  editorName = "vesselComboBox")
    protected BeanFilterableComboBox<Vessel> vesselComboBox;
    protected JLabel vesselLabel;
    protected TabInfo vesselUseFeatureTab;
    protected VesselUseFeatureTabUI vesselUseFeatureTabContent;
    protected JXTitledPanel vesselUseFeatureTabPane;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private HBox $HBox0;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JPanel $JPanel10;
    private JPanel $JPanel11;
    private JPanel $JPanel12;
    private JPanel $JPanel13;
    private JPanel $JPanel14;
    private JPanel $JPanel2;
    private JPanel $JPanel3;
    private JPanel $JPanel4;
    private JPanel $JPanel5;
    private JPanel $JPanel6;
    private JPanel $JPanel7;
    private JPanel $JPanel8;
    private JPanel $JPanel9;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    protected void $afterCompleteSetup() { handler.afterInitUI(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EditFishingOperationUI(FishingOperationsUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
            EditFishingOperationUIHandler handler = new EditFishingOperationUIHandler(parentUI, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public EditFishingOperationUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EditFishingOperationUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditFishingOperationUI() {
        $initialize();
    }

    public EditFishingOperationUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditFishingOperationUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public EditFishingOperationUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditFishingOperationUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public EditFishingOperationUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__fishingOperationInvalidRadio(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setFishingOperationValid(Boolean.FALSE);
    }

    public void doActionPerformed__on__fishingOperationValidRadio(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setFishingOperationValid(Boolean.TRUE);
    }

    public void doActionPerformed__on__gearShootingEndDateField(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setDate(event, "gearShootingEndDate");
    }

    public void doActionPerformed__on__gearShootingStartDateField(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setDate(event, "gearShootingStartDate");
    }

    public void doActionPerformed__on__resetValidStateButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setFishingOperationValid(null);
    }

    public void doFocusGained__on__commentPane(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        commentField.requestFocus();
    }

    public void doItemStateChanged__on__fishingOperationRectiligneCheckBox(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setBoolean(event, "fishingOperationRectiligne");
    }

    public void doKeyReleased__on__commentField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "comment");
    }

    public void doKeyReleased__on__multirigAggregationField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "multirigAggregation");
    }

    public void doKeyReleased__on__stationNumberField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "stationNumber");
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public JTextArea getCommentField() {
        return commentField;
    }

    public JScrollPane getCommentPane() {
        return commentPane;
    }

    public JPanel getCreateFishingOperationActions() {
        return createFishingOperationActions;
    }

    public JTextField getDurationField() {
        return durationField;
    }

    public JLabel getDurationLabel() {
        return durationLabel;
    }

    public ButtonAttachment getFishingOperationAttachmentsButton() {
        return fishingOperationAttachmentsButton;
    }

    public JRadioButton getFishingOperationInvalidRadio() {
        return fishingOperationInvalidRadio;
    }

    public NumberEditor getFishingOperationNumberField() {
        return fishingOperationNumberField;
    }

    public JLabel getFishingOperationNumberLabel() {
        return fishingOperationNumberLabel;
    }

    public JPanel getFishingOperationPane() {
        return fishingOperationPane;
    }

    public JCheckBox getFishingOperationRectiligneCheckBox() {
        return fishingOperationRectiligneCheckBox;
    }

    public JRadioButton getFishingOperationResetRadio() {
        return fishingOperationResetRadio;
    }

    public JTabbedPane getFishingOperationTabPane() {
        return fishingOperationTabPane;
    }

    public JAXXButtonGroup getFishingOperationValid() {
        return fishingOperationValid;
    }

    public JToolBar getFishingOperationValidPanel() {
        return fishingOperationValidPanel;
    }

    public JRadioButton getFishingOperationValidRadio() {
        return fishingOperationValidRadio;
    }

    public Table getGearCaracteristicsTable() {
        return gearCaracteristicsTable;
    }

    public BeanFilterableComboBox<Gear> getGearComboBox() {
        return gearComboBox;
    }

    public JLabel getGearDateLabel() {
        return gearDateLabel;
    }

    public JLabel getGearLabel() {
        return gearLabel;
    }

    public JLabel getGearLatitudeLabel() {
        return gearLatitudeLabel;
    }

    public JLabel getGearLongitudeLabel() {
        return gearLongitudeLabel;
    }

    public JXDatePicker getGearShootingEndDateField() {
        return gearShootingEndDateField;
    }

    public JLabel getGearShootingEndLabel() {
        return gearShootingEndLabel;
    }

    public NumberEditor getGearShootingEndLatitudeDDField() {
        return gearShootingEndLatitudeDDField;
    }

    public NumberEditor getGearShootingEndLatitudeDMDDegreeField() {
        return gearShootingEndLatitudeDMDDegreeField;
    }

    public NumberEditor getGearShootingEndLatitudeDMDMinuteField() {
        return gearShootingEndLatitudeDMDMinuteField;
    }

    public NumberEditor getGearShootingEndLatitudeDMSDegreeField() {
        return gearShootingEndLatitudeDMSDegreeField;
    }

    public NumberEditor getGearShootingEndLatitudeDMSMinuteField() {
        return gearShootingEndLatitudeDMSMinuteField;
    }

    public NumberEditor getGearShootingEndLatitudeDMSSecondField() {
        return gearShootingEndLatitudeDMSSecondField;
    }

    public CardLayout2Ext getGearShootingEndLatitudeLayout() {
        return gearShootingEndLatitudeLayout;
    }

    public JPanel getGearShootingEndLatitudePanel() {
        return gearShootingEndLatitudePanel;
    }

    public NumberEditor getGearShootingEndLongitudeDDField() {
        return gearShootingEndLongitudeDDField;
    }

    public NumberEditor getGearShootingEndLongitudeDMDDegreeField() {
        return gearShootingEndLongitudeDMDDegreeField;
    }

    public NumberEditor getGearShootingEndLongitudeDMDMinuteField() {
        return gearShootingEndLongitudeDMDMinuteField;
    }

    public NumberEditor getGearShootingEndLongitudeDMSDegreeField() {
        return gearShootingEndLongitudeDMSDegreeField;
    }

    public NumberEditor getGearShootingEndLongitudeDMSMinuteField() {
        return gearShootingEndLongitudeDMSMinuteField;
    }

    public NumberEditor getGearShootingEndLongitudeDMSSecondField() {
        return gearShootingEndLongitudeDMSSecondField;
    }

    public CardLayout2Ext getGearShootingEndLongitudeLayout() {
        return gearShootingEndLongitudeLayout;
    }

    public JPanel getGearShootingEndLongitudePanel() {
        return gearShootingEndLongitudePanel;
    }

    public SimpleTimeEditor getGearShootingEndTimeField() {
        return gearShootingEndTimeField;
    }

    public JXDatePicker getGearShootingStartDateField() {
        return gearShootingStartDateField;
    }

    public JLabel getGearShootingStartLabel() {
        return gearShootingStartLabel;
    }

    public NumberEditor getGearShootingStartLatitudeDDField() {
        return gearShootingStartLatitudeDDField;
    }

    public NumberEditor getGearShootingStartLatitudeDMDDegreeField() {
        return gearShootingStartLatitudeDMDDegreeField;
    }

    public NumberEditor getGearShootingStartLatitudeDMDMinuteField() {
        return gearShootingStartLatitudeDMDMinuteField;
    }

    public NumberEditor getGearShootingStartLatitudeDMSDegreeField() {
        return gearShootingStartLatitudeDMSDegreeField;
    }

    public NumberEditor getGearShootingStartLatitudeDMSMinuteField() {
        return gearShootingStartLatitudeDMSMinuteField;
    }

    public NumberEditor getGearShootingStartLatitudeDMSSecondField() {
        return gearShootingStartLatitudeDMSSecondField;
    }

    public CardLayout2Ext getGearShootingStartLatitudeLayout() {
        return gearShootingStartLatitudeLayout;
    }

    public JPanel getGearShootingStartLatitudePanel() {
        return gearShootingStartLatitudePanel;
    }

    public NumberEditor getGearShootingStartLongitudeDDField() {
        return gearShootingStartLongitudeDDField;
    }

    public NumberEditor getGearShootingStartLongitudeDMDDegreeField() {
        return gearShootingStartLongitudeDMDDegreeField;
    }

    public NumberEditor getGearShootingStartLongitudeDMDMinuteField() {
        return gearShootingStartLongitudeDMDMinuteField;
    }

    public NumberEditor getGearShootingStartLongitudeDMSDegreeField() {
        return gearShootingStartLongitudeDMSDegreeField;
    }

    public NumberEditor getGearShootingStartLongitudeDMSMinuteField() {
        return gearShootingStartLongitudeDMSMinuteField;
    }

    public NumberEditor getGearShootingStartLongitudeDMSSecondField() {
        return gearShootingStartLongitudeDMSSecondField;
    }

    public CardLayout2Ext getGearShootingStartLongitudeLayout() {
        return gearShootingStartLongitudeLayout;
    }

    public JPanel getGearShootingStartLongitudePanel() {
        return gearShootingStartLongitudePanel;
    }

    public SimpleTimeEditor getGearShootingStartTimeField() {
        return gearShootingStartTimeField;
    }

    public JLabel getGearTimeLabel() {
        return gearTimeLabel;
    }

    public TabInfo getGearUseFeatureTab() {
        return gearUseFeatureTab;
    }

    public GearUseFeatureTabUI getGearUseFeatureTabContent() {
        return gearUseFeatureTabContent;
    }

    public JXTitledPanel getGearUseFeatureTabPane() {
        return gearUseFeatureTabPane;
    }

    public Table getGeneralForm() {
        return generalForm;
    }

    public EditFishingOperationUIHandler getHandler() {
        return handler;
    }

    public JButton getImportCasinoButton() {
        return importCasinoButton;
    }

    public BeanFilterableComboBox<FishingOperationLocation> getLocationComboBox() {
        return locationComboBox;
    }

    public JLabel getLocationLabel() {
        return locationLabel;
    }

    public EditFishingOperationUIModel getModel() {
        return model;
    }

    public JTextField getMultirigAggregationField() {
        return multirigAggregationField;
    }

    public JLabel getMultirigAggregationLabel() {
        return multirigAggregationLabel;
    }

    public BeanDoubleList<Person> getRecorderPersonList() {
        return recorderPersonList;
    }

    public JButton getResetValidStateButton() {
        return resetValidStateButton;
    }

    public JButton getSaveButton() {
        return saveButton;
    }

    public JTextField getStationNumberField() {
        return stationNumberField;
    }

    public JLabel getStationNumberLabel() {
        return stationNumberLabel;
    }

    public BeanFilterableComboBox<FishingOperationLocation> getStrataComboBox() {
        return strataComboBox;
    }

    public JLabel getStrataLabel() {
        return strataLabel;
    }

    public BeanFilterableComboBox<FishingOperationLocation> getSubStrataComboBox() {
        return subStrataComboBox;
    }

    public JLabel getSubStrataLabel() {
        return subStrataLabel;
    }

    public TabInfo getTraitGeneralTab() {
        return traitGeneralTab;
    }

    public JXTitledPanel getTraitGeneralTabPane() {
        return traitGeneralTabPane;
    }

    public JToolBar getTraitGeneralTabPaneToolBar() {
        return traitGeneralTabPaneToolBar;
    }

    public Table getTraitVesselPanel() {
        return traitVesselPanel;
    }

    public NumberEditor getTrawlDistanceField() {
        return trawlDistanceField;
    }

    public JLabel getTrawlDistanceLabel() {
        return trawlDistanceLabel;
    }

    public SwingValidator<EditFishingOperationUIModel> getValidator() {
        return validator;
    }

    public BeanFilterableComboBox<Vessel> getVesselComboBox() {
        return vesselComboBox;
    }

    public JLabel getVesselLabel() {
        return vesselLabel;
    }

    public TabInfo getVesselUseFeatureTab() {
        return vesselUseFeatureTab;
    }

    public VesselUseFeatureTabUI getVesselUseFeatureTabContent() {
        return vesselUseFeatureTabContent;
    }

    public JXTitledPanel getVesselUseFeatureTabPane() {
        return vesselUseFeatureTabPane;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected HBox get$HBox0() {
        return $HBox0;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JPanel get$JPanel10() {
        return $JPanel10;
    }

    protected JPanel get$JPanel11() {
        return $JPanel11;
    }

    protected JPanel get$JPanel12() {
        return $JPanel12;
    }

    protected JPanel get$JPanel13() {
        return $JPanel13;
    }

    protected JPanel get$JPanel14() {
        return $JPanel14;
    }

    protected JPanel get$JPanel2() {
        return $JPanel2;
    }

    protected JPanel get$JPanel3() {
        return $JPanel3;
    }

    protected JPanel get$JPanel4() {
        return $JPanel4;
    }

    protected JPanel get$JPanel5() {
        return $JPanel5;
    }

    protected JPanel get$JPanel6() {
        return $JPanel6;
    }

    protected JPanel get$JPanel7() {
        return $JPanel7;
    }

    protected JPanel get$JPanel8() {
        return $JPanel8;
    }

    protected JPanel get$JPanel9() {
        return $JPanel9;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToCommentPane() {
        if (!allComponentsCreated) {
            return;
        }
        commentPane.getViewport().add(commentField);
    }

    protected void addChildrenToCreateFishingOperationActions() {
        if (!allComponentsCreated) {
            return;
        }
        createFishingOperationActions.add(cancelButton);
        createFishingOperationActions.add(saveButton);
    }

    protected void addChildrenToEditFishingOperationTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(traitGeneralTabPaneToolBar);
        add(fishingOperationPane, BorderLayout.CENTER);
    }

    protected void addChildrenToFishingOperationInvalidRadio() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = fishingOperationValid; fishingOperationInvalidRadio.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(fishingOperationInvalidRadio); }
    }

    protected void addChildrenToFishingOperationPane() {
        if (!allComponentsCreated) {
            return;
        }
        fishingOperationPane.add(fishingOperationTabPane, BorderLayout.CENTER);
        fishingOperationPane.add($JPanel14, BorderLayout.SOUTH);
    }

    protected void addChildrenToFishingOperationResetRadio() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = fishingOperationValid; fishingOperationResetRadio.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(fishingOperationResetRadio); }
    }

    protected void addChildrenToFishingOperationTabPane() {
        if (!allComponentsCreated) {
            return;
        }
        fishingOperationTabPane.add(traitGeneralTabPane);
        fishingOperationTabPane.add(gearUseFeatureTabPane);
        fishingOperationTabPane.add(vesselUseFeatureTabPane);
        traitGeneralTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(fishingOperationTabPane, 0));
        gearUseFeatureTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(fishingOperationTabPane, 1));
        vesselUseFeatureTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(fishingOperationTabPane, 2));
    }

    protected void addChildrenToFishingOperationValidPanel() {
        if (!allComponentsCreated) {
            return;
        }
        fishingOperationValidPanel.add(resetValidStateButton, BorderLayout.WEST);
        fishingOperationValidPanel.add(fishingOperationResetRadio, BorderLayout.EAST);
    }

    protected void addChildrenToFishingOperationValidRadio() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = fishingOperationValid; fishingOperationValidRadio.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(fishingOperationValidRadio); }
    }

    protected void addChildrenToGearCaracteristicsTable() {
        if (!allComponentsCreated) {
            return;
        }
        gearCaracteristicsTable.add($JPanel1, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearLatitudeLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearLongitudeLabel, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearDateLabel, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearTimeLabel, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingStartLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingStartLatitudePanel, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingStartLongitudePanel, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(SwingUtil.boxComponentWithJxLayer(gearShootingStartDateField), new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingStartTimeField, new GridBagConstraints(4, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingEndLabel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingEndLatitudePanel, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingEndLongitudePanel, new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(SwingUtil.boxComponentWithJxLayer(gearShootingEndDateField), new GridBagConstraints(3, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingEndTimeField, new GridBagConstraints(4, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add($JLabel0, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(fishingOperationRectiligneCheckBox, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add($JPanel10, new GridBagConstraints(2, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add($JLabel1, new GridBagConstraints(3, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add($JPanel11, new GridBagConstraints(4, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(SwingUtil.boxComponentWithJxLayer(fishingOperationValidPanel), new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add($HBox0, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add($JPanel12, new GridBagConstraints(2, 4, 4, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToGearShootingEndLatitudePanel() {
        if (!allComponentsCreated) {
            return;
        }
        gearShootingEndLatitudePanel.add(SwingUtil.boxComponentWithJxLayer(gearShootingEndLatitudeDDField), "DD");
        gearShootingEndLatitudePanel.add($JPanel6, "DMS");
        gearShootingEndLatitudePanel.add($JPanel7, "DMD");
    }

    protected void addChildrenToGearShootingEndLongitudePanel() {
        if (!allComponentsCreated) {
            return;
        }
        gearShootingEndLongitudePanel.add(SwingUtil.boxComponentWithJxLayer(gearShootingEndLongitudeDDField), "DD");
        gearShootingEndLongitudePanel.add($JPanel8, "DMS");
        gearShootingEndLongitudePanel.add($JPanel9, "DMD");
    }

    protected void addChildrenToGearShootingStartLatitudePanel() {
        if (!allComponentsCreated) {
            return;
        }
        gearShootingStartLatitudePanel.add(SwingUtil.boxComponentWithJxLayer(gearShootingStartLatitudeDDField), "DD");
        gearShootingStartLatitudePanel.add($JPanel2, "DMS");
        gearShootingStartLatitudePanel.add($JPanel3, "DMD");
    }

    protected void addChildrenToGearShootingStartLongitudePanel() {
        if (!allComponentsCreated) {
            return;
        }
        gearShootingStartLongitudePanel.add(SwingUtil.boxComponentWithJxLayer(gearShootingStartLongitudeDDField), "DD");
        gearShootingStartLongitudePanel.add($JPanel4, "DMS");
        gearShootingStartLongitudePanel.add($JPanel5, "DMD");
    }

    protected void addChildrenToGearUseFeatureTabPane() {
        if (!allComponentsCreated) {
            return;
        }
        gearUseFeatureTabPane.add(gearUseFeatureTabContent);
    }

    protected void addChildrenToGeneralForm() {
        if (!allComponentsCreated) {
            return;
        }
        generalForm.add(stationNumberLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(SwingUtil.boxComponentWithJxLayer(stationNumberField), new GridBagConstraints(1, 0, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(fishingOperationNumberLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(SwingUtil.boxComponentWithJxLayer(fishingOperationNumberField), new GridBagConstraints(3, 0, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(multirigAggregationLabel, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(SwingUtil.boxComponentWithJxLayer(multirigAggregationField), new GridBagConstraints(5, 0, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(strataLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(SwingUtil.boxComponentWithJxLayer(strataComboBox), new GridBagConstraints(1, 1, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(subStrataLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(SwingUtil.boxComponentWithJxLayer(subStrataComboBox), new GridBagConstraints(3, 1, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(locationLabel, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(SwingUtil.boxComponentWithJxLayer(locationComboBox), new GridBagConstraints(5, 1, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add($JPanel0, new GridBagConstraints(0, 2, 6, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add($JPanel13, new GridBagConstraints(0, 3, 6, 1, 0.0, 0.2, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(SwingUtil.boxComponentWithJxLayer(commentPane), new GridBagConstraints(0, 4, 6, 1, 0.0, 0.8, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToTraitGeneralTabPane() {
        if (!allComponentsCreated) {
            return;
        }
        traitGeneralTabPane.add(generalForm);
    }

    protected void addChildrenToTraitGeneralTabPaneToolBar() {
        if (!allComponentsCreated) {
            return;
        }
        traitGeneralTabPaneToolBar.add(importCasinoButton);
        traitGeneralTabPaneToolBar.add(fishingOperationAttachmentsButton);
    }

    protected void addChildrenToTraitVesselPanel() {
        if (!allComponentsCreated) {
            return;
        }
        traitVesselPanel.add(vesselLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        traitVesselPanel.add(SwingUtil.boxComponentWithJxLayer(vesselComboBox), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        traitVesselPanel.add(gearLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        traitVesselPanel.add(SwingUtil.boxComponentWithJxLayer(gearComboBox), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void addChildrenToVesselUseFeatureTabPane() {
        if (!allComponentsCreated) {
            return;
        }
        vesselUseFeatureTabPane.add(vesselUseFeatureTabContent);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tuttihelp.editeditFishingOperation.help"));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(_("tutti.editFishingOperation.action.cancelEditFishingOperation"));
        cancelButton.setToolTipText(_("tutti.editFishingOperation.action.cancelEditFishingOperation.tip"));
        cancelButton.putClientProperty("help", "tutti.editFishingOperation.action.cancelEditFishingOperation.help");
        cancelButton.putClientProperty("tuttiAction", CancelEditFishingOperationAction.class);
    }

    protected void createCommentField() {
        $objectMap.put("commentField", commentField = new JTextArea());
        
        commentField.setName("commentField");
        commentField.setColumns(15);
        commentField.setLineWrap(true);
        commentField.setWrapStyleWord(true);
        commentField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__commentField"));
        commentField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.comment"));
    }

    protected void createCommentPane() {
        $objectMap.put("commentPane", commentPane = new JScrollPane());
        
        commentPane.setName("commentPane");
        commentPane.setToolTipText(_("tutti.editFishingOperation.field.comment.tip"));
        commentPane.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__commentPane"));
        commentPane.putClientProperty("help", "tutti.editFishingOperation.field.comment.help");
    }

    protected void createCreateFishingOperationActions() {
        $objectMap.put("createFishingOperationActions", createFishingOperationActions = new JPanel());
        
        createFishingOperationActions.setName("createFishingOperationActions");
        createFishingOperationActions.setLayout(new GridLayout(1,0));
    }

    protected void createDurationField() {
        $objectMap.put("durationField", durationField = new JTextField());
        
        durationField.setName("durationField");
        durationField.setColumns(15);
        durationField.setEnabled(false);
        durationField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.duration"));
    }

    protected void createDurationLabel() {
        $objectMap.put("durationLabel", durationLabel = new JLabel());
        
        durationLabel.setName("durationLabel");
        durationLabel.setText(_("tutti.editFishingOperation.field.duration"));
        durationLabel.setToolTipText(_("tutti.editFishingOperation.field.duration.tip"));
        durationLabel.putClientProperty("help", "tutti.editFishingOperation.field.duration.help");
    }

    protected void createFishingOperationAttachmentsButton() {
        $objectMap.put("fishingOperationAttachmentsButton", fishingOperationAttachmentsButton = new ButtonAttachment(getHandler().getContext(), getModel()));
        
        fishingOperationAttachmentsButton.setName("fishingOperationAttachmentsButton");
        fishingOperationAttachmentsButton.setToolTipText(_("tutti.editFishingOperation.action.attachments.tip"));
        fishingOperationAttachmentsButton.putClientProperty("help", "tutti.editFishingOperation.action.attachments.help");
    }

    protected void createFishingOperationInvalidRadio() {
        $objectMap.put("fishingOperationInvalidRadio", fishingOperationInvalidRadio = new JRadioButton());
        
        fishingOperationInvalidRadio.setName("fishingOperationInvalidRadio");
        fishingOperationInvalidRadio.setText(_("tutti.editFishingOperation.field.fishingOperationInvalid"));
        fishingOperationInvalidRadio.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fishingOperationInvalidRadio"));
    }

    protected void createFishingOperationNumberField() {
        $objectMap.put("fishingOperationNumberField", fishingOperationNumberField = new NumberEditor(this));
        
        fishingOperationNumberField.setName("fishingOperationNumberField");
        fishingOperationNumberField.setProperty("fishingOperationNumber");
        fishingOperationNumberField.setUseFloat(false);
        fishingOperationNumberField.setShowReset(true);
        fishingOperationNumberField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.fishingOperationNumber"));
    }

    protected void createFishingOperationNumberLabel() {
        $objectMap.put("fishingOperationNumberLabel", fishingOperationNumberLabel = new JLabel());
        
        fishingOperationNumberLabel.setName("fishingOperationNumberLabel");
        fishingOperationNumberLabel.setText(_("tutti.editFishingOperation.field.fishingOperationNumber"));
        fishingOperationNumberLabel.setToolTipText(_("tutti.editFishingOperation.field.fishingOperationNumber.tip"));
        fishingOperationNumberLabel.putClientProperty("help", "tutti.editFishingOperation.field.fishingOperationNumber.help");
    }

    protected void createFishingOperationPane() {
        $objectMap.put("fishingOperationPane", fishingOperationPane = new JPanel());
        
        fishingOperationPane.setName("fishingOperationPane");
        fishingOperationPane.setLayout(new BorderLayout());
    }

    protected void createFishingOperationRectiligneCheckBox() {
        $objectMap.put("fishingOperationRectiligneCheckBox", fishingOperationRectiligneCheckBox = new JCheckBox());
        
        fishingOperationRectiligneCheckBox.setName("fishingOperationRectiligneCheckBox");
        fishingOperationRectiligneCheckBox.setText(_("tutti.editFishingOperation.field.fishingOperationRectiligne"));
        fishingOperationRectiligneCheckBox.setToolTipText(_("tutti.editFishingOperation.field.fishingOperationRectiligne.tip"));
        fishingOperationRectiligneCheckBox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__fishingOperationRectiligneCheckBox"));
        fishingOperationRectiligneCheckBox.putClientProperty("help", "tutti.editFishingOperation.field.fishingOperationRectiligne.help");
    }

    protected void createFishingOperationResetRadio() {
        $objectMap.put("fishingOperationResetRadio", fishingOperationResetRadio = new JRadioButton());
        
        fishingOperationResetRadio.setName("fishingOperationResetRadio");
    }

    protected void createFishingOperationTabPane() {
        $objectMap.put("fishingOperationTabPane", fishingOperationTabPane = new JTabbedPane());
        
        fishingOperationTabPane.setName("fishingOperationTabPane");
    }

    protected void createFishingOperationValid() {
        $objectMap.put("fishingOperationValid", fishingOperationValid = new JAXXButtonGroup());
    }

    protected void createFishingOperationValidPanel() {
        $objectMap.put("fishingOperationValidPanel", fishingOperationValidPanel = new JToolBar());
        
        fishingOperationValidPanel.setName("fishingOperationValidPanel");
        fishingOperationValidPanel.setLayout(new BorderLayout());
        fishingOperationValidPanel.setFloatable(false);
        fishingOperationValidPanel.setOpaque(false);
        fishingOperationValidPanel.setToolTipText(_("tutti.editFishingOperation.field.fishingOperationValid.tip"));
        fishingOperationValidPanel.setBorderPainted(false);
        fishingOperationValidPanel.putClientProperty("help", "tutti.editFishingOperation.field.fishingOperationValid.help");
        fishingOperationValidPanel.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.fishingOperationValidity"));
    }

    protected void createFishingOperationValidRadio() {
        $objectMap.put("fishingOperationValidRadio", fishingOperationValidRadio = new JRadioButton());
        
        fishingOperationValidRadio.setName("fishingOperationValidRadio");
        fishingOperationValidRadio.setText(_("tutti.editFishingOperation.field.fishingOperationValid"));
        fishingOperationValidRadio.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fishingOperationValidRadio"));
    }

    protected void createGearCaracteristicsTable() {
        $objectMap.put("gearCaracteristicsTable", gearCaracteristicsTable = new Table());
        
        gearCaracteristicsTable.setName("gearCaracteristicsTable");
    }

    protected void createGearComboBox() {
        $objectMap.put("gearComboBox", gearComboBox = new BeanFilterableComboBox<Gear>(this));
        
        gearComboBox.setName("gearComboBox");
        gearComboBox.setI18nPrefix("tutti.property.");
        gearComboBox.setProperty("gear");
        gearComboBox.setShowReset(true);
        gearComboBox.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.gear"));
    }

    protected void createGearDateLabel() {
        $objectMap.put("gearDateLabel", gearDateLabel = new JLabel());
        
        gearDateLabel.setName("gearDateLabel");
        gearDateLabel.setText(_("tutti.editFishingOperation.field.gearDate"));
        gearDateLabel.setToolTipText(_("tutti.editFishingOperation.field.gearDate.tip"));
        gearDateLabel.putClientProperty("help", "tutti.editFishingOperation.field.gearDate.help");
    }

    protected void createGearLabel() {
        $objectMap.put("gearLabel", gearLabel = new JLabel());
        
        gearLabel.setName("gearLabel");
        gearLabel.setText(_("tutti.editFishingOperation.field.gear"));
        gearLabel.setToolTipText(_("tutti.editFishingOperation.field.gear.tip"));
        gearLabel.putClientProperty("help", "tutti.editFishingOperation.field.gear.help");
    }

    protected void createGearLatitudeLabel() {
        $objectMap.put("gearLatitudeLabel", gearLatitudeLabel = new JLabel());
        
        gearLatitudeLabel.setName("gearLatitudeLabel");
        gearLatitudeLabel.setToolTipText(_("tutti.editFishingOperation.field.gearLatitude.tip"));
        gearLatitudeLabel.putClientProperty("help", "tutti.editFishingOperation.field.gearLatitude.help");
    }

    protected void createGearLongitudeLabel() {
        $objectMap.put("gearLongitudeLabel", gearLongitudeLabel = new JLabel());
        
        gearLongitudeLabel.setName("gearLongitudeLabel");
        gearLongitudeLabel.setToolTipText(_("tutti.editFishingOperation.field.gearLongitude.tip"));
        gearLongitudeLabel.putClientProperty("help", "tutti.editFishingOperation.field.gearLongitude.help");
    }

    protected void createGearShootingEndDateField() {
        $objectMap.put("gearShootingEndDateField", gearShootingEndDateField = new JXDatePicker());
        
        gearShootingEndDateField.setName("gearShootingEndDateField");
        gearShootingEndDateField.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__gearShootingEndDateField"));
        gearShootingEndDateField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.gearShootingEndDate"));
    }

    protected void createGearShootingEndLabel() {
        $objectMap.put("gearShootingEndLabel", gearShootingEndLabel = new JLabel());
        
        gearShootingEndLabel.setName("gearShootingEndLabel");
        gearShootingEndLabel.setText(_("tutti.editFishingOperation.field.gearShootingEnd"));
        gearShootingEndLabel.setToolTipText(_("tutti.editFishingOperation.field.gearShootingEnd.tip"));
        gearShootingEndLabel.putClientProperty("help", "tutti.editFishingOperation.field.gearShootingEnd.help");
    }

    protected void createGearShootingEndLatitudeDDField() {
        $objectMap.put("gearShootingEndLatitudeDDField", gearShootingEndLatitudeDDField = new NumberEditor(this));
        
        gearShootingEndLatitudeDDField.setName("gearShootingEndLatitudeDDField");
        gearShootingEndLatitudeDDField.setUseSign(true);
        gearShootingEndLatitudeDDField.setProperty("gearShootingEndLatitude");
        gearShootingEndLatitudeDDField.setUseFloat(true);
        gearShootingEndLatitudeDDField.setShowReset(false);
        gearShootingEndLatitudeDDField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.gearShootingEndLatitude"));
    }

    protected void createGearShootingEndLatitudeDMDDegreeField() {
        $objectMap.put("gearShootingEndLatitudeDMDDegreeField", gearShootingEndLatitudeDMDDegreeField = new NumberEditor(this));
        
        gearShootingEndLatitudeDMDDegreeField.setName("gearShootingEndLatitudeDMDDegreeField");
        gearShootingEndLatitudeDMDDegreeField.setUseSign(true);
        gearShootingEndLatitudeDMDDegreeField.setProperty("gearShootingEndLatitudeDegree");
        gearShootingEndLatitudeDMDDegreeField.setUseFloat(false);
        gearShootingEndLatitudeDMDDegreeField.setShowReset(false);
        gearShootingEndLatitudeDMDDegreeField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.gearShootingEndLatitudeDegree"));
    }

    protected void createGearShootingEndLatitudeDMDMinuteField() {
        $objectMap.put("gearShootingEndLatitudeDMDMinuteField", gearShootingEndLatitudeDMDMinuteField = new NumberEditor(this));
        
        gearShootingEndLatitudeDMDMinuteField.setName("gearShootingEndLatitudeDMDMinuteField");
        gearShootingEndLatitudeDMDMinuteField.setUseSign(false);
        gearShootingEndLatitudeDMDMinuteField.setProperty("gearShootingEndLatitudeDecimalMinute");
        gearShootingEndLatitudeDMDMinuteField.setUseFloat(true);
        gearShootingEndLatitudeDMDMinuteField.setShowReset(false);
        gearShootingEndLatitudeDMDMinuteField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.gearShootingEndLatitudeMinute"));
    }

    protected void createGearShootingEndLatitudeDMSDegreeField() {
        $objectMap.put("gearShootingEndLatitudeDMSDegreeField", gearShootingEndLatitudeDMSDegreeField = new NumberEditor(this));
        
        gearShootingEndLatitudeDMSDegreeField.setName("gearShootingEndLatitudeDMSDegreeField");
        gearShootingEndLatitudeDMSDegreeField.setUseSign(true);
        gearShootingEndLatitudeDMSDegreeField.setProperty("gearShootingEndLatitudeDegree");
        gearShootingEndLatitudeDMSDegreeField.setUseFloat(false);
        gearShootingEndLatitudeDMSDegreeField.setShowReset(false);
        gearShootingEndLatitudeDMSDegreeField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.gearShootingEndLatitudeDegree"));
    }

    protected void createGearShootingEndLatitudeDMSMinuteField() {
        $objectMap.put("gearShootingEndLatitudeDMSMinuteField", gearShootingEndLatitudeDMSMinuteField = new NumberEditor(this));
        
        gearShootingEndLatitudeDMSMinuteField.setName("gearShootingEndLatitudeDMSMinuteField");
        gearShootingEndLatitudeDMSMinuteField.setUseSign(false);
        gearShootingEndLatitudeDMSMinuteField.setProperty("gearShootingEndLatitudeMinute");
        gearShootingEndLatitudeDMSMinuteField.setUseFloat(false);
        gearShootingEndLatitudeDMSMinuteField.setShowReset(false);
        gearShootingEndLatitudeDMSMinuteField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.gearShootingEndLatitudeMinute"));
    }

    protected void createGearShootingEndLatitudeDMSSecondField() {
        $objectMap.put("gearShootingEndLatitudeDMSSecondField", gearShootingEndLatitudeDMSSecondField = new NumberEditor(this));
        
        gearShootingEndLatitudeDMSSecondField.setName("gearShootingEndLatitudeDMSSecondField");
        gearShootingEndLatitudeDMSSecondField.setUseSign(false);
        gearShootingEndLatitudeDMSSecondField.setProperty("gearShootingEndLatitudeSecond");
        gearShootingEndLatitudeDMSSecondField.setUseFloat(false);
        gearShootingEndLatitudeDMSSecondField.setShowReset(false);
        gearShootingEndLatitudeDMSSecondField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.gearShootingEndLatitudeSecond"));
    }

    protected void createGearShootingEndLatitudeLayout() {
        $objectMap.put("gearShootingEndLatitudeLayout", gearShootingEndLatitudeLayout = new CardLayout2Ext(this, "gearShootingEndLatitudePanel"));
    }

    protected void createGearShootingEndLatitudePanel() {
        $objectMap.put("gearShootingEndLatitudePanel", gearShootingEndLatitudePanel = new JPanel());
        
        gearShootingEndLatitudePanel.setName("gearShootingEndLatitudePanel");
        gearShootingEndLatitudePanel.setLayout(gearShootingEndLatitudeLayout);
        gearShootingEndLatitudePanel.setToolTipText(_("tutti.editFishingOperation.field.gearShootingEndLatitude.tip"));
        gearShootingEndLatitudePanel.putClientProperty("help", "tutti.editFishingOperation.field.gearShootingEndLatitude.help");
    }

    protected void createGearShootingEndLongitudeDDField() {
        $objectMap.put("gearShootingEndLongitudeDDField", gearShootingEndLongitudeDDField = new NumberEditor(this));
        
        gearShootingEndLongitudeDDField.setName("gearShootingEndLongitudeDDField");
        gearShootingEndLongitudeDDField.setUseSign(true);
        gearShootingEndLongitudeDDField.setProperty("gearShootingEndLongitude");
        gearShootingEndLongitudeDDField.setUseFloat(true);
        gearShootingEndLongitudeDDField.setShowReset(false);
        gearShootingEndLongitudeDDField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.gearShootingEndLongitude"));
    }

    protected void createGearShootingEndLongitudeDMDDegreeField() {
        $objectMap.put("gearShootingEndLongitudeDMDDegreeField", gearShootingEndLongitudeDMDDegreeField = new NumberEditor(this));
        
        gearShootingEndLongitudeDMDDegreeField.setName("gearShootingEndLongitudeDMDDegreeField");
        gearShootingEndLongitudeDMDDegreeField.setUseSign(true);
        gearShootingEndLongitudeDMDDegreeField.setProperty("gearShootingEndLongitudeDegree");
        gearShootingEndLongitudeDMDDegreeField.setUseFloat(false);
        gearShootingEndLongitudeDMDDegreeField.setShowReset(false);
        gearShootingEndLongitudeDMDDegreeField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.gearShootingEndLongitudeDegree"));
    }

    protected void createGearShootingEndLongitudeDMDMinuteField() {
        $objectMap.put("gearShootingEndLongitudeDMDMinuteField", gearShootingEndLongitudeDMDMinuteField = new NumberEditor(this));
        
        gearShootingEndLongitudeDMDMinuteField.setName("gearShootingEndLongitudeDMDMinuteField");
        gearShootingEndLongitudeDMDMinuteField.setUseSign(false);
        gearShootingEndLongitudeDMDMinuteField.setProperty("gearShootingEndLongitudeDecimalMinute");
        gearShootingEndLongitudeDMDMinuteField.setUseFloat(true);
        gearShootingEndLongitudeDMDMinuteField.setShowReset(false);
        gearShootingEndLongitudeDMDMinuteField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.gearShootingEndLongitudeMinute"));
    }

    protected void createGearShootingEndLongitudeDMSDegreeField() {
        $objectMap.put("gearShootingEndLongitudeDMSDegreeField", gearShootingEndLongitudeDMSDegreeField = new NumberEditor(this));
        
        gearShootingEndLongitudeDMSDegreeField.setName("gearShootingEndLongitudeDMSDegreeField");
        gearShootingEndLongitudeDMSDegreeField.setUseSign(true);
        gearShootingEndLongitudeDMSDegreeField.setProperty("gearShootingEndLongitudeDegree");
        gearShootingEndLongitudeDMSDegreeField.setUseFloat(false);
        gearShootingEndLongitudeDMSDegreeField.setShowReset(false);
        gearShootingEndLongitudeDMSDegreeField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.gearShootingEndLongitudeDegree"));
    }

    protected void createGearShootingEndLongitudeDMSMinuteField() {
        $objectMap.put("gearShootingEndLongitudeDMSMinuteField", gearShootingEndLongitudeDMSMinuteField = new NumberEditor(this));
        
        gearShootingEndLongitudeDMSMinuteField.setName("gearShootingEndLongitudeDMSMinuteField");
        gearShootingEndLongitudeDMSMinuteField.setUseSign(false);
        gearShootingEndLongitudeDMSMinuteField.setProperty("gearShootingEndLongitudeMinute");
        gearShootingEndLongitudeDMSMinuteField.setUseFloat(false);
        gearShootingEndLongitudeDMSMinuteField.setShowReset(false);
        gearShootingEndLongitudeDMSMinuteField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.gearShootingEndLongitudeMinute"));
    }

    protected void createGearShootingEndLongitudeDMSSecondField() {
        $objectMap.put("gearShootingEndLongitudeDMSSecondField", gearShootingEndLongitudeDMSSecondField = new NumberEditor(this));
        
        gearShootingEndLongitudeDMSSecondField.setName("gearShootingEndLongitudeDMSSecondField");
        gearShootingEndLongitudeDMSSecondField.setUseSign(false);
        gearShootingEndLongitudeDMSSecondField.setProperty("gearShootingEndLongitudeSecond");
        gearShootingEndLongitudeDMSSecondField.setUseFloat(false);
        gearShootingEndLongitudeDMSSecondField.setShowReset(false);
        gearShootingEndLongitudeDMSSecondField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.gearShootingEndLongitudeSecond"));
    }

    protected void createGearShootingEndLongitudeLayout() {
        $objectMap.put("gearShootingEndLongitudeLayout", gearShootingEndLongitudeLayout = new CardLayout2Ext(this, "gearShootingEndLongitudePanel"));
    }

    protected void createGearShootingEndLongitudePanel() {
        $objectMap.put("gearShootingEndLongitudePanel", gearShootingEndLongitudePanel = new JPanel());
        
        gearShootingEndLongitudePanel.setName("gearShootingEndLongitudePanel");
        gearShootingEndLongitudePanel.setLayout(gearShootingEndLongitudeLayout);
        gearShootingEndLongitudePanel.setToolTipText(_("tutti.editFishingOperation.field.gearShootingEndLongitude.tip"));
        gearShootingEndLongitudePanel.putClientProperty("help", "tutti.editFishingOperation.field.gearShootingEndLongitude.help");
    }

    protected void createGearShootingEndTimeField() {
        $objectMap.put("gearShootingEndTimeField", gearShootingEndTimeField = new SimpleTimeEditor(this));
        
        gearShootingEndTimeField.setName("gearShootingEndTimeField");
        gearShootingEndTimeField.setProperty("gearShootingEndTime");
    }

    protected void createGearShootingStartDateField() {
        $objectMap.put("gearShootingStartDateField", gearShootingStartDateField = new JXDatePicker());
        
        gearShootingStartDateField.setName("gearShootingStartDateField");
        gearShootingStartDateField.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__gearShootingStartDateField"));
        gearShootingStartDateField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.gearShootingStartDate"));
    }

    protected void createGearShootingStartLabel() {
        $objectMap.put("gearShootingStartLabel", gearShootingStartLabel = new JLabel());
        
        gearShootingStartLabel.setName("gearShootingStartLabel");
        gearShootingStartLabel.setText(_("tutti.editFishingOperation.field.gearShootingStart"));
        gearShootingStartLabel.setToolTipText(_("tutti.editFishingOperation.field.gearShootingStart.tip"));
        gearShootingStartLabel.putClientProperty("help", "tutti.editFishingOperation.field.gearShootingStart.help");
    }

    protected void createGearShootingStartLatitudeDDField() {
        $objectMap.put("gearShootingStartLatitudeDDField", gearShootingStartLatitudeDDField = new NumberEditor(this));
        
        gearShootingStartLatitudeDDField.setName("gearShootingStartLatitudeDDField");
        gearShootingStartLatitudeDDField.setUseSign(true);
        gearShootingStartLatitudeDDField.setProperty("gearShootingStartLatitude");
        gearShootingStartLatitudeDDField.setUseFloat(true);
        gearShootingStartLatitudeDDField.setShowReset(false);
        gearShootingStartLatitudeDDField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.gearShootingStartLatitude"));
    }

    protected void createGearShootingStartLatitudeDMDDegreeField() {
        $objectMap.put("gearShootingStartLatitudeDMDDegreeField", gearShootingStartLatitudeDMDDegreeField = new NumberEditor(this));
        
        gearShootingStartLatitudeDMDDegreeField.setName("gearShootingStartLatitudeDMDDegreeField");
        gearShootingStartLatitudeDMDDegreeField.setUseSign(true);
        gearShootingStartLatitudeDMDDegreeField.setProperty("gearShootingStartLatitudeDegree");
        gearShootingStartLatitudeDMDDegreeField.setUseFloat(false);
        gearShootingStartLatitudeDMDDegreeField.setShowReset(false);
        gearShootingStartLatitudeDMDDegreeField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.gearShootingStartLatitudeDegree"));
    }

    protected void createGearShootingStartLatitudeDMDMinuteField() {
        $objectMap.put("gearShootingStartLatitudeDMDMinuteField", gearShootingStartLatitudeDMDMinuteField = new NumberEditor(this));
        
        gearShootingStartLatitudeDMDMinuteField.setName("gearShootingStartLatitudeDMDMinuteField");
        gearShootingStartLatitudeDMDMinuteField.setUseSign(false);
        gearShootingStartLatitudeDMDMinuteField.setProperty("gearShootingStartLatitudeDecimalMinute");
        gearShootingStartLatitudeDMDMinuteField.setUseFloat(true);
        gearShootingStartLatitudeDMDMinuteField.setShowReset(false);
        gearShootingStartLatitudeDMDMinuteField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.gearShootingStartLatitudeMinute"));
    }

    protected void createGearShootingStartLatitudeDMSDegreeField() {
        $objectMap.put("gearShootingStartLatitudeDMSDegreeField", gearShootingStartLatitudeDMSDegreeField = new NumberEditor(this));
        
        gearShootingStartLatitudeDMSDegreeField.setName("gearShootingStartLatitudeDMSDegreeField");
        gearShootingStartLatitudeDMSDegreeField.setUseSign(true);
        gearShootingStartLatitudeDMSDegreeField.setProperty("gearShootingStartLatitudeDegree");
        gearShootingStartLatitudeDMSDegreeField.setUseFloat(false);
        gearShootingStartLatitudeDMSDegreeField.setShowReset(false);
        gearShootingStartLatitudeDMSDegreeField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.gearShootingStartLatitudeDegree"));
    }

    protected void createGearShootingStartLatitudeDMSMinuteField() {
        $objectMap.put("gearShootingStartLatitudeDMSMinuteField", gearShootingStartLatitudeDMSMinuteField = new NumberEditor(this));
        
        gearShootingStartLatitudeDMSMinuteField.setName("gearShootingStartLatitudeDMSMinuteField");
        gearShootingStartLatitudeDMSMinuteField.setUseSign(false);
        gearShootingStartLatitudeDMSMinuteField.setProperty("gearShootingStartLatitudeMinute");
        gearShootingStartLatitudeDMSMinuteField.setUseFloat(false);
        gearShootingStartLatitudeDMSMinuteField.setShowReset(false);
        gearShootingStartLatitudeDMSMinuteField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.gearShootingStartLatitudeMinute"));
    }

    protected void createGearShootingStartLatitudeDMSSecondField() {
        $objectMap.put("gearShootingStartLatitudeDMSSecondField", gearShootingStartLatitudeDMSSecondField = new NumberEditor(this));
        
        gearShootingStartLatitudeDMSSecondField.setName("gearShootingStartLatitudeDMSSecondField");
        gearShootingStartLatitudeDMSSecondField.setUseSign(false);
        gearShootingStartLatitudeDMSSecondField.setProperty("gearShootingStartLatitudeSecond");
        gearShootingStartLatitudeDMSSecondField.setUseFloat(false);
        gearShootingStartLatitudeDMSSecondField.setShowReset(false);
        gearShootingStartLatitudeDMSSecondField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.gearShootingStartLatitudeSecond"));
    }

    protected void createGearShootingStartLatitudeLayout() {
        $objectMap.put("gearShootingStartLatitudeLayout", gearShootingStartLatitudeLayout = new CardLayout2Ext(this, "gearShootingStartLatitudePanel"));
    }

    protected void createGearShootingStartLatitudePanel() {
        $objectMap.put("gearShootingStartLatitudePanel", gearShootingStartLatitudePanel = new JPanel());
        
        gearShootingStartLatitudePanel.setName("gearShootingStartLatitudePanel");
        gearShootingStartLatitudePanel.setLayout(gearShootingStartLatitudeLayout);
        gearShootingStartLatitudePanel.setToolTipText(_("tutti.editFishingOperation.field.gearShootingStartLatitude.tip"));
        gearShootingStartLatitudePanel.putClientProperty("help", "tutti.editFishingOperation.field.gearShootingStartLatitude.help");
    }

    protected void createGearShootingStartLongitudeDDField() {
        $objectMap.put("gearShootingStartLongitudeDDField", gearShootingStartLongitudeDDField = new NumberEditor(this));
        
        gearShootingStartLongitudeDDField.setName("gearShootingStartLongitudeDDField");
        gearShootingStartLongitudeDDField.setUseSign(true);
        gearShootingStartLongitudeDDField.setProperty("gearShootingStartLongitude");
        gearShootingStartLongitudeDDField.setUseFloat(true);
        gearShootingStartLongitudeDDField.setShowReset(false);
        gearShootingStartLongitudeDDField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.gearShootingStartLongitude"));
    }

    protected void createGearShootingStartLongitudeDMDDegreeField() {
        $objectMap.put("gearShootingStartLongitudeDMDDegreeField", gearShootingStartLongitudeDMDDegreeField = new NumberEditor(this));
        
        gearShootingStartLongitudeDMDDegreeField.setName("gearShootingStartLongitudeDMDDegreeField");
        gearShootingStartLongitudeDMDDegreeField.setUseSign(true);
        gearShootingStartLongitudeDMDDegreeField.setProperty("gearShootingStartLongitudeDegree");
        gearShootingStartLongitudeDMDDegreeField.setUseFloat(false);
        gearShootingStartLongitudeDMDDegreeField.setShowReset(false);
        gearShootingStartLongitudeDMDDegreeField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.gearShootingStartLongitudeDegree"));
    }

    protected void createGearShootingStartLongitudeDMDMinuteField() {
        $objectMap.put("gearShootingStartLongitudeDMDMinuteField", gearShootingStartLongitudeDMDMinuteField = new NumberEditor(this));
        
        gearShootingStartLongitudeDMDMinuteField.setName("gearShootingStartLongitudeDMDMinuteField");
        gearShootingStartLongitudeDMDMinuteField.setUseSign(false);
        gearShootingStartLongitudeDMDMinuteField.setProperty("gearShootingStartLongitudeDecimalMinute");
        gearShootingStartLongitudeDMDMinuteField.setUseFloat(true);
        gearShootingStartLongitudeDMDMinuteField.setShowReset(false);
        gearShootingStartLongitudeDMDMinuteField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.gearShootingStartLongitudeMinute"));
    }

    protected void createGearShootingStartLongitudeDMSDegreeField() {
        $objectMap.put("gearShootingStartLongitudeDMSDegreeField", gearShootingStartLongitudeDMSDegreeField = new NumberEditor(this));
        
        gearShootingStartLongitudeDMSDegreeField.setName("gearShootingStartLongitudeDMSDegreeField");
        gearShootingStartLongitudeDMSDegreeField.setUseSign(true);
        gearShootingStartLongitudeDMSDegreeField.setProperty("gearShootingStartLongitudeDegree");
        gearShootingStartLongitudeDMSDegreeField.setUseFloat(false);
        gearShootingStartLongitudeDMSDegreeField.setShowReset(false);
        gearShootingStartLongitudeDMSDegreeField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.gearShootingStartLongitudeDegree"));
    }

    protected void createGearShootingStartLongitudeDMSMinuteField() {
        $objectMap.put("gearShootingStartLongitudeDMSMinuteField", gearShootingStartLongitudeDMSMinuteField = new NumberEditor(this));
        
        gearShootingStartLongitudeDMSMinuteField.setName("gearShootingStartLongitudeDMSMinuteField");
        gearShootingStartLongitudeDMSMinuteField.setUseSign(false);
        gearShootingStartLongitudeDMSMinuteField.setProperty("gearShootingStartLongitudeMinute");
        gearShootingStartLongitudeDMSMinuteField.setUseFloat(false);
        gearShootingStartLongitudeDMSMinuteField.setShowReset(false);
        gearShootingStartLongitudeDMSMinuteField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.gearShootingStartLongitudeMinute"));
    }

    protected void createGearShootingStartLongitudeDMSSecondField() {
        $objectMap.put("gearShootingStartLongitudeDMSSecondField", gearShootingStartLongitudeDMSSecondField = new NumberEditor(this));
        
        gearShootingStartLongitudeDMSSecondField.setName("gearShootingStartLongitudeDMSSecondField");
        gearShootingStartLongitudeDMSSecondField.setUseSign(false);
        gearShootingStartLongitudeDMSSecondField.setProperty("gearShootingStartLongitudeSecond");
        gearShootingStartLongitudeDMSSecondField.setUseFloat(false);
        gearShootingStartLongitudeDMSSecondField.setShowReset(false);
        gearShootingStartLongitudeDMSSecondField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.gearShootingStartLongitudeSecond"));
    }

    protected void createGearShootingStartLongitudeLayout() {
        $objectMap.put("gearShootingStartLongitudeLayout", gearShootingStartLongitudeLayout = new CardLayout2Ext(this, "gearShootingStartLongitudePanel"));
    }

    protected void createGearShootingStartLongitudePanel() {
        $objectMap.put("gearShootingStartLongitudePanel", gearShootingStartLongitudePanel = new JPanel());
        
        gearShootingStartLongitudePanel.setName("gearShootingStartLongitudePanel");
        gearShootingStartLongitudePanel.setLayout(gearShootingStartLongitudeLayout);
        gearShootingStartLongitudePanel.setToolTipText(_("tutti.editFishingOperation.field.gearShootingStartLongitude.tip"));
        gearShootingStartLongitudePanel.putClientProperty("help", "tutti.editFishingOperation.field.gearShootingStartLongitude.help");
    }

    protected void createGearShootingStartTimeField() {
        $objectMap.put("gearShootingStartTimeField", gearShootingStartTimeField = new SimpleTimeEditor(this));
        
        gearShootingStartTimeField.setName("gearShootingStartTimeField");
        gearShootingStartTimeField.setProperty("gearShootingStartTime");
    }

    protected void createGearTimeLabel() {
        $objectMap.put("gearTimeLabel", gearTimeLabel = new JLabel());
        
        gearTimeLabel.setName("gearTimeLabel");
        gearTimeLabel.setText(_("tutti.editFishingOperation.field.gearTime"));
        gearTimeLabel.setToolTipText(_("tutti.editFishingOperation.field.gearTime.tip"));
        gearTimeLabel.putClientProperty("help", "tutti.editFishingOperation.field.gearTime.help");
    }

    protected void createGearUseFeatureTab() {
        $objectMap.put("gearUseFeatureTab", gearUseFeatureTab = new TabInfo());
    }

    protected void createGearUseFeatureTabContent() {
        $objectMap.put("gearUseFeatureTabContent", gearUseFeatureTabContent = new GearUseFeatureTabUI(this));
        
        gearUseFeatureTabContent.setName("gearUseFeatureTabContent");
    }

    protected void createGearUseFeatureTabPane() {
        $objectMap.put("gearUseFeatureTabPane", gearUseFeatureTabPane = new JXTitledPanel());
        
        gearUseFeatureTabPane.setName("gearUseFeatureTabPane");
    }

    protected void createGeneralForm() {
        $objectMap.put("generalForm", generalForm = new Table());
        
        generalForm.setName("generalForm");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(EditFishingOperationUIHandler.class));
    }

    protected void createImportCasinoButton() {
        $objectMap.put("importCasinoButton", importCasinoButton = new JButton());
        
        importCasinoButton.setName("importCasinoButton");
        importCasinoButton.setText(_("tutti.editFishingOperation.action.importCasino"));
        importCasinoButton.setToolTipText(_("tutti.editFishingOperation.action.importCasino.tip"));
        importCasinoButton.putClientProperty("help", "tutti.editFishingOperation.action.importCasino.help");
        importCasinoButton.putClientProperty("tuttiAction", ImportCasinoAction.class);
    }

    protected void createLocationComboBox() {
        $objectMap.put("locationComboBox", locationComboBox = new BeanFilterableComboBox<FishingOperationLocation>(this));
        
        locationComboBox.setName("locationComboBox");
        locationComboBox.setI18nPrefix("tutti.property.");
        locationComboBox.setProperty("location");
        locationComboBox.setShowReset(true);
        locationComboBox.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.location"));
    }

    protected void createLocationLabel() {
        $objectMap.put("locationLabel", locationLabel = new JLabel());
        
        locationLabel.setName("locationLabel");
        locationLabel.setText(_("tutti.editFishingOperation.field.location"));
        locationLabel.setToolTipText(_("tutti.editFishingOperation.field.location.tip"));
        locationLabel.putClientProperty("help", "tutti.editFishingOperation.field.location.help");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(EditFishingOperationUIModel.class));
    }

    protected void createMultirigAggregationField() {
        $objectMap.put("multirigAggregationField", multirigAggregationField = new JTextField());
        
        multirigAggregationField.setName("multirigAggregationField");
        multirigAggregationField.setColumns(15);
        multirigAggregationField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__multirigAggregationField"));
        multirigAggregationField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.multirigAggregation"));
    }

    protected void createMultirigAggregationLabel() {
        $objectMap.put("multirigAggregationLabel", multirigAggregationLabel = new JLabel());
        
        multirigAggregationLabel.setName("multirigAggregationLabel");
        multirigAggregationLabel.setText(_("tutti.editFishingOperation.field.multirigAggregation"));
        multirigAggregationLabel.setToolTipText(_("tutti.editFishingOperation.field.multirigAggregation.tip"));
        multirigAggregationLabel.putClientProperty("help", "tutti.editFishingOperation.field.multirigAggregation.help");
    }

    protected void createRecorderPersonList() {
        $objectMap.put("recorderPersonList", recorderPersonList = new BeanDoubleList<Person>());
        
        recorderPersonList.setName("recorderPersonList");
        recorderPersonList.setI18nPrefix("tutti.property.");
        recorderPersonList.setProperty("recorderPerson");
        recorderPersonList.setShowReset(true);
        recorderPersonList.setToolTipText(_("tutti.editFishingOperation.field.recorderPerson.tip"));
        recorderPersonList.putClientProperty("help", "tutti.editFishingOperation.field.recorderPerson.help");
        recorderPersonList.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.recorderPerson"));
    }

    protected void createResetValidStateButton() {
        $objectMap.put("resetValidStateButton", resetValidStateButton = new JButton());
        
        resetValidStateButton.setName("resetValidStateButton");
        resetValidStateButton.setText(_("tutti.editFishingOperation.action.resetFishingOperationValidState"));
        resetValidStateButton.setToolTipText(_("tutti.editFishingOperation.action.resetFishingOperationValidState.tip"));
        resetValidStateButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__resetValidStateButton"));
        resetValidStateButton.putClientProperty("help", "tutti.editFishingOperation.action.resetFishingOperationValidState.help");
    }

    protected void createSaveButton() {
        $objectMap.put("saveButton", saveButton = new JButton());
        
        saveButton.setName("saveButton");
        saveButton.setText(_("tutti.editFishingOperation.action.saveFishingOperation"));
        saveButton.setToolTipText(_("tutti.editFishingOperation.action.saveEditFishingOperation.tip"));
        saveButton.putClientProperty("help", "tutti.editFishingOperation.action.saveEditFishingOperation.help");
        saveButton.putClientProperty("tuttiAction", SaveFishingOperationAction.class);
    }

    protected void createStationNumberField() {
        $objectMap.put("stationNumberField", stationNumberField = new JTextField());
        
        stationNumberField.setName("stationNumberField");
        stationNumberField.setColumns(15);
        stationNumberField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__stationNumberField"));
        stationNumberField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.stationNumber"));
    }

    protected void createStationNumberLabel() {
        $objectMap.put("stationNumberLabel", stationNumberLabel = new JLabel());
        
        stationNumberLabel.setName("stationNumberLabel");
        stationNumberLabel.setText(_("tutti.editFishingOperation.field.stationNumber"));
        stationNumberLabel.setToolTipText(_("tutti.editFishingOperation.field.stationNumber.tip"));
        stationNumberLabel.putClientProperty("help", "tutti.editFishingOperation.field.stationNumber.help");
    }

    protected void createStrataComboBox() {
        $objectMap.put("strataComboBox", strataComboBox = new BeanFilterableComboBox<FishingOperationLocation>(this));
        
        strataComboBox.setName("strataComboBox");
        strataComboBox.setI18nPrefix("tutti.property.");
        strataComboBox.setProperty("strata");
        strataComboBox.setShowReset(true);
        strataComboBox.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.strata"));
    }

    protected void createStrataLabel() {
        $objectMap.put("strataLabel", strataLabel = new JLabel());
        
        strataLabel.setName("strataLabel");
        strataLabel.setText(_("tutti.editFishingOperation.field.strata"));
        strataLabel.setToolTipText(_("tutti.editFishingOperation.field.strata.tip"));
        strataLabel.putClientProperty("help", "tutti.editFishingOperation.field.strata.help");
    }

    protected void createSubStrataComboBox() {
        $objectMap.put("subStrataComboBox", subStrataComboBox = new BeanFilterableComboBox<FishingOperationLocation>(this));
        
        subStrataComboBox.setName("subStrataComboBox");
        subStrataComboBox.setI18nPrefix("tutti.property.");
        subStrataComboBox.setProperty("subStrata");
        subStrataComboBox.setShowReset(true);
        subStrataComboBox.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.subStrata"));
    }

    protected void createSubStrataLabel() {
        $objectMap.put("subStrataLabel", subStrataLabel = new JLabel());
        
        subStrataLabel.setName("subStrataLabel");
        subStrataLabel.setText(_("tutti.editFishingOperation.field.subStrata"));
        subStrataLabel.setToolTipText(_("tutti.editFishingOperation.field.subStrata.tip"));
        subStrataLabel.putClientProperty("help", "tutti.editFishingOperation.field.subStrata.help");
    }

    protected void createTraitGeneralTab() {
        $objectMap.put("traitGeneralTab", traitGeneralTab = new TabInfo());
    }

    protected void createTraitGeneralTabPane() {
        $objectMap.put("traitGeneralTabPane", traitGeneralTabPane = new JXTitledPanel());
        
        traitGeneralTabPane.setName("traitGeneralTabPane");
    }

    protected void createTraitGeneralTabPaneToolBar() {
        $objectMap.put("traitGeneralTabPaneToolBar", traitGeneralTabPaneToolBar = new JToolBar());
        
        traitGeneralTabPaneToolBar.setName("traitGeneralTabPaneToolBar");
        traitGeneralTabPaneToolBar.setFloatable(false);
        traitGeneralTabPaneToolBar.setOpaque(false);
        traitGeneralTabPaneToolBar.setBorderPainted(false);
    }

    protected void createTraitVesselPanel() {
        $objectMap.put("traitVesselPanel", traitVesselPanel = new Table());
        
        traitVesselPanel.setName("traitVesselPanel");
    }

    protected void createTrawlDistanceField() {
        $objectMap.put("trawlDistanceField", trawlDistanceField = new NumberEditor(this));
        
        trawlDistanceField.setName("trawlDistanceField");
        trawlDistanceField.setProperty("trawlDistance");
        trawlDistanceField.setUseFloat(false);
        trawlDistanceField.setShowReset(true);
        trawlDistanceField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.trawlDistance"));
    }

    protected void createTrawlDistanceLabel() {
        $objectMap.put("trawlDistanceLabel", trawlDistanceLabel = new JLabel());
        
        trawlDistanceLabel.setName("trawlDistanceLabel");
        trawlDistanceLabel.setText(_("tutti.editFishingOperation.field.trawlDistance"));
        trawlDistanceLabel.setToolTipText(_("tutti.editFishingOperation.field.trawlDistance.tip"));
        trawlDistanceLabel.putClientProperty("help", "tutti.editFishingOperation.field.trawlDistance.help");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(EditFishingOperationUIModel.class, "validate"));
    }

    protected void createVesselComboBox() {
        $objectMap.put("vesselComboBox", vesselComboBox = new BeanFilterableComboBox<Vessel>(this));
        
        vesselComboBox.setName("vesselComboBox");
        vesselComboBox.setI18nPrefix("tutti.property.");
        vesselComboBox.setProperty("vessel");
        vesselComboBox.setShowReset(true);
        vesselComboBox.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.vessel"));
    }

    protected void createVesselLabel() {
        $objectMap.put("vesselLabel", vesselLabel = new JLabel());
        
        vesselLabel.setName("vesselLabel");
        vesselLabel.setText(_("tutti.editFishingOperation.field.vessel"));
        vesselLabel.setToolTipText(_("tutti.editFishingOperation.field.vessel.tip"));
        vesselLabel.putClientProperty("help", "tutti.editFishingOperation.field.vessel.help");
    }

    protected void createVesselUseFeatureTab() {
        $objectMap.put("vesselUseFeatureTab", vesselUseFeatureTab = new TabInfo());
    }

    protected void createVesselUseFeatureTabContent() {
        $objectMap.put("vesselUseFeatureTabContent", vesselUseFeatureTabContent = new VesselUseFeatureTabUI(this));
        
        vesselUseFeatureTabContent.setName("vesselUseFeatureTabContent");
    }

    protected void createVesselUseFeatureTabPane() {
        $objectMap.put("vesselUseFeatureTabPane", vesselUseFeatureTabPane = new JXTitledPanel());
        
        vesselUseFeatureTabPane.setName("vesselUseFeatureTabPane");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToEditFishingOperationTopPanel();
        addChildrenToValidator();
        addChildrenToTraitGeneralTabPaneToolBar();
        addChildrenToFishingOperationPane();
        addChildrenToFishingOperationTabPane();
        addChildrenToTraitGeneralTabPane();
        addChildrenToGeneralForm();
        // inline complete setup of $JPanel0
        $JPanel0.add(gearCaracteristicsTable, BorderLayout.CENTER);
        addChildrenToGearCaracteristicsTable();
        addChildrenToGearShootingStartLatitudePanel();
        // inline complete setup of $JPanel2
        $JPanel2.add(SwingUtil.boxComponentWithJxLayer(gearShootingStartLatitudeDMSDegreeField));
        $JPanel2.add(SwingUtil.boxComponentWithJxLayer(gearShootingStartLatitudeDMSMinuteField));
        $JPanel2.add(SwingUtil.boxComponentWithJxLayer(gearShootingStartLatitudeDMSSecondField));
        // inline complete setup of $JPanel3
        $JPanel3.add(SwingUtil.boxComponentWithJxLayer(gearShootingStartLatitudeDMDDegreeField));
        $JPanel3.add(SwingUtil.boxComponentWithJxLayer(gearShootingStartLatitudeDMDMinuteField));
        addChildrenToGearShootingStartLongitudePanel();
        // inline complete setup of $JPanel4
        $JPanel4.add(SwingUtil.boxComponentWithJxLayer(gearShootingStartLongitudeDMSDegreeField));
        $JPanel4.add(SwingUtil.boxComponentWithJxLayer(gearShootingStartLongitudeDMSMinuteField));
        $JPanel4.add(SwingUtil.boxComponentWithJxLayer(gearShootingStartLongitudeDMSSecondField));
        // inline complete setup of $JPanel5
        $JPanel5.add(SwingUtil.boxComponentWithJxLayer(gearShootingStartLongitudeDMDDegreeField));
        $JPanel5.add(SwingUtil.boxComponentWithJxLayer(gearShootingStartLongitudeDMDMinuteField));
        addChildrenToGearShootingEndLatitudePanel();
        // inline complete setup of $JPanel6
        $JPanel6.add(SwingUtil.boxComponentWithJxLayer(gearShootingEndLatitudeDMSDegreeField));
        $JPanel6.add(SwingUtil.boxComponentWithJxLayer(gearShootingEndLatitudeDMSMinuteField));
        $JPanel6.add(SwingUtil.boxComponentWithJxLayer(gearShootingEndLatitudeDMSSecondField));
        // inline complete setup of $JPanel7
        $JPanel7.add(SwingUtil.boxComponentWithJxLayer(gearShootingEndLatitudeDMDDegreeField));
        $JPanel7.add(SwingUtil.boxComponentWithJxLayer(gearShootingEndLatitudeDMDMinuteField));
        addChildrenToGearShootingEndLongitudePanel();
        // inline complete setup of $JPanel8
        $JPanel8.add(SwingUtil.boxComponentWithJxLayer(gearShootingEndLongitudeDMSDegreeField));
        $JPanel8.add(SwingUtil.boxComponentWithJxLayer(gearShootingEndLongitudeDMSMinuteField));
        $JPanel8.add(SwingUtil.boxComponentWithJxLayer(gearShootingEndLongitudeDMSSecondField));
        // inline complete setup of $JPanel9
        $JPanel9.add(SwingUtil.boxComponentWithJxLayer(gearShootingEndLongitudeDMDDegreeField));
        $JPanel9.add(SwingUtil.boxComponentWithJxLayer(gearShootingEndLongitudeDMDMinuteField));
        // inline complete setup of $JPanel10
        $JPanel10.add(trawlDistanceLabel, BorderLayout.WEST);
        $JPanel10.add(SwingUtil.boxComponentWithJxLayer(trawlDistanceField), BorderLayout.CENTER);
        // inline complete setup of $JPanel11
        $JPanel11.add(durationLabel, BorderLayout.WEST);
        $JPanel11.add(durationField, BorderLayout.CENTER);
        addChildrenToFishingOperationValidPanel();
        addChildrenToFishingOperationResetRadio();
        // inline complete setup of $HBox0
        $HBox0.add(fishingOperationValidRadio);
        $HBox0.add(fishingOperationInvalidRadio);
        addChildrenToFishingOperationValidRadio();
        addChildrenToFishingOperationInvalidRadio();
        // inline complete setup of $JPanel13
        $JPanel13.add(SwingUtil.boxComponentWithJxLayer(recorderPersonList));
        $JPanel13.add(traitVesselPanel);
        addChildrenToTraitVesselPanel();
        addChildrenToCommentPane();
        addChildrenToGearUseFeatureTabPane();
        addChildrenToVesselUseFeatureTabPane();
        // inline complete setup of $JPanel14
        $JPanel14.add(createFishingOperationActions, BorderLayout.CENTER);
        addChildrenToCreateFishingOperationActions();
        
        // apply 69 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 147 property setters
        strataComboBox.setBeanType(FishingOperationLocation.class);
        subStrataComboBox.setBeanType(FishingOperationLocation.class);
        locationComboBox.setBeanType(FishingOperationLocation.class);
        recorderPersonList.setBeanType(Person.class);
        vesselComboBox.setBeanType(Vessel.class);
        gearComboBox.setBeanType(Gear.class);
        gearShootingStartLongitudeLayout.setSelected( ((CoordinateEditorType)handler.getConfig().getCoordinateEditorType()).toString() );
        gearShootingStartLatitudeLayout.setSelected( ((CoordinateEditorType)handler.getConfig().getCoordinateEditorType()).toString() );
        gearShootingEndLongitudeLayout.setSelected( ((CoordinateEditorType)handler.getConfig().getCoordinateEditorType()).toString() );
        gearShootingEndLatitudeLayout.setSelected( ((CoordinateEditorType)handler.getConfig().getCoordinateEditorType()).toString() );
        importCasinoButton.setIcon(SwingUtil.createActionIcon("casino-import"));
        importCasinoButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editFishingOperation.action.importCasino.mnemonic"),'Z'));
        traitGeneralTabPane.setRightDecoration(traitGeneralTabPaneToolBar);
        stationNumberLabel.setLabelFor(stationNumberField);
        fishingOperationNumberLabel.setLabelFor(fishingOperationNumberField);
        fishingOperationNumberField.setBean(model);
        fishingOperationNumberField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        fishingOperationNumberField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        multirigAggregationLabel.setLabelFor(multirigAggregationField);
        strataLabel.setLabelFor(strataComboBox);
        strataComboBox.setBean(model);
        subStrataLabel.setLabelFor(subStrataComboBox);
        subStrataComboBox.setBean(model);
        locationLabel.setLabelFor(locationComboBox);
        locationComboBox.setBean(model);
        gearLatitudeLabel.setText(_(handler.getGearLatitudeLabelText(handler.getConfig().getCoordinateEditorType())));
        gearLatitudeLabel.setIcon(SwingUtil.createActionIcon("coordinates"));
        gearLongitudeLabel.setText(_(handler.getGearLongitudeLabelText(handler.getConfig().getCoordinateEditorType())));
        gearLongitudeLabel.setIcon(SwingUtil.createActionIcon("coordinates"));
        gearDateLabel.setIcon(SwingUtil.createActionIcon("calendar"));
        gearTimeLabel.setIcon(SwingUtil.createActionIcon("time"));
        gearShootingStartLatitudeDDField.setBean(model);
        gearShootingStartLatitudeDDField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingStartLatitudeDDField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingStartLatitudeDMSDegreeField.setBean(model);
        gearShootingStartLatitudeDMSDegreeField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingStartLatitudeDMSDegreeField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingStartLatitudeDMSMinuteField.setBean(model);
        gearShootingStartLatitudeDMSMinuteField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingStartLatitudeDMSMinuteField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingStartLatitudeDMSSecondField.setBean(model);
        gearShootingStartLatitudeDMSSecondField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingStartLatitudeDMSSecondField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingStartLatitudeDMDDegreeField.setBean(model);
        gearShootingStartLatitudeDMDDegreeField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingStartLatitudeDMDDegreeField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingStartLatitudeDMDMinuteField.setBean(model);
        gearShootingStartLatitudeDMDMinuteField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingStartLatitudeDMDMinuteField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingStartLongitudeDDField.setBean(model);
        gearShootingStartLongitudeDDField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingStartLongitudeDDField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingStartLongitudeDMSDegreeField.setBean(model);
        gearShootingStartLongitudeDMSDegreeField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingStartLongitudeDMSDegreeField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingStartLongitudeDMSMinuteField.setBean(model);
        gearShootingStartLongitudeDMSMinuteField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingStartLongitudeDMSMinuteField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingStartLongitudeDMSSecondField.setBean(model);
        gearShootingStartLongitudeDMSSecondField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingStartLongitudeDMSSecondField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingStartLongitudeDMDDegreeField.setBean(model);
        gearShootingStartLongitudeDMDDegreeField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingStartLongitudeDMDDegreeField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingStartLongitudeDMDMinuteField.setBean(model);
        gearShootingStartLongitudeDMDMinuteField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingStartLongitudeDMDMinuteField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingStartTimeField.setBean(model);
        gearShootingEndLatitudeDDField.setBean(model);
        gearShootingEndLatitudeDDField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingEndLatitudeDDField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingEndLatitudeDMSDegreeField.setBean(model);
        gearShootingEndLatitudeDMSDegreeField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingEndLatitudeDMSDegreeField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingEndLatitudeDMSMinuteField.setBean(model);
        gearShootingEndLatitudeDMSMinuteField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingEndLatitudeDMSMinuteField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingEndLatitudeDMSSecondField.setBean(model);
        gearShootingEndLatitudeDMSSecondField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingEndLatitudeDMSSecondField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingEndLatitudeDMDDegreeField.setBean(model);
        gearShootingEndLatitudeDMDDegreeField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingEndLatitudeDMDDegreeField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingEndLatitudeDMDMinuteField.setBean(model);
        gearShootingEndLatitudeDMDMinuteField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingEndLatitudeDMDMinuteField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingEndLongitudeDDField.setBean(model);
        gearShootingEndLongitudeDDField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingEndLongitudeDDField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingEndLongitudeDMSDegreeField.setBean(model);
        gearShootingEndLongitudeDMSDegreeField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingEndLongitudeDMSDegreeField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingEndLongitudeDMSMinuteField.setBean(model);
        gearShootingEndLongitudeDMSMinuteField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingEndLongitudeDMSMinuteField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingEndLongitudeDMSSecondField.setBean(model);
        gearShootingEndLongitudeDMSSecondField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingEndLongitudeDMSSecondField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingEndLongitudeDMDDegreeField.setBean(model);
        gearShootingEndLongitudeDMDDegreeField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingEndLongitudeDMDDegreeField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingEndLongitudeDMDMinuteField.setBean(model);
        gearShootingEndLongitudeDMDMinuteField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingEndLongitudeDMDMinuteField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingEndTimeField.setBean(model);
        trawlDistanceLabel.setLabelFor(trawlDistanceField);
        trawlDistanceField.setBean(model);
        trawlDistanceField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        trawlDistanceField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        durationLabel.setLabelFor(durationField);
        resetValidStateButton.setIcon(SwingUtil.createActionIcon("reset"));
        resetValidStateButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editFishingOperation.action.resetFishingOperationValidState.mnemonic"),'Z'));
        recorderPersonList.setBean(model);
        recorderPersonList.setBorder(BorderFactory.createTitledBorder(_("tutti.editFishingOperation.field.recorderPerson")));
        traitVesselPanel.setBorder(BorderFactory.createTitledBorder(_("tutti.editFishingOperation.pane.other")));
        vesselLabel.setLabelFor(vesselComboBox);
        vesselLabel.setIcon(SwingUtil.createActionIcon("vessel"));
        vesselComboBox.setBean(model);
        gearLabel.setLabelFor(gearComboBox);
        gearLabel.setIcon(SwingUtil.createActionIcon("gear"));
        gearComboBox.setBean(model);
        commentPane.setBorder(BorderFactory.createTitledBorder(_("tutti.editFishingOperation.field.comment")));
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        cancelButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editFishingOperation.action.cancelEditFishingOperation.mnemonic"),'Z'));
        saveButton.setIcon(SwingUtil.createActionIcon("save"));
        saveButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editFishingOperation.action.saveEditFishingOperation.mnemonic"),'Z'));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, editFishingOperationTopPanel, "tutti.editFishingOperation.help");
        registerHelpId(_broker, importCasinoButton, "tutti.editFishingOperation.action.importCasino.help");
        registerHelpId(_broker, fishingOperationAttachmentsButton, "tutti.editFishingOperation.action.attachments.help");
        registerHelpId(_broker, stationNumberLabel, "tutti.editFishingOperation.field.stationNumber.help");
        registerHelpId(_broker, fishingOperationNumberLabel, "tutti.editFishingOperation.field.fishingOperationNumber.help");
        registerHelpId(_broker, multirigAggregationLabel, "tutti.editFishingOperation.field.multirigAggregation.help");
        registerHelpId(_broker, strataLabel, "tutti.editFishingOperation.field.strata.help");
        registerHelpId(_broker, subStrataLabel, "tutti.editFishingOperation.field.subStrata.help");
        registerHelpId(_broker, locationLabel, "tutti.editFishingOperation.field.location.help");
        registerHelpId(_broker, gearLatitudeLabel, "tutti.editFishingOperation.field.gearLatitude.help");
        registerHelpId(_broker, gearLongitudeLabel, "tutti.editFishingOperation.field.gearLongitude.help");
        registerHelpId(_broker, gearDateLabel, "tutti.editFishingOperation.field.gearDate.help");
        registerHelpId(_broker, gearTimeLabel, "tutti.editFishingOperation.field.gearTime.help");
        registerHelpId(_broker, gearShootingStartLabel, "tutti.editFishingOperation.field.gearShootingStart.help");
        registerHelpId(_broker, gearShootingStartLatitudePanel, "tutti.editFishingOperation.field.gearShootingStartLatitude.help");
        registerHelpId(_broker, gearShootingStartLongitudePanel, "tutti.editFishingOperation.field.gearShootingStartLongitude.help");
        registerHelpId(_broker, gearShootingEndLabel, "tutti.editFishingOperation.field.gearShootingEnd.help");
        registerHelpId(_broker, gearShootingEndLatitudePanel, "tutti.editFishingOperation.field.gearShootingEndLatitude.help");
        registerHelpId(_broker, gearShootingEndLongitudePanel, "tutti.editFishingOperation.field.gearShootingEndLongitude.help");
        registerHelpId(_broker, fishingOperationRectiligneCheckBox, "tutti.editFishingOperation.field.fishingOperationRectiligne.help");
        registerHelpId(_broker, trawlDistanceLabel, "tutti.editFishingOperation.field.trawlDistance.help");
        registerHelpId(_broker, durationLabel, "tutti.editFishingOperation.field.duration.help");
        registerHelpId(_broker, fishingOperationValidPanel, "tutti.editFishingOperation.field.fishingOperationValid.help");
        registerHelpId(_broker, resetValidStateButton, "tutti.editFishingOperation.action.resetFishingOperationValidState.help");
        registerHelpId(_broker, recorderPersonList, "tutti.editFishingOperation.field.recorderPerson.help");
        registerHelpId(_broker, vesselLabel, "tutti.editFishingOperation.field.vessel.help");
        registerHelpId(_broker, gearLabel, "tutti.editFishingOperation.field.gear.help");
        registerHelpId(_broker, commentPane, "tutti.editFishingOperation.field.comment.help");
        registerHelpId(_broker, cancelButton, "tutti.editFishingOperation.action.cancelEditFishingOperation.help");
        registerHelpId(_broker, saveButton, "tutti.editFishingOperation.action.saveEditFishingOperation.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("editFishingOperationTopPanel", editFishingOperationTopPanel);
        createHandler();
        createModel();
        createValidator();
        createGearShootingStartLongitudeLayout();
        createGearShootingStartLatitudeLayout();
        createGearShootingEndLongitudeLayout();
        createGearShootingEndLatitudeLayout();
        createBroker();
        createTraitGeneralTabPaneToolBar();
        createImportCasinoButton();
        createFishingOperationAttachmentsButton();
        createFishingOperationPane();
        createFishingOperationTabPane();
        createTraitGeneralTabPane();
        createGeneralForm();
        createStationNumberLabel();
        createStationNumberField();
        createFishingOperationNumberLabel();
        createFishingOperationNumberField();
        createMultirigAggregationLabel();
        createMultirigAggregationField();
        createStrataLabel();
        createStrataComboBox();
        createSubStrataLabel();
        createSubStrataComboBox();
        createLocationLabel();
        createLocationComboBox();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createGearCaracteristicsTable();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        createGearLatitudeLabel();
        createGearLongitudeLabel();
        createGearDateLabel();
        createGearTimeLabel();
        createGearShootingStartLabel();
        createGearShootingStartLatitudePanel();
        createGearShootingStartLatitudeDDField();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new JPanel());
        
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout(new GridLayout(1,0));
        createGearShootingStartLatitudeDMSDegreeField();
        createGearShootingStartLatitudeDMSMinuteField();
        createGearShootingStartLatitudeDMSSecondField();
        // inline creation of $JPanel3
        $objectMap.put("$JPanel3", $JPanel3 = new JPanel());
        
        $JPanel3.setName("$JPanel3");
        $JPanel3.setLayout(new GridLayout(1,0));
        createGearShootingStartLatitudeDMDDegreeField();
        createGearShootingStartLatitudeDMDMinuteField();
        createGearShootingStartLongitudePanel();
        createGearShootingStartLongitudeDDField();
        // inline creation of $JPanel4
        $objectMap.put("$JPanel4", $JPanel4 = new JPanel());
        
        $JPanel4.setName("$JPanel4");
        $JPanel4.setLayout(new GridLayout(1,0));
        createGearShootingStartLongitudeDMSDegreeField();
        createGearShootingStartLongitudeDMSMinuteField();
        createGearShootingStartLongitudeDMSSecondField();
        // inline creation of $JPanel5
        $objectMap.put("$JPanel5", $JPanel5 = new JPanel());
        
        $JPanel5.setName("$JPanel5");
        $JPanel5.setLayout(new GridLayout(1,0));
        createGearShootingStartLongitudeDMDDegreeField();
        createGearShootingStartLongitudeDMDMinuteField();
        createGearShootingStartDateField();
        createGearShootingStartTimeField();
        createGearShootingEndLabel();
        createGearShootingEndLatitudePanel();
        createGearShootingEndLatitudeDDField();
        // inline creation of $JPanel6
        $objectMap.put("$JPanel6", $JPanel6 = new JPanel());
        
        $JPanel6.setName("$JPanel6");
        $JPanel6.setLayout(new GridLayout(1,0));
        createGearShootingEndLatitudeDMSDegreeField();
        createGearShootingEndLatitudeDMSMinuteField();
        createGearShootingEndLatitudeDMSSecondField();
        // inline creation of $JPanel7
        $objectMap.put("$JPanel7", $JPanel7 = new JPanel());
        
        $JPanel7.setName("$JPanel7");
        $JPanel7.setLayout(new GridLayout(1,0));
        createGearShootingEndLatitudeDMDDegreeField();
        createGearShootingEndLatitudeDMDMinuteField();
        createGearShootingEndLongitudePanel();
        createGearShootingEndLongitudeDDField();
        // inline creation of $JPanel8
        $objectMap.put("$JPanel8", $JPanel8 = new JPanel());
        
        $JPanel8.setName("$JPanel8");
        $JPanel8.setLayout(new GridLayout(1,0));
        createGearShootingEndLongitudeDMSDegreeField();
        createGearShootingEndLongitudeDMSMinuteField();
        createGearShootingEndLongitudeDMSSecondField();
        // inline creation of $JPanel9
        $objectMap.put("$JPanel9", $JPanel9 = new JPanel());
        
        $JPanel9.setName("$JPanel9");
        $JPanel9.setLayout(new GridLayout(1,0));
        createGearShootingEndLongitudeDMDDegreeField();
        createGearShootingEndLongitudeDMDMinuteField();
        createGearShootingEndDateField();
        createGearShootingEndTimeField();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        createFishingOperationRectiligneCheckBox();
        // inline creation of $JPanel10
        $objectMap.put("$JPanel10", $JPanel10 = new JPanel());
        
        $JPanel10.setName("$JPanel10");
        $JPanel10.setLayout(new BorderLayout());
        createTrawlDistanceLabel();
        createTrawlDistanceField();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        // inline creation of $JPanel11
        $objectMap.put("$JPanel11", $JPanel11 = new JPanel());
        
        $JPanel11.setName("$JPanel11");
        $JPanel11.setLayout(new BorderLayout());
        createDurationLabel();
        createDurationField();
        createFishingOperationValidPanel();
        createResetValidStateButton();
        createFishingOperationResetRadio();
        // inline creation of $HBox0
        $objectMap.put("$HBox0", $HBox0 = new HBox());
        
        $HBox0.setName("$HBox0");
        createFishingOperationValidRadio();
        createFishingOperationInvalidRadio();
        // inline creation of $JPanel12
        $objectMap.put("$JPanel12", $JPanel12 = new JPanel());
        
        $JPanel12.setName("$JPanel12");
        // inline creation of $JPanel13
        $objectMap.put("$JPanel13", $JPanel13 = new JPanel());
        
        $JPanel13.setName("$JPanel13");
        $JPanel13.setLayout(new GridLayout(1,0));
        createRecorderPersonList();
        createTraitVesselPanel();
        createVesselLabel();
        createVesselComboBox();
        createGearLabel();
        createGearComboBox();
        createCommentPane();
        createCommentField();
        createGearUseFeatureTabPane();
        createGearUseFeatureTabContent();
        createVesselUseFeatureTabPane();
        createVesselUseFeatureTabContent();
        // inline creation of $JPanel14
        $objectMap.put("$JPanel14", $JPanel14 = new JPanel());
        
        $JPanel14.setName("$JPanel14");
        $JPanel14.setLayout(new BorderLayout());
        createCreateFishingOperationActions();
        createCancelButton();
        createSaveButton();
        createTraitGeneralTab();
        createGearUseFeatureTab();
        createVesselUseFeatureTab();
        createFishingOperationValid();
        // inline creation of editFishingOperationTopPanel
        setName("editFishingOperationTopPanel");
        setLayout(new BorderLayout());
        editFishingOperationTopPanel.putClientProperty("help", "tutti.editFishingOperation.help");
        
        // registers 69 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 69 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_IMPORT_CASINO_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("id", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    importCasinoButton.setEnabled(model.getId() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("id", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FISHING_OPERATION_ATTACHMENTS_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("id", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    fishingOperationAttachmentsButton.setEnabled(model.getId() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("id", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_STATION_NUMBER_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("stationNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(stationNumberField, model.getStationNumber());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("stationNumber", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FISHING_OPERATION_NUMBER_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fishingOperationNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    fishingOperationNumberField.setModel(model.getFishingOperationNumber());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fishingOperationNumber", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FISHING_OPERATION_NUMBER_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                fishingOperationNumberField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MULTIRIG_AGGREGATION_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("multirigAggregation", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(multirigAggregationField, model.getMultirigAggregation());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("multirigAggregation", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_STRATA_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("strata", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    strataComboBox.setSelectedItem(model.getStrata());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("strata", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SUB_STRATA_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("subStrata", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    subStrataComboBox.setSelectedItem(model.getSubStrata());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("subStrata", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LOCATION_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("location", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    locationComboBox.setSelectedItem(model.getLocation());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("location", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_LATITUDE_DDFIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartLatitude", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartLatitudeDDField.setModel(model.getGearShootingStartLatitude());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartLatitude", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_LATITUDE_DMSDEGREE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartLatitudeDegree", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartLatitudeDMSDegreeField.setModel(model.getGearShootingStartLatitudeDegree());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartLatitudeDegree", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_START_LATITUDE_DMSDEGREE_FIELD_NUMBER_PATTERN, true ,"SIGNED_INT_2_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingStartLatitudeDMSDegreeField.setNumberPattern(SIGNED_INT_2_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_LATITUDE_DMSMINUTE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartLatitudeMinute", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartLatitudeDMSMinuteField.setModel(model.getGearShootingStartLatitudeMinute());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartLatitudeMinute", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_START_LATITUDE_DMSMINUTE_FIELD_NUMBER_PATTERN, true ,"INT_2_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingStartLatitudeDMSMinuteField.setNumberPattern(INT_2_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_LATITUDE_DMSSECOND_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartLatitudeSecond", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartLatitudeDMSSecondField.setModel(model.getGearShootingStartLatitudeSecond());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartLatitudeSecond", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_START_LATITUDE_DMSSECOND_FIELD_NUMBER_PATTERN, true ,"INT_2_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingStartLatitudeDMSSecondField.setNumberPattern(INT_2_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_LATITUDE_DMDDEGREE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartLatitudeDegree", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartLatitudeDMDDegreeField.setModel(model.getGearShootingStartLatitudeDegree());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartLatitudeDegree", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_START_LATITUDE_DMDDEGREE_FIELD_NUMBER_PATTERN, true ,"SIGNED_INT_2_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingStartLatitudeDMDDegreeField.setNumberPattern(SIGNED_INT_2_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_LATITUDE_DMDMINUTE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartLatitudeDecimalMinute", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartLatitudeDMDMinuteField.setModel(model.getGearShootingStartLatitudeDecimalMinute());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartLatitudeDecimalMinute", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_START_LATITUDE_DMDMINUTE_FIELD_NUMBER_PATTERN, true ,"DECIMAL2_3_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingStartLatitudeDMDMinuteField.setNumberPattern(DECIMAL2_3_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_LONGITUDE_DDFIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartLongitude", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartLongitudeDDField.setModel(model.getGearShootingStartLongitude());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartLongitude", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_LONGITUDE_DMSDEGREE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartLongitudeDegree", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartLongitudeDMSDegreeField.setModel(model.getGearShootingStartLongitudeDegree());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartLongitudeDegree", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_START_LONGITUDE_DMSDEGREE_FIELD_NUMBER_PATTERN, true ,"SIGNED_INT_3_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingStartLongitudeDMSDegreeField.setNumberPattern(SIGNED_INT_3_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_LONGITUDE_DMSMINUTE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartLongitudeMinute", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartLongitudeDMSMinuteField.setModel(model.getGearShootingStartLongitudeMinute());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartLongitudeMinute", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_START_LONGITUDE_DMSMINUTE_FIELD_NUMBER_PATTERN, true ,"INT_2_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingStartLongitudeDMSMinuteField.setNumberPattern(INT_2_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_LONGITUDE_DMSSECOND_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartLongitudeSecond", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartLongitudeDMSSecondField.setModel(model.getGearShootingStartLongitudeSecond());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartLongitudeSecond", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_START_LONGITUDE_DMSSECOND_FIELD_NUMBER_PATTERN, true ,"INT_2_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingStartLongitudeDMSSecondField.setNumberPattern(INT_2_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_LONGITUDE_DMDDEGREE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartLongitudeDegree", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartLongitudeDMDDegreeField.setModel(model.getGearShootingStartLongitudeDegree());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartLongitudeDegree", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_START_LONGITUDE_DMDDEGREE_FIELD_NUMBER_PATTERN, true ,"SIGNED_INT_3_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingStartLongitudeDMDDegreeField.setNumberPattern(SIGNED_INT_3_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_LONGITUDE_DMDMINUTE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartLongitudeDecimalMinute", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartLongitudeDMDMinuteField.setModel(model.getGearShootingStartLongitudeDecimalMinute());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartLongitudeDecimalMinute", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_START_LONGITUDE_DMDMINUTE_FIELD_NUMBER_PATTERN, true ,"DECIMAL2_3_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingStartLongitudeDMDMinuteField.setNumberPattern(DECIMAL2_3_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_DATE_FIELD_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartDateField.setDate(model.getGearShootingStartDate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_TIME_FIELD_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartTimeField.setDate(model.getGearShootingStartDate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_LATITUDE_DDFIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndLatitude", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndLatitudeDDField.setModel(model.getGearShootingEndLatitude());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndLatitude", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_LATITUDE_DMSDEGREE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndLatitudeDegree", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndLatitudeDMSDegreeField.setModel(model.getGearShootingEndLatitudeDegree());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndLatitudeDegree", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_END_LATITUDE_DMSDEGREE_FIELD_NUMBER_PATTERN, true ,"SIGNED_INT_2_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingEndLatitudeDMSDegreeField.setNumberPattern(SIGNED_INT_2_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_LATITUDE_DMSMINUTE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndLatitudeMinute", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndLatitudeDMSMinuteField.setModel(model.getGearShootingEndLatitudeMinute());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndLatitudeMinute", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_END_LATITUDE_DMSMINUTE_FIELD_NUMBER_PATTERN, true ,"INT_2_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingEndLatitudeDMSMinuteField.setNumberPattern(INT_2_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_LATITUDE_DMSSECOND_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndLatitudeSecond", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndLatitudeDMSSecondField.setModel(model.getGearShootingEndLatitudeSecond());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndLatitudeSecond", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_END_LATITUDE_DMSSECOND_FIELD_NUMBER_PATTERN, true ,"INT_2_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingEndLatitudeDMSSecondField.setNumberPattern(INT_2_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_LATITUDE_DMDDEGREE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndLatitudeDegree", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndLatitudeDMDDegreeField.setModel(model.getGearShootingEndLatitudeDegree());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndLatitudeDegree", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_END_LATITUDE_DMDDEGREE_FIELD_NUMBER_PATTERN, true ,"SIGNED_INT_2_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingEndLatitudeDMDDegreeField.setNumberPattern(SIGNED_INT_2_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_LATITUDE_DMDMINUTE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndLatitudeDecimalMinute", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndLatitudeDMDMinuteField.setModel(model.getGearShootingEndLatitudeDecimalMinute());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndLatitudeDecimalMinute", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_END_LATITUDE_DMDMINUTE_FIELD_NUMBER_PATTERN, true ,"DECIMAL2_3_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingEndLatitudeDMDMinuteField.setNumberPattern(DECIMAL2_3_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_LONGITUDE_DDFIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndLongitude", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndLongitudeDDField.setModel(model.getGearShootingEndLongitude());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndLongitude", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_LONGITUDE_DMSDEGREE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndLongitudeDegree", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndLongitudeDMSDegreeField.setModel(model.getGearShootingEndLongitudeDegree());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndLongitudeDegree", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_END_LONGITUDE_DMSDEGREE_FIELD_NUMBER_PATTERN, true ,"SIGNED_INT_3_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingEndLongitudeDMSDegreeField.setNumberPattern(SIGNED_INT_3_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_LONGITUDE_DMSMINUTE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndLongitudeMinute", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndLongitudeDMSMinuteField.setModel(model.getGearShootingEndLongitudeMinute());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndLongitudeMinute", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_END_LONGITUDE_DMSMINUTE_FIELD_NUMBER_PATTERN, true ,"INT_2_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingEndLongitudeDMSMinuteField.setNumberPattern(INT_2_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_LONGITUDE_DMSSECOND_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndLongitudeSecond", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndLongitudeDMSSecondField.setModel(model.getGearShootingEndLongitudeSecond());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndLongitudeSecond", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_END_LONGITUDE_DMSSECOND_FIELD_NUMBER_PATTERN, true ,"INT_2_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingEndLongitudeDMSSecondField.setNumberPattern(INT_2_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_LONGITUDE_DMDDEGREE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndLongitudeDegree", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndLongitudeDMDDegreeField.setModel(model.getGearShootingEndLongitudeDegree());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndLongitudeDegree", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_END_LONGITUDE_DMDDEGREE_FIELD_NUMBER_PATTERN, true ,"SIGNED_INT_3_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingEndLongitudeDMDDegreeField.setNumberPattern(SIGNED_INT_3_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_LONGITUDE_DMDMINUTE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndLongitudeDecimalMinute", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndLongitudeDMDMinuteField.setModel(model.getGearShootingEndLongitudeDecimalMinute());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndLongitudeDecimalMinute", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_END_LONGITUDE_DMDMINUTE_FIELD_NUMBER_PATTERN, true ,"DECIMAL2_3_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingEndLongitudeDMDMinuteField.setNumberPattern(DECIMAL2_3_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_DATE_FIELD_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndDateField.setDate(model.getGearShootingEndDate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_TIME_FIELD_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndTimeField.setDate(model.getGearShootingEndDate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FISHING_OPERATION_RECTILIGNE_CHECK_BOX_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fishingOperationRectiligne", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    fishingOperationRectiligneCheckBox.setSelected(model.isFishingOperationRectiligne());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fishingOperationRectiligne", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TRAWL_DISTANCE_FIELD_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fishingOperationRectiligne", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    trawlDistanceField.setEnabled(!model.isFishingOperationRectiligne());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fishingOperationRectiligne", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TRAWL_DISTANCE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("trawlDistance", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    trawlDistanceField.setModel(model.getTrawlDistance());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("trawlDistance", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TRAWL_DISTANCE_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                trawlDistanceField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TRAWL_DISTANCE_FIELD_TOOL_TIP_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("trawlDistance", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    trawlDistanceField.setToolTipText(_(handler.getTrawlDistanceTooltipText(model.getTrawlDistance())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("trawlDistance", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DURATION_FIELD_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartDate", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(durationField, handler.getDuration(model.getGearShootingStartDate(), model.getGearShootingEndDate()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartDate", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FISHING_OPERATION_RESET_RADIO_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fishingOperationValid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    fishingOperationResetRadio.setSelected(model.getFishingOperationValid() == null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fishingOperationValid", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FISHING_OPERATION_VALID_RADIO_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fishingOperationValid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    fishingOperationValidRadio.setSelected(model.getFishingOperationValid() == Boolean.TRUE);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fishingOperationValid", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FISHING_OPERATION_INVALID_RADIO_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fishingOperationValid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    fishingOperationInvalidRadio.setSelected(model.getFishingOperationValid() == Boolean.FALSE);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fishingOperationValid", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_VESSEL_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("vessel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    vesselComboBox.setSelectedItem(model.getVessel());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("vessel", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gear", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearComboBox.setSelectedItem(model.getGear());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gear", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMMENT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("comment", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(commentField, model.getComment());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("comment", this);
                }
            }
        });
    }

}