package fr.ifremer.tutti.ui.swing.content.operation.catches.accidental;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.editor.LongTextEditorUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.swing.help.JAXXHelpUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import static org.nuiton.i18n.I18n._;

public class AccidentalBatchUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<AccidentalBatchUIModel, AccidentalBatchUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1VTW8bRRh+bWKnTpsGiChBLVJJVWguYxASlyBobBLisE2j2hFRfSjj3Yk9yXhnmHmXbGUV8RP4CXDngsSNE+LAmQMXxF9AiANXxDu7/krjkB7qw8o78z7P+/3sd39CyVl444inKbNJjLIv2M7GwcH9zpEI8SPhQisNagv5r1CEYhsuR+Nzh3CrHXh4dQiv1nXf6FjEU+j1ABYcPlbC9YRAhNdPI0Lnqs3x9XpqEjtiHQc1i/Wbv/8qfh199W0RIDUU3TylcvMi1CSTuQCKMkJ4mTx9wauKx10Kw8q4S/Eu+rO64s7t8r74HL6E+QDKhlsiQ1h99pQzjgyfGoTrIpK4EYYyImuuahzDXkubPR4LhbB3aJk8tKIvLMMEUbJEMndCEbFQx0gQpo2wHKWOWeixwjE+ZmNPEe83jMlclxHmezyOlLAInz5vJ9s588RXqa8jn87+8/Z0z/NO/JQ7Vh/7lNbOd9Tyr9uEqmW2E/BVpeNuS6S4SR3RRPLe+SQJSsVEZseCU7D9hqerjFmXkHeUaIZWK+WbivCqH6R0SLQzuTmNK2U4mg9tu+yI9usYtclBKds5aPlbb7piaMavn5px2h422Z7JeBfaULIJHSOstM8u3AO6yldt5alV84TZ7b/Xln/78Y8ftkb7NUe+X5lpOiUPNPfG+rai9K6X8uXyFaze42a9DRUnFGlLph03ZgTWHF5TcOTvJQ/PG7DNXY8oSvO///Tztc9+fQGKW7CgNI+2uLdvQAV7lqqgVZSaD+9mEV05uUTPF33wCHMdwWNahUE2n08QKjxBvadNQptZHQw3hHUF1nV8KLt31ph0GyOT3aTfETZv+501jyZXJw+E84o2hzah4i/5o8y6RhNEMw5vn0PbJMNpxtyeeFPqyI0ZHRmXpVP55Z/l5vd3R10pUJVeO9d80pnSQyjLWMlYZLo3lLSZOnfZOJFEeiJds8QMqGhXplMY7tat7PnWmQYUaMof9WgTEd4crGYb5t/YDEVk/mKVSuGZ3sly9P/ehf8XUHNBBDQCi/nwkeB4LUG4PQikw+b0oWLNxu7Hweaj5mawWW817u9Sry85koh8RUuHXFHPYXlMtaWt6FqdxPQxWRzUtSKZqAUb9U+eTFvVeHg8sioP4kSpmQnmSnBRKlTMsuKPNVURrr4fceQ3OzKOSC4+OENa8M8FYvwPc+s2Iu4HAAA=";
    private static final Log log = LogFactory.getLog(AccidentalBatchUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected TuttiHelpBroker broker;
    protected AccidentalBatchUI editAccidentalBatchTopPanel = this;
    protected AccidentalBatchUIHandler handler;
    protected LongTextEditorUI longTextEditor;
    protected AccidentalBatchUIModel model;
    protected JXTable table;
    protected JScrollPane tableScrollPane;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    protected void $afterCompleteSetup() { handler.afterInitUI(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AccidentalBatchUI(TuttiUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
            AccidentalBatchUIHandler handler = new AccidentalBatchUIHandler(parentUI, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public AccidentalBatchUI() {
        $initialize();
    }

    public AccidentalBatchUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AccidentalBatchUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public AccidentalBatchUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AccidentalBatchUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public AccidentalBatchUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AccidentalBatchUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AccidentalBatchUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doFocusLost__on__table(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.saveSelectedRowIfRequired(event);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public AccidentalBatchUIHandler getHandler() {
        return handler;
    }

    public LongTextEditorUI getLongTextEditor() {
        return longTextEditor;
    }

    public AccidentalBatchUIModel getModel() {
        return model;
    }

    public JXTable getTable() {
        return table;
    }

    public JScrollPane getTableScrollPane() {
        return tableScrollPane;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToEditAccidentalBatchTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(longTextEditor);
        add(tableScrollPane, BorderLayout.CENTER);
    }

    protected void addChildrenToTableScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        tableScrollPane.getViewport().add(table);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tuttihelp.editAccidentalBatch.help"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(AccidentalBatchUIHandler.class));
    }

    protected void createLongTextEditor() {
        $objectMap.put("longTextEditor", longTextEditor = new LongTextEditorUI());
        
        longTextEditor.setName("longTextEditor");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(AccidentalBatchUIModel.class));
    }

    protected void createTable() {
        $objectMap.put("table", table = new JXTable());
        
        table.setName("table");
        table.setSortable(false);
        table.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusLost", this, "doFocusLost__on__table"));
    }

    protected void createTableScrollPane() {
        $objectMap.put("tableScrollPane", tableScrollPane = new JScrollPane());
        
        tableScrollPane.setName("tableScrollPane");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToEditAccidentalBatchTopPanel();
        addChildrenToTableScrollPane();
        
        // apply 4 property setters
        table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        table.setSelectionForeground(Color.BLACK);
        table.setSelectionBackground(null);
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, editAccidentalBatchTopPanel, "tuttihelp.editAccidentalBatch.help");
        _broker.prepareUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("editAccidentalBatchTopPanel", editAccidentalBatchTopPanel);
        createHandler();
        createModel();
        createBroker();
        createLongTextEditor();
        createTableScrollPane();
        createTable();
        // inline creation of editAccidentalBatchTopPanel
        setName("editAccidentalBatchTopPanel");
        setLayout(new BorderLayout());
        editAccidentalBatchTopPanel.putClientProperty("help", "tuttihelp.editAccidentalBatch.help");
        
        $completeSetup();
    }

}