/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.widget.status;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.Timer;

public abstract class ResourceStatus
extends JComponent
implements ActionListener {
    public static final Color COLOR_MAX_RED = new Color(250, 50, 50);
    public static final Color COLOR_MIN_BLUE = new Color(216, 224, 242);
    private static final String memoryTestStr = "99999/99999Mb";
    protected FontRenderContext frc = new FontRenderContext(null, false, false);
    protected LineMetrics lm = new JLabel().getFont().getLineMetrics("99999/99999Mb", this.frc);
    protected Timer timer;
    protected long max;
    protected long current;
    protected String formatString;

    protected ResourceStatus() {
        Font font = new JLabel().getFont();
        Rectangle2D bounds = font.getStringBounds(memoryTestStr, this.frc);
        Dimension dim = new Dimension((int)bounds.getWidth(), (int)bounds.getHeight());
        this.setPreferredSize(dim);
        this.setMaximumSize(dim);
        this.timer = new Timer(2000, this);
        this.timer.start();
    }

    protected void finalize() throws Throwable {
        this.timer.stop();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateStats();
        this.repaint();
    }

    protected abstract void updateStats();

    @Override
    public void paintComponent(Graphics g) {
        Insets insets = new Insets(0, 0, 0, 0);
        int width = this.getWidth() - insets.left - insets.right;
        int height = this.getHeight() - insets.top - insets.bottom - 1;
        float fraction = (float)this.current / (float)this.max;
        Color c = this.getMemoryColor(fraction);
        g.setColor(c);
        g.fillRect(insets.left, insets.top, (int)((float)width * fraction), height);
        Rectangle2D bounds = g.getFont().getStringBounds(this.formatString, this.frc);
        Graphics g2 = g.create();
        g2.setClip(insets.left, insets.top, (int)((float)width), height);
        g2.setColor(Color.BLACK);
        g2.drawString(this.formatString, insets.left + (int)((double)width - bounds.getWidth()) / 2, (int)((float)insets.top + this.lm.getAscent()));
        g2.dispose();
    }

    protected Color getMemoryColor(double value) {
        if (Double.isNaN(value)) {
            return COLOR_MIN_BLUE;
        }
        float[] minCol = Color.RGBtoHSB(COLOR_MIN_BLUE.getRed(), COLOR_MIN_BLUE.getGreen(), COLOR_MIN_BLUE.getBlue(), null);
        float[] maxCol = Color.RGBtoHSB(COLOR_MAX_RED.getRed(), COLOR_MAX_RED.getGreen(), COLOR_MAX_RED.getBlue(), null);
        double hColorDiff = maxCol[0] - minCol[0];
        double sColorDiff = maxCol[1] - minCol[1];
        double bColorDiff = maxCol[2] - minCol[2];
        return new Color(Color.HSBtoRGB((float)((double)minCol[0] + hColorDiff * value), (float)((double)minCol[1] + value * sColorDiff), (float)((double)minCol[2] + value * bColorDiff)));
    }
}

