/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.models.optimization;

import fr.ifremer.isisfish.datastore.CodeSourceStorage;
import fr.ifremer.isisfish.datastore.OptimizationStorage;
import fr.ifremer.isisfish.simulator.Optimization;
import fr.ifremer.isisfish.ui.models.RendererHelper;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;

public class OptimizationComboRenderer
extends DefaultListCellRenderer {
    private static final long serialVersionUID = -4070846632975105788L;
    protected Map<String, Optimization> optimizationCache = new HashMap<String, Optimization>();

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel c = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        String optimizationName = (String)value;
        if (optimizationName != null) {
            String text;
            try {
                Optimization optim = this.optimizationCache.get(optimizationName);
                if (optim == null) {
                    OptimizationStorage storage = OptimizationStorage.getOptimization(optimizationName, new CodeSourceStorage.Location[0]);
                    optim = (Optimization)storage.getNewInstance();
                    this.optimizationCache.put(optimizationName, optim);
                }
                text = RendererHelper.getNameAndDocComboString(optimizationName, optim.getDescription());
            }
            catch (Exception e) {
                text = RendererHelper.getNameAndCompComboString(optimizationName);
            }
            c.setText(text);
        }
        return c;
    }
}

