/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.config;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.ui.config.SSHLauncherConfigUI;
import fr.ifremer.isisfish.ui.keystore.PasswordManager;
import fr.ifremer.isisfish.util.ssh.InvalidPassphraseException;
import fr.ifremer.isisfish.util.ssh.SSHAgent;
import fr.ifremer.isisfish.util.ssh.SSHException;
import fr.ifremer.isisfish.util.ssh.SSHUserInfo;
import fr.ifremer.isisfish.util.ssh.SSHUtils;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.net.SocketException;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.nuiton.i18n.I18n;

public class SSHLauncherConfigHandler {
    private static final Log log = LogFactory.getLog(SSHLauncherConfigHandler.class);
    protected SSHLauncherConfigUI configUI;
    protected String currentSSHserver;
    protected String currentSSHUsername;
    protected File currentSSHKey;
    protected String currentFTPserver;
    protected String currentFTPUsername;
    protected String currentSSHIsisHome;
    protected String currentSSHJavaPath;
    protected String currentSSHPbsQsubOptions;
    protected String currentSSHMaxThreads;
    protected String currentSSHMaxMemory;
    protected String currentSSHControlInterval;

    public SSHLauncherConfigHandler(SSHLauncherConfigUI configUI) {
        this.configUI = configUI;
        configUI.setLayout(new BoxLayout(configUI.getContentPane(), 3));
    }

    protected void afterInit() {
        this.resetSSHConfiguration();
    }

    public void resetSSHConfiguration() {
        this.configUI.getSshServerField().setText(IsisFish.config.getSimulatorSshServer());
        this.configUI.getSshUsernameField().setText(IsisFish.config.getSimulatorSshUsername());
        this.configUI.getSshKeyField().setText(IsisFish.config.getSSHPrivateKeyFilePath().getAbsolutePath());
        this.configUI.getFtpServerField().setText(IsisFish.config.getSimulatorFtpServer());
        this.configUI.getFtpLoginField().setText(IsisFish.config.getSimulatorFtpLogin());
        this.configUI.getSshIsisHomeField().setText(IsisFish.config.getSimulatorSshIsisHome());
        this.configUI.getSshJavaPathField().setText(IsisFish.config.getSimulatorSshJavaPath());
        this.configUI.getSshPbsQsubOptionsField().setText(IsisFish.config.getSimulatorSshPbsQsubOptions());
        this.configUI.getSshControlIntervalField().setText(String.valueOf(IsisFish.config.getSimulatorSshControlCheckInterval()));
        this.configUI.getSshMaxThreadsField().setText(String.valueOf(IsisFish.config.getSimulatorSshMaxThreads()));
        this.configUI.getSshMaxMemoryField().setText(IsisFish.config.getSimulatorSshMaxMemory());
        this.doCheck();
    }

    protected void configurationChanged() {
        this.configUI.setConnected(false);
        this.configUI.getMessageSSHLabel().setText("");
        this.configUI.getMessageFTPLabel().setText("");
        this.configUI.getMessageMiscLabel().setText("");
    }

    public void doCheck() {
        this.configurationChanged();
        this.currentSSHserver = this.configUI.getSshServerField().getText().trim();
        if (this.currentSSHserver.isEmpty()) {
            this.setColor(true, this.configUI.getSshServerField());
        } else {
            this.setColor(false, this.configUI.getSshServerField());
        }
        this.currentSSHUsername = this.configUI.getSshUsernameField().getText().trim();
        if (!this.currentSSHUsername.matches("\\w+")) {
            this.setColor(true, this.configUI.getSshUsernameField());
        } else {
            this.setColor(false, this.configUI.getSshUsernameField());
        }
        this.currentSSHKey = new File(this.configUI.getSshKeyField().getText().trim());
        if (this.currentSSHKey.isFile() && this.currentSSHKey.canRead()) {
            this.configUI.getSshKeyButton().setEnabled(false);
            this.configUI.getSshKeyField().setEnabled(false);
            this.setColor(false, this.configUI.getSshKeyField());
        } else {
            this.setColor(true, this.configUI.getSshKeyField());
        }
        this.currentFTPserver = this.configUI.getFtpServerField().getText().trim();
        if (this.currentFTPserver.isEmpty()) {
            this.setColor(true, this.configUI.getFtpServerField());
        } else {
            this.setColor(false, this.configUI.getFtpServerField());
        }
        this.currentFTPUsername = this.configUI.getFtpLoginField().getText().trim();
        if (!this.currentFTPUsername.matches("\\w+")) {
            this.setColor(true, this.configUI.getFtpLoginField());
        } else {
            this.setColor(false, this.configUI.getFtpLoginField());
        }
        this.currentSSHIsisHome = this.configUI.getSshIsisHomeField().getText().trim();
        if (this.currentSSHIsisHome.isEmpty()) {
            this.setColor(true, this.configUI.getSshIsisHomeField());
        } else {
            this.setColor(false, this.configUI.getSshIsisHomeField());
        }
        this.currentSSHJavaPath = this.configUI.getSshJavaPathField().getText().trim();
        if (this.currentSSHJavaPath.isEmpty()) {
            this.setColor(true, this.configUI.getSshJavaPathField());
        } else {
            this.setColor(false, this.configUI.getSshJavaPathField());
        }
        this.currentSSHPbsQsubOptions = this.configUI.getSshPbsQsubOptionsField().getText().trim();
        this.currentSSHMaxThreads = this.configUI.getSshMaxThreadsField().getText().trim();
        if (!this.currentSSHMaxThreads.matches("\\d+")) {
            this.setColor(true, this.configUI.getSshMaxThreadsField());
        } else {
            this.setColor(false, this.configUI.getSshMaxThreadsField());
        }
        this.currentSSHMaxMemory = this.configUI.getSshMaxMemoryField().getText().trim();
        this.currentSSHControlInterval = this.configUI.getSshControlIntervalField().getText().trim();
        if (!this.currentSSHControlInterval.matches("\\d+")) {
            this.setColor(true, this.configUI.getSshControlIntervalField());
        } else {
            this.setColor(false, this.configUI.getSshControlIntervalField());
        }
    }

    public void saveSSHConfiguration() {
        IsisFish.config.setSimulatorSshServer(this.currentSSHserver);
        IsisFish.config.setSimulatorSshUsername(this.currentSSHUsername);
        IsisFish.config.setSimulatorFtpServer(this.currentFTPserver);
        IsisFish.config.setSimulatorFtpLogin(this.currentFTPUsername);
        if (StringUtils.isBlank((CharSequence)this.configUI.getSshKeyField().getText())) {
            IsisFish.config.setSSHPrivateKeyFilePath(null);
        } else {
            IsisFish.config.setSSHPrivateKeyFilePath(this.currentSSHKey);
        }
        IsisFish.config.setSimulatorSshIsisHome(this.currentSSHIsisHome);
        IsisFish.config.setSimulatorSshJavaPath(this.currentSSHJavaPath);
        IsisFish.config.setSimulatorSshPbsQsubOptions(this.currentSSHPbsQsubOptions);
        IsisFish.config.setSimulatorSshControlCheckInterval(Integer.parseInt(this.currentSSHControlInterval));
        IsisFish.config.setSimulatorSshMaxThreads(Integer.parseInt(this.currentSSHMaxThreads));
        IsisFish.config.setSimulatorSshMaxMemory(this.currentSSHMaxMemory);
        IsisFish.config.saveForUser(new String[0]);
        this.configUI.dispose();
    }

    public void cancelSSHConfiguration() {
        this.configUI.dispose();
    }

    public void testSSHConfiguration() {
        this.configurationChanged();
        boolean ssh = this.testSSHOnlyConfiguration();
        boolean ftp = this.testFTPOnlyConfiguration();
        if (ssh && ftp) {
            this.configUI.setConnected(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean testSSHOnlyConfiguration() {
        boolean result = false;
        JSch jsch = new JSch();
        String host = this.currentSSHserver;
        int port = 22;
        String sPort = null;
        this.configUI.getMessageSSHLabel().setText(I18n.t((String)"isisfish.simulator.ssh.configuration.connecting", (Object[])new Object[0]));
        Session session = null;
        try {
            if (host.indexOf(58) > 0) {
                sPort = host.substring(host.indexOf(58) + 1);
                port = Integer.parseInt(sPort);
                host = host.substring(0, host.indexOf(58));
            }
            boolean sshKeyUsed = false;
            if (this.currentSSHKey.isFile() && this.currentSSHKey.canRead()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Ssh key found '%s' will be used to connect to %s", this.currentSSHKey.getAbsoluteFile(), host));
                }
                jsch.addIdentity(this.currentSSHKey.getAbsolutePath());
                sshKeyUsed = true;
            } else if (log.isInfoEnabled()) {
                log.info((Object)String.format("Can't read ssh key : %s", this.currentSSHKey));
            }
            session = jsch.getSession(this.currentSSHUsername, host, port);
            SSHUserInfo ui = new SSHUserInfo();
            if (sshKeyUsed) {
                char[] passchars = SSHAgent.getAgent().getPassphrase(this.currentSSHKey);
                if (passchars != null) {
                    String passphrase = String.valueOf(passchars);
                    ui.setPassphrase(passphrase);
                }
                this.setTestSSHMessage(I18n.t((String)"isisfish.simulator.ssh.configuration.connectingpk", (Object[])new Object[0]), false);
            }
            session.setUserInfo((UserInfo)ui);
            session.connect(10000);
            this.setTestSSHMessage(I18n.t((String)"isisfish.simulator.ssh.configuration.connectionok", (Object[])new Object[0]), false);
            result = this.testMiscConfiguration(session);
        }
        catch (NumberFormatException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't connect", (Throwable)e);
            }
            this.setTestSSHMessage(I18n.t((String)"isisfish.error.simulation.remote.wrongportvalue", (Object[])new Object[]{sPort}), true);
        }
        catch (JSchException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't connect", (Throwable)e);
            }
            this.setTestSSHMessage(I18n.t((String)"isisfish.simulator.ssh.configuration.connectionerror", (Object[])new Object[]{e.getMessage()}), true);
        }
        catch (InvalidPassphraseException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't connect", (Throwable)e);
            }
            this.setTestSSHMessage(I18n.t((String)"isisfish.simulator.ssh.configuration.invalidpassphrase", (Object[])new Object[0]), true);
        }
        finally {
            if (session != null) {
                session.disconnect();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean testFTPOnlyConfiguration() {
        boolean result = false;
        String host = this.currentFTPserver;
        int port = 21;
        this.configUI.getMessageFTPLabel().setText(I18n.t((String)"isisfish.simulator.ssh.configuration.ftpconnecting", (Object[])new Object[0]));
        FTPClient ftp = null;
        try {
            if (host.indexOf(58) > 0) {
                String sPort = host.substring(host.indexOf(58) + 1);
                port = Integer.parseInt(sPort);
                host = host.substring(0, host.indexOf(58));
            }
            ftp = new FTPClient();
            ftp.connect(host, port);
            int reply = ftp.getReplyCode();
            if (FTPReply.isPositiveCompletion((int)reply)) {
                String password;
                boolean success;
                this.setTestFTPMessage(I18n.t((String)"isisfish.simulator.ssh.configuration.ftpconnectedtrylogin", (Object[])new Object[0]), false);
                String login = this.currentFTPUsername;
                int tryLogin = 0;
                boolean forceNewPassword = false;
                do {
                    password = PasswordManager.getInstance().getPassword(String.format("%s@%s", login, host), forceNewPassword);
                    success = ftp.login(login, password);
                    forceNewPassword = true;
                } while (!success && ++tryLogin < 3 && password != null);
                if (success) {
                    result = true;
                    this.setTestFTPMessage(I18n.t((String)"isisfish.simulator.ssh.configuration.ftpconnectionok", (Object[])new Object[0]), false);
                } else {
                    this.setTestFTPMessage(I18n.t((String)"isisfish.simulator.ssh.configuration.ftpconnectedcantlogin", (Object[])new Object[0]), true);
                }
            } else {
                this.setTestFTPMessage(I18n.t((String)"isisfish.simulator.ssh.configuration.ftpinvalidreplycode", (Object[])new Object[]{reply}), true);
            }
            ftp.disconnect();
        }
        catch (SocketException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't open socket", (Throwable)e);
            }
            this.setTestFTPMessage(I18n.t((String)"isisfish.simulator.ssh.configuration.ftperror", (Object[])new Object[]{e.getMessage()}), true);
        }
        catch (IOException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't connect", (Throwable)e);
            }
            this.setTestFTPMessage(I18n.t((String)"isisfish.simulator.ssh.configuration.ftperror", (Object[])new Object[]{e.getMessage()}), true);
        }
        finally {
            if (ftp != null) {
                try {
                    ftp.disconnect();
                }
                catch (IOException e) {}
            }
        }
        return result;
    }

    protected boolean testMiscConfiguration(Session session) {
        boolean result = true;
        try {
            if (result && SSHUtils.exec(session, "test -d \"" + this.currentSSHIsisHome + "\" && test -x \"" + this.currentSSHIsisHome + "\"") != 0) {
                result = false;
                this.setTestMiscMessage(I18n.t((String)"isisfish.simulator.ssh.configuration.miscisishomenotvalid", (Object[])new Object[0]), true);
            }
            if (result && SSHUtils.exec(session, "test -f \"" + this.currentSSHJavaPath + "\" && test -x \"" + this.currentSSHJavaPath + "\"") != 0) {
                result = false;
                this.setTestMiscMessage(I18n.t((String)"isisfish.simulator.ssh.configuration.miscjavapathnotvalid", (Object[])new Object[0]), true);
            }
            if (result) {
                this.setTestMiscMessage(I18n.t((String)"isisfish.simulator.ssh.configuration.miscconfigurationok", (Object[])new Object[0]), false);
            }
        }
        catch (SSHException e) {
            this.setTestMiscMessage(I18n.t((String)"isisfish.simulator.ssh.configuration.miscconfigurationerror", (Object[])new Object[]{e.getMessage()}), true);
        }
        return result;
    }

    protected void generateSSHKey() {
        block5: {
            if (this.currentSSHKey.exists()) {
                throw new IllegalArgumentException("Can't overwrite ssh key");
            }
            try {
                if (this.currentSSHKey.getParentFile() != null && !this.currentSSHKey.getParentFile().exists()) {
                    this.currentSSHKey.getParentFile().mkdirs();
                }
                JSch jsch = new JSch();
                KeyPair kpair = KeyPair.genKeyPair((JSch)jsch, (int)2, (int)2048);
                kpair.writePrivateKey(this.currentSSHKey.getAbsolutePath());
                kpair.writePublicKey(this.currentSSHKey.getAbsolutePath() + ".pub", this.currentSSHUsername + "@forIsisFish");
                if (log.isInfoEnabled()) {
                    log.info((Object)("Finger print: " + kpair.getFingerPrint()));
                }
                kpair.dispose();
            }
            catch (JSchException | IOException e) {
                if (!log.isErrorEnabled()) break block5;
                log.error((Object)"Can't make ssh key", e);
            }
        }
        this.doCheck();
    }

    protected void setColor(boolean invalid, JComponent component) {
        component.setForeground(invalid ? Color.RED : Color.BLACK);
    }

    protected void setTestSSHMessage(String message, boolean error) {
        this.configUI.getMessageSSHLabel().setForeground(error ? Color.RED : Color.GREEN.darker());
        this.configUI.getMessageSSHLabel().setText(message);
    }

    protected void setTestFTPMessage(String message, boolean error) {
        this.configUI.getMessageFTPLabel().setForeground(error ? Color.RED : Color.GREEN.darker());
        this.configUI.getMessageFTPLabel().setText(message);
    }

    protected void setTestMiscMessage(String message, boolean error) {
        this.configUI.getMessageMiscLabel().setForeground(error ? Color.RED : Color.GREEN.darker());
        this.configUI.getMessageMiscLabel().setText(message);
    }
}

