/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coselmar.services.v1;

import fr.ifremer.coselmar.beans.DocumentBean;
import fr.ifremer.coselmar.beans.QuestionBean;
import fr.ifremer.coselmar.beans.UserWebToken;
import fr.ifremer.coselmar.converter.BeanEntityConverter;
import fr.ifremer.coselmar.exceptions.CoselmarTechnicalException;
import fr.ifremer.coselmar.persistence.entity.CoselmarUserRole;
import fr.ifremer.coselmar.persistence.entity.Document;
import fr.ifremer.coselmar.persistence.entity.Question;
import fr.ifremer.coselmar.services.CoselmarWebServiceSupport;
import fr.ifremer.coselmar.services.errors.InvalidCredentialException;
import fr.ifremer.coselmar.services.errors.UnauthorizedException;
import fr.ifremer.coselmar.services.indexation.DocumentsIndexationService;
import fr.ifremer.coselmar.services.indexation.QuestionsIndexationService;
import fr.ifremer.coselmar.services.indexation.TikaUtils;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaIdFactory;

public class AdminWebService
extends CoselmarWebServiceSupport {
    private static final Log log = LogFactory.getLog(AdminWebService.class);

    public void refreshLuceneIndex() throws UnauthorizedException, InvalidCredentialException {
        String authorization = this.getContext().getHeader("Authorization");
        UserWebToken userWebToken = this.checkAuthentication(authorization);
        if (!StringUtils.equals((CharSequence)userWebToken.getRole(), (CharSequence)CoselmarUserRole.ADMIN.name())) {
            if (log.isDebugEnabled()) {
                String message = String.format("A non admin user try to refresh lucene index.", new Object[0]);
                log.debug((Object)message);
            }
            throw new UnauthorizedException("Not allowed to execute operation");
        }
        QuestionsIndexationService questionsIndexationService = (QuestionsIndexationService)this.getServicesContext().newService(QuestionsIndexationService.class);
        try {
            this.getServicesContext().getLuceneUtils().clearIndex();
            this.refreshDocumentsIndex();
            List questions = this.getQuestionDao().findAll();
            for (Question question : questions) {
                QuestionBean questionBean = BeanEntityConverter.toLightBean((TopiaIdFactory)this.getPersistenceContext().getTopiaIdFactory(), (Question)question);
                questionsIndexationService.indexQuestion(questionBean);
            }
            if (log.isDebugEnabled()) {
                String message = String.format("Index was refreshed", new Object[0]);
                log.debug((Object)message);
            }
        }
        catch (IOException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Unable to index new document", (Throwable)e);
            }
            throw new CoselmarTechnicalException("Error during Index Refresh", (Throwable)e);
        }
    }

    protected void refreshDocumentsIndex() throws IOException {
        DocumentsIndexationService documentsIndexationService = (DocumentsIndexationService)this.getServicesContext().newService(DocumentsIndexationService.class);
        documentsIndexationService.cleanIndex();
        List documents = this.getDocumentDao().findAll();
        for (Document document : documents) {
            DocumentBean documentBean = BeanEntityConverter.toBean((TopiaIdFactory)this.getPersistenceContext().getTopiaIdFactory(), (Document)document);
            if (!document.isWithFile()) continue;
            String fileContent = TikaUtils.getFileContent((String)document.getFilePath());
            documentsIndexationService.indexDocument(documentBean, fileContent);
            document.setFileContent(fileContent);
            this.getDocumentDao().update((TopiaEntity)document);
        }
        this.commit();
    }
}

