/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.admin.renderers;

import com.jurismarches.vradi.ui.helpers.UIHelper;
import java.awt.Component;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JListCellRenderer
implements TableCellRenderer {
    private static final Log log = LogFactory.getLog(JListCellRenderer.class);
    protected JList list;
    protected TableCellRenderer delegateRenderer;

    public JListCellRenderer() {
        this(new DefaultTableCellRenderer());
    }

    public JListCellRenderer(TableCellRenderer delegateRenderer) {
        this.delegateRenderer = delegateRenderer;
        this.list = new JList(new DefaultListModel());
    }

    public void updateUniverse(List<String> values) {
        UIHelper.fillList((JList)this.list, values, null);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("renderer value " + value));
        }
        UIHelper.updateListSelection(this.list, value);
        this.renderFromDelegate(table, value, isSelected, hasFocus, row, column);
        return this.list;
    }

    protected void renderFromDelegate(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JComponent rendererComponent = (JComponent)this.delegateRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.list.setBackground(rendererComponent.getBackground());
        this.list.setFont(rendererComponent.getFont());
        this.list.setBorder(rendererComponent.getBorder());
    }
}

