/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: QueryCellEditor.java 1715 2010-10-27 19:21:28Z tchemit $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.5.0/vradi-swing/src/main/java/com/jurismarches/vradi/ui/admin/query/QueryCellEditor.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.query;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import javax.swing.AbstractCellEditor;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.TreeCellEditor;

import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.DefaultJAXXContext;

import com.jurismarches.vradi.beans.QueryBean;
import com.jurismarches.vradi.ui.admin.AdminHandler;
import com.jurismarches.vradi.ui.admin.popups.AdminRequestUI;
import com.jurismarches.vradi.ui.helpers.UIHelper;

/**
 * QueryCellEditor.
 *
 * @author schorlet
 * @version $Revision: 1715 $ $Date: 2010-10-27 21:21:28 +0200 (mer., 27 oct. 2010) $
 * @since 6 avr. 2010 16:24:19
 */
public class QueryCellEditor extends AbstractCellEditor implements
        TreeCellEditor, TableCellEditor {

    private static final long serialVersionUID = 1L;

    final JLabel label;
    final JAXXContext parentContext;
    String currentQuery = null;
    
    public QueryCellEditor(JAXXContext context) {
        this.parentContext = context;
        
        label = new JLabel();
        label.setOpaque(true);

        label.addMouseListener(new MouseAdapter() {
            @Override
            public void mouseReleased(MouseEvent e) {
                openRequest();
            }
        });
    }

    @Override
    public Object getCellEditorValue() {
        return currentQuery;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value,
            boolean isSelected, int row, int column) {

        currentQuery = (String) value;
        label.setText(currentQuery);
        return label;
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value,
            boolean isSelected, boolean expanded, boolean leaf, int row) {

        currentQuery = (String) value;
        label.setText(currentQuery);
        return label;
    }

    public void openRequest() {
        JAXXContext context = new DefaultJAXXContext();
        context.setContextValue(parentContext);
        
        QueryBean query = new QueryBean();
        query = query.setQuery(currentQuery);

        AdminHandler adminHandler = UIHelper.getHandler(context,
                AdminHandler.class);
        AdminRequestUI adminRequestUI = adminHandler.createAdminRequestUI(
                context, query, null);

        adminRequestUI.addPropertyChangeListener(
            AdminRequestUI.PROPERTY_REQUEST, new PropertyChangeListener() {
                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    currentQuery = (String) evt.getNewValue();
                }
            });

        adminRequestUI.setModal(true);
        adminRequestUI.setVisible(true);
        fireEditingStopped();
    }
}
