/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.popups;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.admin.AdminHandler;
import com.jurismarches.vradi.ui.admin.models.TemplateFieldTableModel;
import com.jurismarches.vradi.ui.admin.popups.*;
import com.jurismarches.vradi.ui.admin.renderers.JListCellRenderer;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.offer.editors.JListCellEditor;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.nuiton.wikitty.entities.WikittyExtension;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class TemplateFieldBindingUI extends javax.swing.JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_EXTENSION = "extension";
    public static final String PROPERTY_FIELDS_MODEL = "fieldsModel";
    public static final String PROPERTY_TEMPLATE = "template";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.popups.TemplateFieldBindingUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.lang.String extension;
    protected com.jurismarches.vradi.ui.admin.models.TemplateFieldTableModel fieldsModel;
    protected org.jdesktop.swingx.JXTable fieldsTable;
    protected java.lang.String template;
    protected TemplateFieldBindingUI templateFieldBindingUI = this;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JScrollPane $JScrollPane0;
    private javax.swing.JButton $JButton0;
    private javax.swing.JButton $JButton1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected AdminHandler getHandler() {
        return getContextValue(AdminHandler.class);
    }
    
    void $afterCompleteSetup() {
        SwingUtil.setI18nTableHeaderRenderer(fieldsTable,
                n_("vradi.table.field.name"),
                n_("vradi.table.field.name.tip"),
                n_("vradi.table.field.values"),
                n_("vradi.table.field.values.tip"));
    
        TableCellRenderer tbc = new DefaultTableCellRenderer() {
    
            @Override
            public Component getTableCellRendererComponent(JTable jTable,
                                                           Object o,
                                                           boolean b,
                                                           boolean b1,
                                                           int i,
                                                           int i1) {
    
                String sValue = null;
                if(o != null) {
                    java.util.List<String> sValues = (java.util.List<String>) o;
                    if(!sValues.isEmpty()) {
                        sValue = sValues.get(0);
                        sValue = sValue.substring(sValue.lastIndexOf(".") + 1);
                    }
                }
                return super.getTableCellRendererComponent(jTable,
                        sValue, b, b1, i, i1);
            }
        };
        JListCellRenderer renderer = new JListCellRenderer(tbc);
    
        setContextValue(renderer);
        SwingUtil.setTableColumnRenderer(fieldsTable, 0, fieldsTable.getDefaultRenderer(String.class));
        SwingUtil.setTableColumnRenderer(fieldsTable, 1, renderer);
    
        JListCellEditor editor = new JListCellEditor(true);
        setContextValue(editor);
        SwingUtil.setTableColumnEditor(fieldsTable, 1, editor);
        final Highlighter highlighter = HighlighterFactory.createAlternateStriping(
                HighlighterFactory.NOTEPAD, HighlighterFactory.GENERIC_GRAY);
        fieldsTable.addHighlighter(highlighter);
    
        this.pack();
    
        // Register for save disposition
        UIHelper.registerComponentToSaveDispositionConfig(this);
    }
    
    public void close() {
        UIHelper.saveComponentDispositionConfig();
        this.dispose();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public TemplateFieldBindingUI() {
        $initialize();
    }

    public TemplateFieldBindingUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        close();
    }

    public void doActionPerformed__on__$JButton1(java.awt.event.ActionEvent event) {
        getHandler().saveTemplateFieldBinding(this);
    }

    public void doWindowClosing__on__templateFieldBindingUI(java.awt.event.WindowEvent event) {
        dispose();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public java.lang.String getExtension() {
        return extension;
    }

    public com.jurismarches.vradi.ui.admin.models.TemplateFieldTableModel getFieldsModel() {
        return fieldsModel;
    }

    public org.jdesktop.swingx.JXTable getFieldsTable() {
        return fieldsTable;
    }

    public java.lang.String getTemplate() {
        return template;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setExtension(java.lang.String newValue) {
        java.lang.String oldValue = this.extension;
        this.extension = newValue;
        firePropertyChange(PROPERTY_EXTENSION, oldValue, newValue);
    }

    public void setFieldsModel(com.jurismarches.vradi.ui.admin.models.TemplateFieldTableModel newValue) {
        com.jurismarches.vradi.ui.admin.models.TemplateFieldTableModel oldValue = this.fieldsModel;
        this.fieldsModel = newValue;
        firePropertyChange(PROPERTY_FIELDS_MODEL, oldValue, newValue);
    }

    public void setTemplate(java.lang.String newValue) {
        java.lang.String oldValue = this.template;
        this.template = newValue;
        firePropertyChange(PROPERTY_TEMPLATE, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JButton get$JButton1() {
        return $JButton1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToTemplateFieldBindingUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($Table0);
    }

    protected void createExtension() {
        $objectMap.put("extension", extension = null);
    }

    protected void createFieldsModel() {
        $objectMap.put("fieldsModel", fieldsModel = new TemplateFieldTableModel());
    }

    protected void createFieldsTable() {
        $objectMap.put("fieldsTable", fieldsTable = new org.jdesktop.swingx.JXTable());
        
        fieldsTable.setName("fieldsTable");
        if (fieldsTable.getFont() != null) {
            fieldsTable.setFont(fieldsTable.getFont().deriveFont((float) 11));
        }
        fieldsTable.setRowSelectionAllowed(false);
    }

    protected void createTemplate() {
        $objectMap.put("template", template = null);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToTemplateFieldBindingUI();
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane0, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JButton0, new GridBagConstraints(0, 2, 1, 1, 0.5, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JButton1, new GridBagConstraints(1, 2, 1, 1, 0.5, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(fieldsTable);
        
        // apply 3 property setters
        setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        fieldsTable.setModel(fieldsModel);
        // late initializer
        templateFieldBindingUI.pack();
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("templateFieldBindingUI", this);
        createExtension();
        createTemplate();
        createFieldsModel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminFormType.template.fieldBinding.label"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createFieldsTable();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("vradi.common.cancel"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new javax.swing.JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("vradi.common.validate"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of templateFieldBindingUI
        setName("templateFieldBindingUI");
        templateFieldBindingUI.getContentPane().setLayout(new BorderLayout());
        setModal(true);
        setTitle(_("vradi.adminFormType.template.fieldBinding.title"));
        templateFieldBindingUI.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__templateFieldBindingUI"));
        
        $completeSetup();
    }

}