/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: ClientNavigationTreeHelper.java 1830 2010-12-16 10:23:38Z sletellier $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.5.0/vradi-swing/src/main/java/com/jurismarches/vradi/ui/admin/helpers/ClientNavigationTreeHelper.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.helpers;

import java.util.Set;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiEntitiesListener;
import com.jurismarches.vradi.ui.admin.loadors.ClientsAndUsersNodeLoadors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.ui.tree.VradiDataProvider;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;

/**
 * @author letellier
 */
public class ClientNavigationTreeHelper extends AdminNavigationTreeHelper<Client> {

    /** Logger. */
    static private final Log log = LogFactory.getLog(ClientNavigationTreeHelper.class);

    protected VradiEntitiesListener<User> userVradiEntitiesListener;

    public ClientNavigationTreeHelper(VradiDataProvider dataProvider) {
        super(dataProvider);

        VradiContext.get().getVradiNotifier().addVradiListener(Client.class, this);
        userVradiEntitiesListener = new VradiEntitiesListener<User>() {

            @Override
            public void entitiesAdded(Set<User> added) {

                for (User user : added) {

                    String wikittyId = user.getWikittyId();

                    // cas creation
                    VradiTreeNode existingNode = findNode(getRootNode(), wikittyId);

                    // cas modification
                    if (existingNode != null) {
                        if (log.isDebugEnabled()) {
                            log.debug("User modification occured");
                        }
                        // Reconstruction des fils
                        refresh(existingNode);
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug("User creation occured");
                        }
                        createUserNode(wikittyId, false);
                    }
                }
            }

            @Override
            public void entitiesRemoved(Set<String> removed) {
                removeEntities(removed);
            }
        };
        VradiContext.get().getVradiNotifier().addVradiListener(User.class, userVradiEntitiesListener);
    }

    @Override
    public VradiTreeNode createNode() {

        // Create client category node
        return new VradiTreeNode(
                String.class,
                AdminBeanConstant.CLIENT.getCategoryName(),
                null,
                new ClientsAndUsersNodeLoadors()
        );
    }

    @Override
    public void createEntityNode(String wikittyId) {
        createClientNode(wikittyId, false);
    }
}
