/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.entities.InfogeneImpl;
import com.jurismarches.vradi.ui.admin.content.*;
import com.jurismarches.vradi.ui.admin.models.FieldSelectModel;
import com.jurismarches.vradi.ui.admin.popups.TemplateFieldBindingUI;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.text.DateFormat;
import java.util.*;
import java.util.Date;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.validator.swing.SwingValidatorMessageListRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.entities.FieldType;
import org.nuiton.wikitty.entities.WikittyExtension;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.SwingUtil.getStringValue;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class AdminFormTypeUI extends com.jurismarches.vradi.ui.admin.AdminContentUI<WikittyExtension> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$ADMIN_CONTENT_UI0_ENABLED = "$AdminContentUI0.enabled";
    private static final String BINDING_$JBUTTON0_ENABLED = "$JButton0.enabled";
    private static final String BINDING_$JBUTTON1_ENABLED = "$JButton1.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.content.AdminFormTypeUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected org.nuiton.wikitty.entities.WikittyExtension bean;
    protected jaxx.runtime.swing.CardLayout2 cardLayout;
    protected javax.swing.JPanel cardPanel;
    protected jaxx.runtime.swing.VBox content;
    protected javax.swing.JButton createField;
    protected javax.swing.JButton createForm;
    protected javax.swing.JButton downloadTemplate;
    protected jaxx.runtime.swing.Table fieldListUI;
    protected jaxx.runtime.swing.HidorButton hidorInfogene;
    protected javax.swing.JPanel infogene;
    protected jaxx.runtime.swing.HBox lastModified;
    protected javax.swing.JButton newTemplate;
    protected javax.swing.JButton templateBindingButton;
    protected javax.swing.JComboBox templateChoice;
    protected javax.swing.JButton templateExampleButton;
    protected javax.swing.JLabel title;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private AdminFormTypeUI $AdminContentUI0 = this;
    private javax.swing.JButton $JButton0;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JPanel $JPanel0;
    private javax.swing.JButton $JButton1;
    private javax.swing.JScrollPane $JScrollPane0;
    private javax.swing.JPanel $JPanel1;
    private javax.swing.JLabel $JLabel1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void postLoadBean() {
    
        title.setText(_("vradi.adminForm.title", getStringValue(bean == null ? "" : bean.getName())));
        if (bean == null) {
            return;
        }
    
        // Update template choice
        templateChoice.setModel(getHandler().getTemplateComboBoxModel(bean));
    
        // Select template
        templateChoice.setSelectedItem(getHandler().getFormTypeTemplateName(bean));
    
        // Fill other fields that infogene
        int i = 0;
        Collection<String> fieldNames = bean.getFieldNames();
        for (String fieldName : fieldNames) {
            FieldType fieldType = bean.getFieldType(fieldName);
            String fieldDesc = VradiHelper.getFieldTypeDescription(fieldType);
            FieldSelectModel fieldSelectModel = new FieldSelectModel(fieldName, fieldDesc,
                    VradiHelper.getFieldTypeEnum(fieldType), i);
            create(fieldSelectModel);
            i = i + 1;
        }
        fillInfogenePanel();
        setModified(false);
        validate();
    }
    
    @Override
    public void save() {
        getHandler().saveFormType(this, getHelper());
        setModified(false);
    }
    
    @Override
    protected void clearUI() {
        content.removeAll();
    }
    
    protected void create() {
        create(new FieldSelectModel(content.getComponentCount()));
    }
    
    protected void create(FieldSelectModel fieldSelectModel){
        FieldSelectUI result = new FieldSelectUI(this);
    
        result.updateBean(fieldSelectModel);
        result.addPropertyChangeListener(FieldSelectUI.PROPERTY_MODIFIED, new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                FieldSelectUI field = (FieldSelectUI) evt.getSource();
                if (log.isDebugEnabled()) {
                    log.debug("field " + field + " modified value =  " + evt.getNewValue());
                }
                setModified(true);
                if(evt.getNewValue() == null) {
    
                    if(field != null) {
                        field.setVisible(false);
                        content.remove(field);
                    }
                    if(field.getBean().isUpOrDown() != null) {
                        if(field.getBean().isUpOrDown() && field.getBean().getPosition() == 0) {
                            content.add(field, 0);
                        } else if(!field.getBean().isUpOrDown() && field.getBean().getPosition() == content.getComponentCount()) {
                            content.add(field);
                        } else {
                            int fieldToMovePosition = field.getBean().isUpOrDown() ?
                                    field.getBean().getPosition() - 1 : field.getBean().getPosition();
                            int fieldToAddPosition = field.getBean().isUpOrDown() ?
                                    field.getBean().getPosition() - 1 : field.getBean().getPosition() + 1;
                            FieldSelectUI fieldToMove = (FieldSelectUI) content.getComponent(fieldToMovePosition);
                            if (log.isDebugEnabled()) {
                                log.debug(fieldToMove.getBean().getNameValue() + " : " + fieldToMove.getBean().getPosition());
                            }
    
                            content.add(field, fieldToAddPosition);
                            for(int i = 0 ; i < content.getComponentCount() ; i++) {
                                FieldSelectUI fieldSelectUI = (FieldSelectUI) content.getComponent(i);
                                fieldSelectUI.getBean().setPosition(i);
                                if (log.isDebugEnabled()) {
                                    log.debug(fieldSelectUI.getBean().getNameValue() + " : " + fieldSelectUI.getBean().getPosition());
                                }
                            }
                        }
                        field.getBean().setUpOrDown(null);
                        field.setVisible(true);
                    }
                    content.validate();
                }
            }
        });
        result.setModified(false);
    
        content.add(result);
        validate();
    }
    
    private void fillInfogenePanel() {
        infogene.removeAll();
        WikittyExtension extension = InfogeneImpl.extensionInfogene;
        int i = 0;
        java.util.List<String> fieldNames = new ArrayList<String>();
        fieldNames.add(Infogene.FIELD_INFOGENE_ID);
        fieldNames.add(Infogene.FIELD_INFOGENE_OBJET);
        fieldNames.add(Infogene.FIELD_INFOGENE_DESCRIPTION);
        fieldNames.add(Infogene.FIELD_INFOGENE_CREATIONDATE);
        fieldNames.add(Infogene.FIELD_INFOGENE_ENTITY);
        fieldNames.add(Infogene.FIELD_INFOGENE_SOURCETEXT);
        fieldNames.add(Infogene.FIELD_INFOGENE_SOURCEURL);
        fieldNames.add(Infogene.FIELD_INFOGENE_COUNTRY);
        fieldNames.add(Infogene.FIELD_INFOGENE_DEPARTMENT);
        fillInfogenePanel(fieldNames, extension, i);
    
        extension = FormImpl.extensionForm;
        fieldNames.clear();
        fieldNames.add(Form.FIELD_FORM_DATEPUB);
        fieldNames.add(Form.FIELD_FORM_DATEPEREMPTION);
        fillInfogenePanel(fieldNames, extension, i);
    }
    
    private void fillInfogenePanel(java.util.List<String> fieldNames,
                                   WikittyExtension extension, int i) {
        for (String fieldName : fieldNames) {
            FieldType fieldType = extension.getFieldType(fieldName);
            String fieldDesc = VradiHelper.getFieldTypeDescription(fieldType);
    
            FieldSelectModel fieldSelectModel = new FieldSelectModel(fieldName, fieldDesc,
                    FieldTypeEnum.valueOf(fieldType), i);
    
            FieldDisplayUI fieldDisplayUI = new FieldDisplayUI(this);
            fieldDisplayUI.updateBean(fieldSelectModel);
    
            infogene.add(fieldDisplayUI);
            i = i + 1;
        }
    
    }
    
    private void onHidorInfogene() {
        if (hidorInfogene.isSelected()) {
            cardLayout.show(cardPanel, "infogene");
        } else {
            cardLayout.show(cardPanel, "content");
        }
    }
    
    private void openTemplateFieldBindingUI() {
        TemplateFieldBindingUI templateFieldBindingUI =
                new TemplateFieldBindingUI(this);
        getHandler().updateTemplateFieldTableModel(templateFieldBindingUI,
                getBean(), (String) templateChoice.getSelectedItem());
        templateFieldBindingUI.setVisible(true);
        setModified(true);
    }
    
    protected void addNewTemplate() {
        if (getHandler().uploadNewTemplate(this)) {
            openTemplateFieldBindingUI();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminFormTypeUI() {
        super();
        $initialize();
    }

    public AdminFormTypeUI(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        getHandler().delete(this, getHelper(), getBean());
    }

    public void doActionPerformed__on__$JButton1(java.awt.event.ActionEvent event) {
        getHandler().delete(this, getHelper(), getBean());
    }

    public void doActionPerformed__on__createField(java.awt.event.ActionEvent event) {
        create();
    }

    public void doActionPerformed__on__createForm(java.awt.event.ActionEvent event) {
        getHandler().createFormType(this, getHelper()); setModified(true);
    }

    public void doActionPerformed__on__downloadTemplate(java.awt.event.ActionEvent event) {
        getHandler().downloadTemplate(this);
    }

    public void doActionPerformed__on__hidorInfogene(java.awt.event.ActionEvent event) {
        onHidorInfogene();
    }

    public void doActionPerformed__on__newTemplate(java.awt.event.ActionEvent event) {
        addNewTemplate();
    }

    public void doActionPerformed__on__templateBindingButton(java.awt.event.ActionEvent event) {
        openTemplateFieldBindingUI();
    }

    public void doActionPerformed__on__templateChoice(java.awt.event.ActionEvent event) {
        setModified(true);
    }

    public void doActionPerformed__on__templateExampleButton(java.awt.event.ActionEvent event) {
        getHandler().showTemplateExample(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public org.nuiton.wikitty.entities.WikittyExtension getBean() {
        return bean;
    }

    public jaxx.runtime.swing.CardLayout2 getCardLayout() {
        return cardLayout;
    }

    public javax.swing.JPanel getCardPanel() {
        return cardPanel;
    }

    public jaxx.runtime.swing.VBox getContent() {
        return content;
    }

    public javax.swing.JButton getCreateField() {
        return createField;
    }

    public javax.swing.JButton getCreateForm() {
        return createForm;
    }

    public javax.swing.JButton getDownloadTemplate() {
        return downloadTemplate;
    }

    public jaxx.runtime.swing.Table getFieldListUI() {
        return fieldListUI;
    }

    public jaxx.runtime.swing.HidorButton getHidorInfogene() {
        return hidorInfogene;
    }

    public javax.swing.JPanel getInfogene() {
        return infogene;
    }

    public jaxx.runtime.swing.HBox getLastModified() {
        return lastModified;
    }

    public javax.swing.JButton getNewTemplate() {
        return newTemplate;
    }

    public javax.swing.JButton getTemplateBindingButton() {
        return templateBindingButton;
    }

    public javax.swing.JComboBox getTemplateChoice() {
        return templateChoice;
    }

    public javax.swing.JButton getTemplateExampleButton() {
        return templateExampleButton;
    }

    public javax.swing.JLabel getTitle() {
        return title;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(org.nuiton.wikitty.entities.WikittyExtension newValue) {
        org.nuiton.wikitty.entities.WikittyExtension oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange(PROPERTY_BEAN, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JButton get$JButton1() {
        return $JButton1;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected javax.swing.JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add(fieldListUI, BorderLayout.CENTER);
        body.add(lastModified, BorderLayout.SOUTH);
    }

    protected void addChildrenToCardPanel() {
        if (!allComponentsCreated) {
            return;
        }
        cardPanel.add(content, "content");
        cardPanel.add(infogene, "infogene");
    }

    protected void addChildrenToFieldListUI() {
        if (!allComponentsCreated) {
            return;
        }
        fieldListUI.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        fieldListUI.add($JPanel0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        fieldListUI.add($JScrollPane0, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        fieldListUI.add($JPanel1, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        toolbar.add(title, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        toolbar.add(createForm, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        toolbar.add($JButton0, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createCardLayout() {
        $objectMap.put("cardLayout", cardLayout = new jaxx.runtime.swing.CardLayout2());
    }

    protected void createCardPanel() {
        $objectMap.put("cardPanel", cardPanel = new javax.swing.JPanel());
        
        cardPanel.setName("cardPanel");
        cardPanel.setLayout(cardLayout);
    }

    protected void createContent() {
        $objectMap.put("content", content = new jaxx.runtime.swing.VBox());
        
        content.setName("content");
    }

    protected void createCreateField() {
        $objectMap.put("createField", createField = new javax.swing.JButton());
        
        createField.setName("createField");
        createField.setText(_("vradi.adminField.new"));
        createField.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createField"));
    }

    protected void createCreateForm() {
        $objectMap.put("createForm", createForm = new javax.swing.JButton());
        
        createForm.setName("createForm");
        createForm.setText(_("vradi.adminForm.createForm"));
        createForm.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createForm"));
    }

    protected void createDownloadTemplate() {
        $objectMap.put("downloadTemplate", downloadTemplate = new javax.swing.JButton());
        
        downloadTemplate.setName("downloadTemplate");
        downloadTemplate.setText(_("vradi.adminFormType.template.download"));
        downloadTemplate.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__downloadTemplate"));
    }

    protected void createFieldListUI() {
        $objectMap.put("fieldListUI", fieldListUI = new jaxx.runtime.swing.Table());
        
        fieldListUI.setName("fieldListUI");
    }

    protected void createHidorInfogene() {
        $objectMap.put("hidorInfogene", hidorInfogene = new jaxx.runtime.swing.HidorButton());
        
        hidorInfogene.setName("hidorInfogene");
        hidorInfogene.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__hidorInfogene"));
    }

    protected void createInfogene() {
        $objectMap.put("infogene", infogene = new javax.swing.JPanel());
        
        infogene.setName("infogene");
        infogene.setLayout(new GridLayout(0,1));
    }

    protected void createLastModified() {
        $objectMap.put("lastModified", lastModified = new jaxx.runtime.swing.HBox());
        
        lastModified.setName("lastModified");
        lastModified.setHorizontalAlignment(4);
    }

    protected void createNewTemplate() {
        $objectMap.put("newTemplate", newTemplate = new javax.swing.JButton());
        
        newTemplate.setName("newTemplate");
        newTemplate.setText(_("vradi.adminFormType.template.new"));
        newTemplate.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__newTemplate"));
    }

    protected void createTemplateBindingButton() {
        $objectMap.put("templateBindingButton", templateBindingButton = new javax.swing.JButton());
        
        templateBindingButton.setName("templateBindingButton");
        templateBindingButton.setText(_("vradi.adminFormType.template.fieldBinding"));
        templateBindingButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__templateBindingButton"));
    }

    protected void createTemplateChoice() {
        $objectMap.put("templateChoice", templateChoice = new javax.swing.JComboBox());
        
        templateChoice.setName("templateChoice");
        templateChoice.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__templateChoice"));
    }

    protected void createTemplateExampleButton() {
        $objectMap.put("templateExampleButton", templateExampleButton = new javax.swing.JButton());
        
        templateExampleButton.setName("templateExampleButton");
        templateExampleButton.setText(_("vradi.adminFormType.template.showExample"));
        templateExampleButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__templateExampleButton"));
    }

    protected void createTitle() {
        $objectMap.put("title", title = new javax.swing.JLabel());
        
        title.setName("title");
        if (title.getFont() != null) {
            title.setFont(title.getFont().deriveFont((float) 20));
        }
        if (title.getFont() != null) {
            title.setFont(title.getFont().deriveFont(title.getFont().getStyle() | Font.BOLD));
        }
    }

    @Override
    protected void createToolbar() {
        super.createToolbar();
        toolbar.setName("toolbar");
        ((jaxx.runtime.swing.Table) toolbar).setLayout(new BoxLayout(toolbar, 0));
        ((jaxx.runtime.swing.Table) toolbar).putClientProperty("help", "ui.main.toolbar");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToToolbar();
        addChildrenToBody();
        addChildrenToFieldListUI();
        // inline complete setup of $JPanel0
        $JPanel0.add(createField);
        $JPanel0.add($JButton1);
        $JPanel0.add(hidorInfogene, BorderLayout.WEST);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(cardPanel);
        addChildrenToCardPanel();
        // inline complete setup of $JPanel1
        $JPanel1.add($JLabel1);
        $JPanel1.add(templateChoice);
        $JPanel1.add(newTemplate);
        $JPanel1.add(downloadTemplate);
        $JPanel1.add(templateBindingButton);
        $JPanel1.add(templateExampleButton);
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 15 property setters
        cardLayout.setUseOnlyVisibleComponentDimension(true);
        $JButton0.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("client.delete"));
        createField.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("add"));
        $JButton1.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("delete"));
        hidorInfogene.setHideText(_("vradi.adminFormType.hideInfogene"));
        hidorInfogene.setShowText(_("vradi.adminFormType.showInfogene"));
        hidorInfogene.setTarget(new jaxx.runtime.swing.Spacer());
        hidorInfogene.setTargetVisible(false);
        templateChoice.setRenderer(VradiContext.get().getDecoratorProviderListCellRenderer());
        title.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        title.setHorizontalTextPosition(JLabel.LEFT);
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$AdminContentUI0", this);
        createBean();
        createCardLayout();
        createTitle();
        createCreateForm();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setToolTipText(_("vradi.adminForm.deleteFormType"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        createFieldListUI();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminField.title"));
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        
        $JPanel0.setName("$JPanel0");
        createCreateField();
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new javax.swing.JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setToolTipText(_("vradi.adminFormType.deleteFormType"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        createHidorInfogene();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createCardPanel();
        createContent();
        createInfogene();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new javax.swing.JPanel());
        
        $JPanel1.setName("$JPanel1");
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.adminFormType.template.label"));
        createTemplateChoice();
        createNewTemplate();
        createDownloadTemplate();
        createTemplateBindingButton();
        createTemplateExampleButton();
        createLastModified();
        // inline creation of $AdminContentUI0
        setName("$AdminContentUI0");
        ((jaxx.runtime.swing.Table) $AdminContentUI0.getObjectById("toolbar")).setLayout(new BoxLayout(toolbar, 0));
        
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$ADMIN_CONTENT_UI0_ENABLED, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                setEnabled(getBean() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_ENABLED, true ,"enabled" ,"inCreation") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setEnabled(isEnabled() && !isInCreation());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON1_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                $JButton1.setEnabled(isEnabled());
            }
        });
    }

}