/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.admin.content.*;
import com.jurismarches.vradi.ui.admin.helpers.AdminBeanConstant;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.text.DateFormat;
import java.util.*;
import java.util.Date;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.HidorButton;
import jaxx.runtime.swing.ListSelectorUI;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.SwingUtil.getStringValue;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class AdminClientUI extends com.jurismarches.vradi.ui.admin.AdminContentUI<Client> implements jaxx.runtime.JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_IN_GROUP = "inGroup";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CLIENT_ADDRESS_TEXT = "clientAddress.text";
    public static final String BINDING_CLIENT_CONTACT_TEXT = "clientContact.text";
    public static final String BINDING_CLIENT_NAME_TEXT = "clientName.text";
    public static final String BINDING_CLIENT_PHONE_TEXT = "clientPhone.text";
    public static final String BINDING_CREATE_BUTTON_ENABLED = "createButton.enabled";
    public static final String BINDING_CREATE_BUTTON_VISIBLE = "createButton.visible";
    public static final String BINDING_TITLE_TEXT = "title.text";
    public static final String BINDING_VALIDATOR_BEAN = "validator.bean";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$ADMIN_CONTENT_UI0_ENABLED = "$AdminContentUI0.enabled";
    private static final String BINDING_$JBUTTON0_ENABLED = "$JButton0.enabled";
    private static final String BINDING_$JBUTTON0_VISIBLE = "$JButton0.visible";
    private static final String BINDING_$JBUTTON1_ENABLED = "$JButton1.enabled";
    private static final String BINDING_$JBUTTON1_VISIBLE = "$JButton1.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.content.AdminClientUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table adminClientForm;
    protected com.jurismarches.vradi.entities.Client bean;
    protected javax.swing.JTextField clientAddress;
    protected javax.swing.JTextField clientContact;
    protected javax.swing.JTextField clientName;
    protected javax.swing.JTextField clientPhone;
    protected javax.swing.JButton createButton;
    protected java.lang.Boolean inGroup;
    protected javax.swing.JLabel title;
    protected jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.entities.Client > validator;
    protected java.util.List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private AdminClientUI $AdminContentUI0 = this;
    private javax.swing.JPanel $JPanel0;
    private javax.swing.JButton $JButton0;
    private javax.swing.JButton $JButton1;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.JButton $JButton2;
    private javax.swing.JLabel $JLabel2;
    private javax.swing.JLabel $JLabel3;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void $afterCompleteSetup() {
        errorTable.registerValidator(validator);
    }
    
    @Override
    protected void postLoadBean() {
    
        createButton.setEnabled(!isInCreation());
    
        VradiTreeNode parentNode = getHelper().getParentCategoryNode(getHelper().getSelectedNode(), AdminBeanConstant.GROUP.getCategoryName());
        setInGroup(parentNode != null);
    }
    
    @Override
    public void save() {
    
        Client client = getHandler().saveClient(this, getHelper(), bean, null);
    
        //FIXME JC 25/08/2010 bean is the same (because of cache ?) so no property change fired. Set bean to null before to force fire.
        setModified(false);
        setBean(null);
        setBean(client);
    
    }
    
    @Override
    protected void clearUI() {
        title.setText(updateTitle(""));
        clientName.setText("");
        clientAddress.setText("");
        clientPhone.setText("");
        clientContact.setText("");
    }
    
    protected String updateTitle(String name) {
       return _("vradi.adminClient.title", getStringValue(name));
    }
    
    protected void openAddressInBrowser() {
        UIHelper.openAddressInBrowser(bean.getAddress());
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminClientUI() {
        super();
        $initialize();
    }

    public AdminClientUI(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidation implementation --------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.entities.Client > getValidator() {
        return validator;
    }

    @Override
    public jaxx.runtime.validator.swing.SwingValidator<?> getValidator(String validatorId) {
        return (jaxx.runtime.validator.swing.SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public java.util.List<String> getValidatorIds() {
        return validatorIds;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        getHandler().createUser(this, getHelper().getClientSelected());
    }

    public void doActionPerformed__on__$JButton1(java.awt.event.ActionEvent event) {
        getHandler().delete(this, getHelper(), getBean());
    }

    public void doActionPerformed__on__$JButton2(java.awt.event.ActionEvent event) {
        openAddressInBrowser();
    }

    public void doActionPerformed__on__createButton(java.awt.event.ActionEvent event) {
        getHandler().createClient(this);                                 setModified(true);
    }

    public void doKeyReleased__on__clientAddress(java.awt.event.KeyEvent event) {
        getBean().setAddress(clientAddress.getText());
    }

    public void doKeyReleased__on__clientContact(java.awt.event.KeyEvent event) {
        getBean().setContact(clientContact.getText());
    }

    public void doKeyReleased__on__clientName(java.awt.event.KeyEvent event) {
        getBean().setName(clientName.getText());                                                title.setText(updateTitle(getBean().getName()));
    }

    public void doKeyReleased__on__clientPhone(java.awt.event.KeyEvent event) {
        getBean().setPhone(clientPhone.getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.swing.Table getAdminClientForm() {
        return adminClientForm;
    }

    public com.jurismarches.vradi.entities.Client getBean() {
        return bean;
    }

    public javax.swing.JTextField getClientAddress() {
        return clientAddress;
    }

    public javax.swing.JTextField getClientContact() {
        return clientContact;
    }

    public javax.swing.JTextField getClientName() {
        return clientName;
    }

    public javax.swing.JTextField getClientPhone() {
        return clientPhone;
    }

    public javax.swing.JButton getCreateButton() {
        return createButton;
    }

    public java.lang.Boolean getInGroup() {
        return inGroup;
    }

    public javax.swing.JLabel getTitle() {
        return title;
    }

    public java.lang.Boolean isInGroup() {
        return inGroup !=null && inGroup;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(com.jurismarches.vradi.entities.Client newValue) {
        com.jurismarches.vradi.entities.Client oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange(PROPERTY_BEAN, oldValue, newValue);
    }

    public void setInGroup(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.inGroup;
        this.inGroup = newValue;
        firePropertyChange(PROPERTY_IN_GROUP, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerValidatorFields() {
        validator.setFieldRepresentation("name", clientName);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JButton get$JButton1() {
        return $JButton1;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.JButton get$JButton2() {
        return $JButton2;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected javax.swing.JLabel get$JLabel3() {
        return $JLabel3;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAdminClientForm() {
        if (!allComponentsCreated) {
            return;
        }
        adminClientForm.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminClientForm.add(SwingUtil.boxComponentWithJxLayer(clientName), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminClientForm.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminClientForm.add(clientAddress, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminClientForm.add($JButton2, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        adminClientForm.add($JLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminClientForm.add(clientPhone, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminClientForm.add($JLabel3, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminClientForm.add(clientContact, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add(adminClientForm, BorderLayout.NORTH);
    }

    protected void addChildrenToToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        toolbar.add(title, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        toolbar.add($JPanel0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(jaxx.runtime.validator.swing.ui.ImageValidationUI.class);
    }

    protected void createAdminClientForm() {
        $objectMap.put("adminClientForm", adminClientForm = new jaxx.runtime.swing.Table());
        
        adminClientForm.setName("adminClientForm");
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createClientAddress() {
        $objectMap.put("clientAddress", clientAddress = new javax.swing.JTextField());
        
        clientAddress.setName("clientAddress");
        clientAddress.setColumns(15);
        clientAddress.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__clientAddress"));
    }

    protected void createClientContact() {
        $objectMap.put("clientContact", clientContact = new javax.swing.JTextField());
        
        clientContact.setName("clientContact");
        clientContact.setColumns(15);
        clientContact.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__clientContact"));
    }

    protected void createClientName() {
        $objectMap.put("clientName", clientName = new javax.swing.JTextField());
        
        clientName.setName("clientName");
        clientName.setColumns(15);
        clientName.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__clientName"));
    }

    protected void createClientPhone() {
        $objectMap.put("clientPhone", clientPhone = new javax.swing.JTextField());
        
        clientPhone.setName("clientPhone");
        clientPhone.setColumns(15);
        clientPhone.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__clientPhone"));
    }

    protected void createCreateButton() {
        $objectMap.put("createButton", createButton = new javax.swing.JButton());
        
        createButton.setName("createButton");
        createButton.setText(_("vradi.adminClient.createClient"));
        createButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createButton"));
    }

    protected void createInGroup() {
        $objectMap.put("inGroup", inGroup = null);
    }

    protected void createTitle() {
        $objectMap.put("title", title = new javax.swing.JLabel());
        
        title.setName("title");
        if (title.getFont() != null) {
            title.setFont(title.getFont().deriveFont((float) 20));
        }
        if (title.getFont() != null) {
            title.setFont(title.getFont().deriveFont(title.getFont().getStyle() | Font.BOLD));
        }
    }

    @Override
    protected void createToolbar() {
        super.createToolbar();
        toolbar.setName("toolbar");
        ((jaxx.runtime.swing.Table) toolbar).setLayout(new BoxLayout(toolbar, 0));
        ((jaxx.runtime.swing.Table) toolbar).putClientProperty("help", "ui.main.toolbar");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = new jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.entities.Client >(com.jurismarches.vradi.entities.Client.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToValidator();
        addChildrenToToolbar();
        // inline complete setup of $JPanel0
        $JPanel0.add(createButton);
        $JPanel0.add($JButton0);
        $JPanel0.add($JButton1);
        addChildrenToBody();
        addChildrenToAdminClientForm();
        
        // apply 13 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 8 property setters
        createButton.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("client.add"));
        $JButton1.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("client.delete"));
        adminClientForm.setMinimumSize(SwingUtil.newMinDimension());
        $JButton2.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("site"));
        title.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        title.setHorizontalTextPosition(JLabel.LEFT);
        // late initializer
        // register 1 validator(s)
        registerValidatorFields();validatorIds.add("validator");
        getValidator("validator").installUIs();
        getValidator("validator").reloadBean();
        validatorIds = java.util.Collections.unmodifiableList(validatorIds);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$AdminContentUI0", this);
        createBean();
        createInGroup();
        createValidator();
        createTitle();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        
        $JPanel0.setName("$JPanel0");
        createCreateButton();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("vradi.adminClient.createUser"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new javax.swing.JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setToolTipText(_("vradi.adminClient.deleteClient"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        createAdminClientForm();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminClient.name"));
        createClientName();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.adminClient.adresse"));
        createClientAddress();
        // inline creation of $JButton2
        $objectMap.put("$JButton2", $JButton2 = new javax.swing.JButton());
        
        $JButton2.setName("$JButton2");
        $JButton2.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton2"));
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new javax.swing.JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("vradi.adminClient.tel"));
        createClientPhone();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new javax.swing.JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("vradi.adminClient.contact"));
        createClientContact();
        // inline creation of $AdminContentUI0
        setName("$AdminContentUI0");
        ((jaxx.runtime.swing.Table) $AdminContentUI0.getObjectById("toolbar")).setLayout(new BoxLayout(toolbar, 0));
        
        
        // registers 13 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 13 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$ADMIN_CONTENT_UI0_ENABLED, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                setEnabled(getBean() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_BEAN, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                validator.setBean(isEnabled() ? bean : null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TITLE_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    title.setText(_(updateTitle(getBean().getName())));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CREATE_BUTTON_ENABLED, true ,"inCreation") {
        
            @Override
            public void processDataBinding() {
                createButton.setEnabled(!isInCreation());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CREATE_BUTTON_VISIBLE, true ,"inGroup") {
        
            @Override
            public void processDataBinding() {
                createButton.setVisible(!isInGroup());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_ENABLED, true ,"enabled" ,"inCreation") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setEnabled(isEnabled() && !isInCreation());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_VISIBLE, true ,"inGroup") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setVisible(!isInGroup());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON1_ENABLED, true ,"enabled" ,"inCreation") {
        
            @Override
            public void processDataBinding() {
                $JButton1.setEnabled(isEnabled() && !isInCreation());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON1_VISIBLE, true ,"inGroup") {
        
            @Override
            public void processDataBinding() {
                $JButton1.setVisible(!isInGroup());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CLIENT_NAME_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    jaxx.runtime.SwingUtil.setText(clientName, getBean().getName());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CLIENT_ADDRESS_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    jaxx.runtime.SwingUtil.setText(clientAddress, getBean().getAddress());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CLIENT_PHONE_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    jaxx.runtime.SwingUtil.setText(clientPhone, getBean().getPhone());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CLIENT_CONTACT_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    jaxx.runtime.SwingUtil.setText(clientContact, getBean().getContact());
                }
            }
        });
    }

}