/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.services;

import com.arjuna.ats.jta.TransactionManager;
import com.arjuna.ats.jta.UserTransaction;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyException;

public class WikittyTransaction {
    private static Log log = LogFactory.getLog(WikittyTransaction.class);
    protected Map<Object, Object> tagValues = new HashMap<Object, Object>();
    protected boolean started = false;
    private static ThreadLocal<WikittyTransaction> wikittyTransaction = new ThreadLocal<WikittyTransaction>(){

        @Override
        protected synchronized WikittyTransaction initialValue() {
            return new WikittyTransaction();
        }
    };

    private WikittyTransaction() {
    }

    public static WikittyTransaction get() {
        return wikittyTransaction.get();
    }

    public Object getTagValue(Object tag) {
        return this.tagValues.get(tag);
    }

    public void setTagValue(Object tag, Object value) {
        this.tagValues.put(tag, value);
    }

    public boolean isStarted() {
        return this.started;
    }

    protected void setStarted(boolean started) {
        this.started = started;
    }

    public javax.transaction.UserTransaction getUserTransaction() {
        return UserTransaction.userTransaction();
    }

    public javax.transaction.TransactionManager getTransactionManager() {
        return TransactionManager.transactionManager();
    }

    public void begin() {
        if (this.isStarted()) {
            throw new WikittyException("Transaction is already started");
        }
        javax.transaction.UserTransaction userTransaction = this.getUserTransaction();
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Begin transaction");
            }
            userTransaction.setTransactionTimeout(3600);
            userTransaction.begin();
            this.setStarted(true);
        }
        catch (Exception eee) {
            throw new WikittyException("Error on begin JTA transaction", eee);
        }
    }

    public void commit() {
        javax.transaction.UserTransaction userTransaction = this.getUserTransaction();
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Commit transaction");
            }
            userTransaction.commit();
            this.setStarted(false);
        }
        catch (Exception eee) {
            throw new WikittyException("Error on commit JTA transaction", eee);
        }
    }

    public void rollback() {
        javax.transaction.UserTransaction userTransaction = this.getUserTransaction();
        try {
            if (userTransaction.getStatus() != 6 && userTransaction.getStatus() != 5) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Rollback transaction");
                }
                userTransaction.rollback();
            }
            this.setStarted(false);
        }
        catch (Exception eee) {
            throw new WikittyException("Error on roolback JTA transaction", eee);
        }
    }
}

