/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.highlight;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.search.highlight.PositionSpan;
import org.apache.lucene.search.highlight.WeightedTerm;

public class WeightedSpanTerm
extends WeightedTerm {
    boolean positionSensitive;
    private List positionSpans = new ArrayList();

    public WeightedSpanTerm(float weight, String term) {
        super(weight, term);
        this.positionSpans = new ArrayList();
    }

    public WeightedSpanTerm(float weight, String term, boolean positionSensitive) {
        super(weight, term);
        this.positionSensitive = positionSensitive;
    }

    public boolean checkPosition(int position) {
        Iterator positionSpanIt = this.positionSpans.iterator();
        while (positionSpanIt.hasNext()) {
            PositionSpan posSpan = (PositionSpan)positionSpanIt.next();
            if (position < posSpan.start || position > posSpan.end) continue;
            return true;
        }
        return false;
    }

    public void addPositionSpans(List positionSpans) {
        this.positionSpans.addAll(positionSpans);
    }

    public boolean isPositionSensitive() {
        return this.positionSensitive;
    }

    public void setPositionSensitive(boolean positionSensitive) {
        this.positionSensitive = positionSensitive;
    }

    public List getPositionSpans() {
        return this.positionSpans;
    }
}

