/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.abstractrecords;

import com.arjuna.ats.arjuna.StateManager;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.ObjectStore;
import com.arjuna.ats.arjuna.objectstore.ObjectStoreType;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.arjuna.abstractrecords.RecoveryRecord;
import java.io.IOException;
import java.io.PrintWriter;

public class PersistenceRecord
extends RecoveryRecord {
    public static final int MAX_OBJECT_SIZE = 4096;
    protected boolean shadowMade;
    protected ObjectStore store;
    protected OutputObjectState topLevelState;
    protected static boolean classicPrepare = false;
    private static boolean writeOptimisation = false;

    public PersistenceRecord(OutputObjectState os, ObjectStore objStore, StateManager sm) {
        super(os, sm);
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug(1L, 4L, 8L, "PersistenceRecord::PersistenceRecord(" + os + ", " + sm.get_uid() + ")");
        }
        this.shadowMade = false;
        this.store = objStore;
        this.topLevelState = null;
    }

    @Override
    public int typeIs() {
        return 111;
    }

    @Override
    public int topLevelAbort() {
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug(16L, 4L, 8L, "PersistenceRecord::topLevelAbort() for " + this.order());
        }
        Uid uid = null;
        String type = null;
        if (this.shadowMade) {
            uid = this.order();
            type = this.getTypeOfObject();
        } else {
            if (this.topLevelState == null) {
                return this.nestedAbort();
            }
            uid = this.topLevelState.stateUid();
            type = this.topLevelState.type();
        }
        try {
            if (!this.store.remove_uncommitted(uid, type)) {
                if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.PersistenceRecord_19");
                }
                return 8;
            }
        }
        catch (ObjectStoreException e) {
            if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.PersistenceRecord_20", new Object[]{e}, e);
            }
            return 8;
        }
        return this.nestedAbort();
    }

    @Override
    public int topLevelCommit() {
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug(16L, 4L, 8L, "PersistenceRecord::topLevelCommit() for " + this.order());
        }
        if (tsLogger.arjLoggerI18N.isDebugEnabled()) {
            tsLogger.arjLoggerI18N.debug(16L, 4L, 8L, "com.arjuna.ats.arjuna.PersistenceRecord_1", new Object[]{this.order(), this.getTypeOfObject()});
        }
        if (tsLogger.arjLogger.isDebugEnabled()) {
            if (this.store != null) {
                tsLogger.arjLogger.debug(16L, 4L, 8L, ", store = " + this.store + "(" + this.store.typeIs() + ")");
            } else {
                tsLogger.arjLogger.debug(16L, 4L, 8L, "");
            }
        }
        boolean result = false;
        if (this.store != null) {
            try {
                if (this.shadowMade) {
                    result = this.store.commit_state(this.order(), super.getTypeOfObject());
                    if (!result && tsLogger.arjLoggerI18N.isWarnEnabled()) {
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.PersistenceRecord_2", new Object[]{this.order()});
                    }
                } else if (this.topLevelState != null) {
                    result = this.store.write_committed(this.order(), super.getTypeOfObject(), this.topLevelState);
                } else if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.PersistenceRecord_3");
                }
            }
            catch (ObjectStoreException e) {
                if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.PersistenceRecord_4", new Object[]{e});
                }
                result = false;
            }
        } else if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.PersistenceRecord_5");
        }
        if (!result && tsLogger.arjLoggerI18N.isWarnEnabled()) {
            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.PersistenceRecord_6");
        }
        super.forgetAction(true);
        return result ? 7 : 8;
    }

    @Override
    public int topLevelPrepare() {
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug(16L, 4L, 8L, "PersistenceRecord::topLevelPrepare() for " + this.order());
        }
        int result = 1;
        StateManager sm = this.objectAddr;
        if (sm != null && this.store != null) {
            this.topLevelState = new OutputObjectState(sm.get_uid(), sm.type());
            if (writeOptimisation && !this.store.fullCommitNeeded() && sm.save_state(this.topLevelState, 1) && this.topLevelState.size() <= 4096) {
                if (classicPrepare) {
                    OutputObjectState dummy = new OutputObjectState(Uid.nullUid(), null);
                    try {
                        this.store.write_uncommitted(sm.get_uid(), sm.type(), dummy);
                        result = 0;
                    }
                    catch (ObjectStoreException e) {
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.PersistenceRecord_21", e);
                    }
                    Object var3_3 = null;
                } else {
                    result = 0;
                }
            } else if (sm.deactivate(this.store.getStoreName(), false)) {
                this.shadowMade = true;
                result = 0;
            } else if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.PersistenceRecord_7");
            }
        } else if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.PersistenceRecord_8");
        }
        return result;
    }

    @Override
    public int topLevelCleanup() {
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug(16L, 4L, 8L, "PersistenceRecord::topLevelCleanup() for " + this.order());
        }
        return 7;
    }

    @Override
    public boolean doSave() {
        return true;
    }

    @Override
    public boolean restore_state(InputObjectState os, int ot) {
        boolean res;
        block8: {
            if (tsLogger.arjLogger.isDebugEnabled()) {
                tsLogger.arjLogger.debug(16L, 4L, 8L, "PersistenceRecord::restore_state() for " + this.order());
            }
            res = false;
            int objStoreType = 0;
            this.topLevelState = null;
            try {
                objStoreType = os.unpackInt();
                if (tsLogger.arjLoggerI18N.isDebugEnabled()) {
                    tsLogger.arjLoggerI18N.debug(16L, 4L, 8L, "com.arjuna.ats.arjuna.PersistenceRecord_9", new Object[]{Integer.toString(objStoreType)});
                }
                if (ObjectStoreType.valid(objStoreType)) {
                    if (this.store == null) {
                        Class oc = ObjectStoreType.typeToClass(objStoreType);
                        this.store = (ObjectStore)oc.newInstance();
                    }
                    this.store.unpack(os);
                    this.shadowMade = os.unpackBoolean();
                    if (!this.shadowMade) {
                        this.topLevelState = new OutputObjectState(os);
                        res = this.topLevelState.valid();
                    } else {
                        res = true;
                    }
                    return res && super.restore_state(os, ot);
                }
            }
            catch (Exception e) {
                if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block8;
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.PersistenceRecord_10");
            }
        }
        return res;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean save_state(OutputObjectState os, int ot) {
        boolean res;
        block14: {
            if (tsLogger.arjLogger.isDebugEnabled()) {
                tsLogger.arjLogger.debug(16L, 4L, 8L, "PersistenceRecord::save_state() for " + this.order());
            }
            res = true;
            if (this.store != null) {
                if (!ObjectStoreType.valid(this.store.typeIs())) {
                    if (!tsLogger.arjLoggerI18N.isWarnEnabled()) return false;
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.PersistenceRecord_11");
                    return false;
                }
                try {
                    os.packInt(this.store.typeIs());
                    if (tsLogger.arjLoggerI18N.isDebugEnabled()) {
                        tsLogger.arjLoggerI18N.debug(16L, 4L, 8L, "com.arjuna.ats.arjuna.PersistenceRecord_12", new Object[]{Integer.toString(this.store.typeIs())});
                    }
                    this.store.pack(os);
                    if (tsLogger.arjLoggerI18N.isDebugEnabled()) {
                        tsLogger.arjLoggerI18N.debug(16L, 4L, 8L, "com.arjuna.ats.arjuna.PersistenceRecord_13");
                    }
                    os.packBoolean(this.shadowMade);
                    if (this.shadowMade) break block14;
                    boolean bl = res = this.topLevelState != null;
                    if (res) {
                        this.topLevelState.packInto(os);
                    } else if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.PersistenceRecord_14");
                    }
                    break block14;
                }
                catch (IOException e) {
                    res = false;
                    if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.PersistenceRecord_15");
                    }
                    break block14;
                }
            }
            if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.PersistenceRecord_16");
            }
            try {
                os.packString(null);
            }
            catch (IOException e) {
                return false;
            }
        }
        if (!res) return false;
        if (!super.save_state(os, ot)) return false;
        return true;
    }

    @Override
    public void print(PrintWriter strm) {
        super.print(strm);
        strm.println("PersistenceRecord with state:\n" + this.state);
    }

    @Override
    public String type() {
        return "/StateManager/AbstractRecord/RecoveryRecord/PersistenceRecord";
    }

    public PersistenceRecord() {
        if (tsLogger.arjLoggerI18N.isDebugEnabled()) {
            tsLogger.arjLoggerI18N.debug(1L, 2L, 8L, "com.arjuna.ats.arjuna.PersistenceRecord_17");
        }
        this.shadowMade = false;
        this.store = null;
        this.topLevelState = null;
    }

    protected boolean shadowForced() {
        if (this.topLevelState == null) {
            this.shadowMade = true;
            return true;
        }
        return false;
    }

    static {
        classicPrepare = arjPropertyManager.getCoordinatorEnvironmentBean().isClassicPrepare();
        writeOptimisation = arjPropertyManager.getCoordinatorEnvironmentBean().isWriteOptimisation();
    }
}

