/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.renderers;

import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.services.VradiService;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;

public class EntityRenderer
extends ObjectToStringConverter
implements ListCellRenderer {
    private static EntityRenderer instance = null;
    protected DefaultListCellRenderer delegate = new DefaultListCellRenderer();

    public String getPreferredStringForItem(Object item) {
        String result = null;
        if (item != null) {
            if (item instanceof User) {
                User user = (User)item;
                String clientId = user.getClient();
                Client client = (Client)VradiService.getWikittyProxy().restore(Client.class, clientId);
                String clientString = "";
                if (client != null) {
                    clientString = client.getName() + " - ";
                }
                result = clientString + user.getName();
            } else if (item instanceof Group) {
                Group group = (Group)item;
                result = group.getName();
            }
        }
        return result;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        return this.delegate.getListCellRendererComponent((JList<?>)list, this.getPreferredStringForItem(value), index, isSelected, cellHasFocus);
    }

    public static EntityRenderer getInstance() {
        if (instance == null) {
            instance = new EntityRenderer();
        }
        return instance;
    }
}

