/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.models;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiEntitiesListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.entities.BusinessEntity;

public class EntityModel<E extends BusinessEntity>
extends AbstractListModel
implements ComboBoxModel,
VradiEntitiesListener<E> {
    private static final Log log = LogFactory.getLog(EntityModel.class);
    protected Map<String, E> datas;
    protected E selected;
    protected boolean firstNull = true;

    public EntityModel(Class<E> clazz, List<E> datas) {
        this(clazz, datas, true);
    }

    public EntityModel(Class<E> clazz, List<E> datas, boolean firstNull) {
        this.firstNull = firstNull;
        this.datas = new HashMap<String, E>();
        this.fillDatas(datas);
        VradiContext.get().getVradiNotifier().addVradiListener(clazz, this);
    }

    protected void fillDatas(List<E> datas) {
        if (datas == null) {
            return;
        }
        for (BusinessEntity data : datas) {
            if (data == null) continue;
            this.datas.put(data.getWikittyId(), data);
        }
    }

    @Override
    public int getSize() {
        if (this.firstNull) {
            return this.datas.size() + 1;
        }
        return this.datas.size();
    }

    @Override
    public Object getElementAt(int index) {
        if (this.firstNull) {
            if (index == 0) {
                return null;
            }
            ArrayList<String> keys = new ArrayList<String>(this.datas.keySet());
            return this.datas.get(keys.get(index - 1));
        }
        ArrayList<String> keys = new ArrayList<String>(this.datas.keySet());
        return this.datas.get(keys.get(index));
    }

    @Override
    public void setSelectedItem(Object anItem) {
        this.selected = (BusinessEntity)anItem;
    }

    @Override
    public Object getSelectedItem() {
        return this.selected;
    }

    protected void updateDatas(List<E> datas) {
        this.fillDatas(datas);
        this.fireContentsChanged(this, 0, datas.size() - 1);
    }

    @Override
    public void entitiesAdded(Set<E> added) {
        for (BusinessEntity entity : added) {
            this.datas.put(entity.getWikittyId(), entity);
        }
        this.fireContentsChanged(this, 0, this.datas.size() - 1);
    }

    @Override
    public void entitiesRemoved(Set<String> removed) {
        for (String wikittyId : removed) {
            this.datas.remove(wikittyId);
        }
        this.fireContentsChanged(this, 0, this.datas.size() - 1);
    }
}

