/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.HidorButton;
import jaxx.runtime.swing.ListSelectorUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ListSelectorHandler<B> {
    public static final Log log = LogFactory.getLog(ListSelectorHandler.class);
    protected ListSelectorUI<B> listSelector;

    public ListSelectorHandler(ListSelectorUI<B> listSelector) {
        this.listSelector = listSelector;
    }

    protected JComboBox getCombo() {
        return this.listSelector.getCombo();
    }

    protected JList getList() {
        return this.listSelector.getList();
    }

    public List<B> getComboDatas() {
        ArrayList datas = new ArrayList();
        ComboBoxModel comboModel = this.getCombo().getModel();
        int j = comboModel.getSize();
        for (int i = 0; i < j; ++i) {
            Object g = comboModel.getElementAt(i);
            datas.add(g);
        }
        return datas;
    }

    public List<B> getListDatas() {
        ArrayList datas = new ArrayList();
        ListModel listModel = this.getList().getModel();
        int j = listModel.getSize();
        for (int i = 0; i < j; ++i) {
            Object g = listModel.getElementAt(i);
            datas.add(g);
        }
        return datas;
    }

    public void init(List<B> toCombo, List<B> toList) {
        this.setComboDatas(toCombo);
        this.setListDatas(toList);
        this.listSelector.setModified(false);
        HidorButton hidor = this.listSelector.getHidor();
        hidor.addPropertyChangeListener("targetVisible", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("target visible changed <" + evt.getOldValue() + ":" + evt.getNewValue() + ">"));
                }
                if (!ListSelectorHandler.this.listSelector.isShowHidor().booleanValue() || !ListSelectorHandler.this.listSelector.isEnabled()) {
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        log.info((Object)("invalidate " + ListSelectorHandler.this.listSelector.getParent().getName()));
                        ListSelectorHandler.this.listSelector.listPane.invalidate();
                    }
                });
            }
        });
    }

    protected void transfertToList(B b) {
        ((DefaultListModel)this.getList().getModel()).addElement(b);
        ((DefaultComboBoxModel)this.getCombo().getModel()).removeElement(b);
        this.listSelector.setModified(true);
    }

    protected void transfertToCombo(B[] bs) {
        for (B b : bs) {
            ((DefaultListModel)this.getList().getModel()).removeElement(b);
            ((DefaultComboBoxModel)this.getCombo().getModel()).addElement(b);
        }
        this.listSelector.setModified(true);
    }

    protected boolean updateAddEnabled(boolean enabled) {
        return enabled && this.getCombo().getModel().getSize() > 0;
    }

    protected boolean updateRemoveEnabled(boolean enabled) {
        return enabled && this.getList().getModel().getSize() > 0;
    }

    protected void setComboDatas(List<B> toCombo) {
        SwingUtil.fillComboBox((JComboBox)this.getCombo(), toCombo, null);
        this.listSelector.processDataBinding("add.enabled");
    }

    protected void setListDatas(List<B> toList) {
        SwingUtil.fillList((JList)this.getList(), toList, null);
    }
}

